VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsResumenSesion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private pSesion As clsSesionPOS
Private bShowSaco As Boolean

Private Const AnchoReporte = 39
' -----------------------
' Resumen de Operaciones
' -----------------------

Private Function MontoGravable() As Currency
Dim rs As Recordset, RetVal As Currency, sQuery As String

  On Error GoTo ErrHandler

  sQuery = "SELECT Sum(R.Cantidad * R.PrecioUnitario) As MontoGravable "
  sQuery = sQuery & "FROM RenglonesFacturaPOS As R, FacturasPOS as F "
  sQuery = sQuery & "WHERE F.IdMaquina = R.IdMaquina "
  sQuery = sQuery & "AND F.NumeroTicket = R.NumeroTicket "
  sQuery = sQuery & "AND F.idSesion = " & NumeroDB(pSesion.SessionID) & " "
  sQuery = sQuery & "AND R.PorcentajeImpuesto <> 0;"

  Set rs = dbHandle.OpenRecordset(sQuery)
  If rs.EOF Then
    RetVal = 0
  Else
    RetVal = GetNumeroFromVariant(rs.Fields("MontoGravable"))
  End If

ResumePoint:

  If Not rs Is Nothing Then
    rs.Close
    Set rs = Nothing
  End If
  MontoGravable = RetVal

  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long

  sErrD = Err.Description: nErrN = Err.Number
  ReportarError False, nErrN, sErrD, "clsResumenSesion::MontoGravable"
  Resume ResumePoint

End Function

Private Function MontoExento() As Currency
Dim rs As Recordset, RetVal As Currency
  MontoExento = pSesion.MontoFacturado - pSesion.MontoAnulaciones - MontoGravable
End Function

Private Sub PasarResumenLineas(lngNumero As Long, pView As lfQuickView)
Dim rs As Recordset, sQry As String
Dim totUnidades As Double, TotValor As Currency

  If Not CBool(GetSetting(AppName, "General", "ListarVentaLineasXZ", "0")) Then Exit Sub
  pView.Add "VENTA POR LINEAS", vbCenter
  
  totUnidades = 0: TotValor = 0

  sQry = "SELECT I.Linea, Sum(R.PrecioUnitario * R.Cantidad) AS Valor, Sum(R.Cantidad) AS Unidades "
  sQry = sQry & "FROM RenglonesFacturaPOS AS R, ItemsVenta AS I, FacturasPOS as F "
  sQry = sQry & "WHERE r.idMaquina = f.idMaquina AND r.numeroTicket = f.NumeroTicket AND f.idSesion = " & lngNumero & " AND r.Producto = i.Codigo "
  sQry = sQry & "GROUP BY I.Linea ORDER BY I.Linea;"

  Set rs = dbHandle.OpenRecordset(sQry, dbOpenForwardOnly)
  Do While Not rs.EOF
    totUnidades = totUnidades + GetNumeroFromVariant(rs.Fields("Unidades"))
    TotValor = TotValor + GetNumeroFromVariant(rs.Fields("Valor"))
    pView.Add _
        stFullLength(stGetStringFromVariant(rs.Fields("Linea")), 14) & _
        FormatNumero(GetNumeroFromVariant(rs.Fields("Unidades")), "###,##0", 7) & _
        FormatNumero(GetNumeroFromVariant(rs.Fields("Valor")), Empresa.MascaraMonetarios, 18)
    
    rs.MoveNext
  Loop
  Set rs = Nothing

'    If bShowSaco Then
'        pView.Add _
'            stFullLength("OTROS", 14) & _
'            stFullLength("1", 7) & _
'            FormatNumero(MontoSaco(lngNumero), Empresa.MascaraMonetarios, 18)
'        TotValor = TotValor + MontoSaco(lngNumero)
'    End If

  pView.Add String(AnchoReporte, "-")
  pView.Add _
      stFullLength("TOTAL", 14) & _
      FormatNumero(totUnidades, "###,##0", 7) & _
      FormatNumero(TotValor, Empresa.MascaraMonetarios, 18)
  pView.Add String(AnchoReporte, "=")
  
' ADICION: Artculos con Precio de Venta = 0
  sQry = "SELECT I.Linea, Sum(R.Cantidad) AS Unidades "
  sQry = sQry & "FROM RenglonesFacturaPOS AS R, ItemsVenta AS I, FacturasPOS as F "
  sQry = sQry & "WHERE r.idMaquina = f.idMaquina AND r.numeroTicket = f.NumeroTicket AND f.idSesion = " & lngNumero & " AND r.Producto = i.Codigo AND R.PrecioUnitario < 0.01 "
  sQry = sQry & "GROUP BY I.Linea ORDER BY I.Linea;"

  Set rs = dbHandle.OpenRecordset(sQry, dbOpenForwardOnly)
  If Not rs.EOF Then
    pView.Add "VENTAS CON PRECIO CERO", vbCenter
    totUnidades = 0
    Do While Not rs.EOF
      totUnidades = totUnidades + GetNumeroFromVariant(rs.Fields("Unidades"))
      pView.Add _
          stFullLength(stGetStringFromVariant(rs.Fields("Linea")), 14) & _
          FormatNumero(GetNumeroFromVariant(rs.Fields("Unidades")), "###,##0", 7)
      rs.MoveNext
    Loop
    pView.Add String(AnchoReporte, "-")
    pView.Add _
      stFullLength("TOTAL", 14) & _
      FormatNumero(totUnidades, "###,##0", 7)
    pView.Add String(AnchoReporte, "=")
  End If
  
  Set rs = Nothing

End Sub

Public Sub ListadoResumen(ilngNumeroSesion As Long, doShowSaco As Boolean)
Dim f As lfQuickView, dblMontoDebidoCaja As Currency
Dim vmTotalVentas As Currency, vDireccion As Variant, i As Integer
Dim pMedios As clsCuentaMedios

'    bShowSaco = doShowSaco
'    bShowSaco = False

  Set pSesion = New clsSesionPOS
  If Not pSesion.Load(ilngNumeroSesion) Then
      Set pSesion = Nothing
      Exit Sub
  End If

  Set f = New lfQuickView
  f.SetReportWidth AnchoReporte
  f.Caption = "Sesin de caja N " & ilngNumeroSesion & ". Terminal " & pSesion.MachineID & ". Operador: " & pSesion.usrID
'    If bShowSaco Then
'        f.cbImprimir.Enabled = False
'    End If

' Adaptado...

  f.Add ""
  vDireccion = Convert2Lines(Empresa.NombreEmpresa, 30)
  For i = 1 To UBound(vDireccion)
      f.Add CStr(vDireccion(i)), vbCenter
  Next
  f.Add "RIF. " & Empresa.RIF, vbCenter
  If Empresa.Direccion <> "" Then
    vDireccion = Convert2Lines(Empresa.Direccion, 40)
    For i = 1 To UBound(vDireccion)
        f.Add CStr(vDireccion(i)), vbCenter
    Next
  End If
  f.Add ""
  f.Add "RESUMEN DE TURNO (X)", vbCenter
  f.Add ""
  f.Add "Emisin   : " & Format(Date, "Short Date") & ", " & Format(Now, "Short Time")
  f.Add "Supervisor: " & UsuarioActivo.Codigo
  f.Add ""
  f.Add "Sesion No : " & Format(pSesion.SessionID, "000000")
  f.Add "Apertura  : " & Format(pSesion.Fecha, "Short Date") & "," & Format(pSesion.StartTime, "Short Time")
  f.Add "Listado   : " & Format(Date, "Short Date") & "," & Format(Now, "Short Time")
  f.Add "Operador  : " & pSesion.usrID
  f.Add "Terminal  : " & pSesion.MachineID
  f.Add String(AnchoReporte, "=")
  f.Add "Facturas  : " & pSesion.FacturasRealizadas
  f.Add "Inicial   : " & pSesion.NumeroPrimeraFactura
  f.Add "Final     : " & pSesion.NumeroUltimaFactura
  f.Add String(AnchoReporte, "=")
  
  If GetSetting("ClearLight", "General", "ListarPAX", "NO") <> "NO" Then
  Dim rs As Recordset
    Set rs = dbHandle.OpenRecordset("SELECT SUM(Personas) AS TotCubiertos, Sum(MontoVenta) / Sum(Personas) AS MediaCubiertos, Count(NumeroTicket) AS qFact, Avg(MontoVenta) AS MediaFact From FacturasPos WHERE idSesion = " & NumeroDB(pSesion.SessionID), dbOpenForwardOnly)
    If Not rs.EOF Then
      f.Add "Cubiertos     :" & FormatNumero(GetNumeroFromVariant(rs.Fields("TotCubiertos")), "##,##0", 21)
      f.Add "Media Cubierto:" & FormatNumero(GetNumeroFromVariant(rs.Fields("MediaCubiertos")), "#,###,##0.00", 24)
      f.Add "Media Factura :" & FormatNumero(GetNumeroFromVariant(rs.Fields("MediaFact")), "#,###,##0.00", 24)
      f.Add String(AnchoReporte, "=")
    End If
    rs.Close
    Set rs = Nothing
    f.Add String(AnchoReporte, "=")
  End If

  vmTotalVentas = (pSesion.MontoFacturado - pSesion.MontoAnulaciones + pSesion.ImpuestoCobrado - pSesion.ImpuestoAnulado)
  
  f.Add stFullLength("Monto facturado", 26) & FormatNumero(pSesion.MontoFacturado, Empresa.MascaraMonetarios, 13)
  If pSesion.ImpuestoCobrado > 0 Then
    f.Add stFullLength("I.V.A. cobrado", 26) & FormatNumero(pSesion.ImpuestoCobrado, Empresa.MascaraMonetarios, 13)
  End If
  If pSesion.ServicioCobrado > 0 Then
    f.Add stFullLength("Servicio cobrado", 26) & FormatNumero(pSesion.ServicioCobrado, Empresa.MascaraMonetarios, 13)
  End If
  If pSesion.ServicioCobrado > 0 Or pSesion.ImpuestoCobrado > 0 Then
    f.Add stFullLength("FACTURACION BRUTA", 26) & FormatNumero(pSesion.ServicioCobrado + pSesion.ImpuestoCobrado + pSesion.MontoFacturado, Empresa.MascaraMonetarios, 13)
  End If
  
  If pSesion.MontoAnulaciones > 0 Then
    f.Add stFullLength("Anuladas  (" & Trim(Str(pSesion.Anulaciones)) & ")", 26) & FormatNumero(pSesion.MontoAnulaciones, Empresa.MascaraMonetarios, 13)
    If pSesion.ServicioAnulado > 0 Then
      f.Add stFullLength("Servicio anulado", 26) & FormatNumero(pSesion.ServicioAnulado, Empresa.MascaraMonetarios, 13)
    End If
    If pSesion.ImpuestoAnulado > 0 Then
      f.Add stFullLength("Impuesto anulado", 26) & FormatNumero(pSesion.ImpuestoAnulado, Empresa.MascaraMonetarios, 13)
    End If
    If pSesion.ServicioAnulado > 0 Or pSesion.ImpuestoAnulado > 0 Then
      f.Add stFullLength("TOTAL ANULADO", 26) & FormatNumero(pSesion.MontoAnulaciones + pSesion.ImpuestoAnulado + pSesion.ServicioAnulado, Empresa.MascaraMonetarios, 13)
    End If
  End If
  
  f.Add stFullLength("INGRESO NETO", 26) & FormatNumero(vmTotalVentas, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("Exento", 26) & FormatNumero(MontoExento, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("Gravable", 26) & FormatNumero(MontoGravable, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("Impuesto", 26) & FormatNumero(pSesion.ImpuestoCobrado - pSesion.ImpuestoAnulado, Empresa.MascaraMonetarios, 13)
  f.Add String(AnchoReporte, "=")

  PasarResumenLineas pSesion.SessionID, f

  f.Add stFullLength("TOTAL VENTAS DE CONTADO", 26) & FormatNumero(pSesion.MontoFacturado - pSesion.MontoAnulaciones - pSesion.VentasACredito, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("TOTAL VENTAS A CREDITO", 26) & FormatNumero(pSesion.VentasACredito, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("TOTAL VENTAS", 26) & FormatNumero(pSesion.MontoFacturado - pSesion.MontoAnulaciones, Empresa.MascaraMonetarios, 13)
  f.Add String(AnchoReporte, "-")
  
  f.Add stFullLength("VENTAS DE CONTADO", 26) & FormatNumero(pSesion.MontoFacturado - pSesion.MontoAnulaciones - pSesion.VentasACredito, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("IMPUESTOS", 26) & FormatNumero(pSesion.ImpuestoCobrado - pSesion.ImpuestoAnulado, Empresa.MascaraMonetarios, 13)
  If pSesion.ServicioCobrado - pSesion.ServicioAnulado > 0 Then
    f.Add stFullLength("SERVICIO", 26) & FormatNumero(pSesion.ServicioCobrado - pSesion.ServicioAnulado, Empresa.MascaraMonetarios, 13)
  End If
  If pSesion.Propinas > 0 Then
    f.Add stFullLength("PROPINAS", 26) & FormatNumero(pSesion.Propinas, Empresa.MascaraMonetarios, 13)
  End If
  If pSesion.MontoCobrado > 0 Then
    f.Add stFullLength("COBROS", 26) & FormatNumero(pSesion.MontoCobrado, Empresa.MascaraMonetarios, 13)
  End If
  f.Add String(AnchoReporte, "-")
  f.Add stFullLength("TOTAL INGRESOS CAJA", 26) & FormatNumero((pSesion.Propinas + pSesion.MontoCobrado + pSesion.ServicioCobrado - pSesion.ServicioAnulado + pSesion.ImpuestoCobrado - pSesion.ImpuestoAnulado + pSesion.MontoFacturado - pSesion.MontoAnulaciones - pSesion.VentasACredito), Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("EGRESOS", 26) & FormatNumero(pSesion.MontoRetirado, Empresa.MascaraMonetarios, 13)
'  f.Add stFullLength("VENTAS A CREDITO", 26) & FormatNumero(pSesion.VentasACredito, Empresa.MascaraMonetarios, 13)
  f.Add String(AnchoReporte, "-")

  dblMontoDebidoCaja = pSesion.TotalEntradas - pSesion.TotalSalidas - pSesion.VentasACredito
  f.Add stFullLength("NETO EN CAJA", 26) & FormatNumero(dblMontoDebidoCaja, Empresa.MascaraMonetarios, 13)

  If pSesion.MontoEnCaja <> 0 Then
    f.Add stFullLength("MONTO REPORTADO", 26) & FormatNumero(pSesion.MontoEnCaja, Empresa.MascaraMonetarios, 13)
    f.Add stFullLength("DIFERENCIA", 26) & FormatNumero(pSesion.MontoEnCaja - dblMontoDebidoCaja, Empresa.MascaraMonetarios, 13)
  End If

  f.Add ""
  Set pMedios = New clsCuentaMedios
  pMedios.Load ilngNumeroSesion
  f.Add "MEDIOS DE PAGO:"
  f.Add stFullLength("EFECTIVO ", 20) & FormatNumero(pMedios.qEfectivo, "#,##0", 5) & " " & FormatNumero(pSesion.EfectivoEnCaja, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("CHEQUES ", 20) & FormatNumero(pMedios.qCheques, "#,##0", 5) & " " & FormatNumero(pSesion.ChequesEnCaja, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("VISA ", 20) & FormatNumero(pMedios.qVisa, "#,##0", 5) & " " & FormatNumero(pSesion.TTCVisa, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("MASTER ", 20) & FormatNumero(pMedios.qMaster, "#,##0", 5) & " " & FormatNumero(pSesion.TTCMaster, Empresa.MascaraMonetarios, 13)
  If pSesion.TTCAmex > 0 Then
    f.Add stFullLength("AMEX ", 20) & FormatNumero(pMedios.qAmex, "#,##0", 5) & " " & FormatNumero(pSesion.TTCAmex, Empresa.MascaraMonetarios, 13)
  End If
  f.Add stFullLength("OTRAS T.C.", 20) & FormatNumero(pMedios.qOtrasTC, "#,##0", 5) & " " & FormatNumero(pSesion.TTCOtras, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("TARJETAS DEBITO ", 20) & FormatNumero(pMedios.qTDebito, "#,##0", 5) & " " & FormatNumero(pSesion.TDebito, Empresa.MascaraMonetarios, 13)
  If pSesion.OtrosMedios > 0 Then
    f.Add stFullLength("OTROS MEDIOS", 20) & FormatNumero(pMedios.qOtrosMedios, "#,##0", 5) & " " & FormatNumero(pSesion.OtrosMedios, Empresa.MascaraMonetarios, 13)
  End If
  f.Add String(AnchoReporte, "=")
  f.Add "FIN DEL RESUMEN", vbCenter

  f.Show vbModal

  Unload f
  Set f = Nothing
  Set pSesion = Nothing
    
End Sub



