VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsResumenSesion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private pSesion As clsSesionPOS
Private bShowSaco As Boolean

Private Const AnchoReporte = 39
' -----------------------
' Resumen de Operaciones
' -----------------------

Private Function MontoGravable() As Currency
Dim p As Double, RetVal As Currency

    p = TiposImpuesto.ValorActualImpuesto(GetSetting("ClearLight", "General", "CodigoImpuesto", "IVA"))
    If p = 0 Then
        MontoGravable = 0
        Exit Function
    End If

    MontoGravable = (pSesion.ImpuestoCobrado - pSesion.ImpuestoAnulado) * 100 / p

End Function

Private Function MontoExento() As Currency
Dim rs As Recordset, RetVal As Currency

    MontoExento = pSesion.MontoFacturado - pSesion.MontoAnulaciones - MontoGravable

End Function

Private Sub PasarResumenLineas(lngNumero As Long, pView As lfQuickView)
Dim rs As Recordset, sQry As String
Dim totUnidades As Double, TotValor As Currency

  pView.Add String(AnchoReporte, "=")
  pView.Add "VENTA POR LINEAS", vbCenter
  
  totUnidades = 0: TotValor = 0

  sQry = "SELECT I.Linea, Sum(R.PrecioUnitario * R.Cantidad) AS Valor, Sum(R.Cantidad) AS Unidades "
  sQry = sQry & "FROM RenglonesFacturaPOS AS R, ItemsVenta AS I, FacturasPOS as F "
  sQry = sQry & "WHERE r.idMaquina = f.idMaquina AND r.numeroTicket = f.NumeroTicket AND f.idSesion = " & lngNumero & " AND r.Producto = i.Codigo "
  sQry = sQry & "GROUP BY I.Linea ORDER BY I.Linea;"

  Set rs = dbHandle.OpenRecordset(sQry, dbOpenForwardOnly)
  Do While Not rs.EOF
    totUnidades = totUnidades + GetNumeroFromVariant(rs.Fields("Unidades"))
    TotValor = TotValor + GetNumeroFromVariant(rs.Fields("Valor"))
    pView.Add _
        stFullLength(stGetStringFromVariant(rs.Fields("Linea")), 14) & _
        FormatNumero(GetNumeroFromVariant(rs.Fields("Unidades")), "###,##0", 7) & _
        FormatNumero(GetNumeroFromVariant(rs.Fields("Valor")), Empresa.MascaraMonetarios, 18)
    
    rs.MoveNext
  Loop
  Set rs = Nothing

'    If bShowSaco Then
'        pView.Add _
'            stFullLength("OTROS", 14) & _
'            stFullLength("1", 7) & _
'            FormatNumero(MontoSaco(lngNumero), Empresa.MascaraMonetarios, 18)
'        TotValor = TotValor + MontoSaco(lngNumero)
'    End If

  pView.Add String(AnchoReporte, "-")
  pView.Add _
      stFullLength("TOTAL", 14) & _
      FormatNumero(totUnidades, "###,##0", 7) & _
      FormatNumero(TotValor, Empresa.MascaraMonetarios, 18)
  pView.Add String(AnchoReporte, "=")
  
' ADICION: Artculos con Precio de Venta = 0
  sQry = "SELECT I.Linea, Sum(R.Cantidad) AS Unidades "
  sQry = sQry & "FROM RenglonesFacturaPOS AS R, ItemsVenta AS I, FacturasPOS as F "
  sQry = sQry & "WHERE r.idMaquina = f.idMaquina AND r.numeroTicket = f.NumeroTicket AND f.idSesion = " & lngNumero & " AND r.Producto = i.Codigo AND R.PrecioUnitario < 0.01 "
  sQry = sQry & "GROUP BY I.Linea ORDER BY I.Linea;"

  Set rs = dbHandle.OpenRecordset(sQry, dbOpenForwardOnly)
  If Not rs.EOF Then
    pView.Add "VENTAS CON PRECIO CERO", vbCenter
    totUnidades = 0
    Do While Not rs.EOF
      totUnidades = totUnidades + GetNumeroFromVariant(rs.Fields("Unidades"))
      pView.Add _
          stFullLength(stGetStringFromVariant(rs.Fields("Linea")), 14) & _
          FormatNumero(GetNumeroFromVariant(rs.Fields("Unidades")), "###,##0", 7)
      rs.MoveNext
    Loop
    pView.Add String(AnchoReporte, "-")
    pView.Add _
      stFullLength("TOTAL", 14) & _
      FormatNumero(totUnidades, "###,##0", 7)
    pView.Add String(AnchoReporte, "=")
  End If
  
  Set rs = Nothing

End Sub

Private Sub PasarResumenTipos(lngNumero As Long, pView As lfQuickView)
Dim rs As Recordset, sQry As String, vmNumero As Currency
Dim totUnidades As Double, TotValor As Currency

  pView.Add String(AnchoReporte, "=")
  pView.Add "VENTA POR TIPO DE DESPACHO", vbCenter
  
  Set rs = dbHandle.OpenRecordset("SELECT Cuenta, COUNT(Cuenta) AS Q, SUM(MontoVenta + Impuesto) AS Total FROM FacturasPOS WHERE idSesion = " & NumeroDB(lngNumero) & " GROUP BY Cuenta ORDER BY Cuenta", dbOpenForwardOnly)
  totUnidades = 0: TotValor = 0
  Do While Not rs.EOF
    vmNumero = GetNumeroFromVariant(rs!Cuenta)
    Select Case vmNumero
    Case 0
      sQry = "EAT-IN"
    Case 1
      sQry = "TAKE-AWAY"
    Case 2
      sQry = "DELIVERY"
    Case Else
      sQry = "OTROS"
    End Select
    sQry = stFullLength(sQry, 14) & FormatNumero(GetNumeroFromVariant(rs!q), "###,##0", 7) & FormatNumero(GetNumeroFromVariant(rs!Total), Empresa.MascaraMonetarios, 18)
    pView.Add sQry
    totUnidades = totUnidades + GetNumeroFromVariant(rs!q)
    TotValor = TotValor + GetNumeroFromVariant(rs!Total)
    rs.MoveNext
  Loop
  sQry = stFullLength("TOTAL", 14) & FormatNumero(totUnidades, "###,##0", 7) & FormatNumero(TotValor, Empresa.MascaraMonetarios, 18)
  pView.Add sQry
  pView.Add String(AnchoReporte, "=")

End Sub

Public Sub ListadoResumen(ilngNumeroSesion As Long, doShowSaco As Boolean)
Dim f As lfQuickView, dblMontoDebidoCaja As Currency
Dim vmTotalVentas As Currency

'    bShowSaco = doShowSaco
'    bShowSaco = False

  Set pSesion = New clsSesionPOS
  If Not pSesion.Load(ilngNumeroSesion) Then
      Set pSesion = Nothing
      Exit Sub
  End If

  Set f = New lfQuickView
  f.SetReportWidth AnchoReporte
  f.Caption = "Sesin de caja N " & ilngNumeroSesion & ". Terminal " & pSesion.MachineID & ". Operador: " & pSesion.usrID
'    If bShowSaco Then
'        f.cbImprimir.Enabled = False
'    End If

' Adaptado...

  f.Add ""
  f.Add Empresa.NombreEmpresa, vbCenter
  f.Add ""
  f.Add "RESUMEN DE TURNO (X)", vbCenter
  f.Add ""
  f.Add "Emisin   : " & Format(Date, "Short Date") & ", " & Format(Now, "Short Time")
  f.Add "Supervisor: " & UsuarioActivo.Codigo
  f.Add ""
  f.Add "Sesion No : " & Format(pSesion.SessionID, "000000")
  f.Add "Apertura  : " & Format(pSesion.Fecha, "Short Date") & "," & Format(pSesion.StartTime, "Short Time")
  f.Add "Operador  : " & pSesion.usrID
  f.Add "Terminal  : " & pSesion.MachineID
  f.Add String(AnchoReporte, "=")
  f.Add "Facturas  : " & pSesion.FacturasRealizadas
  f.Add "Inicial   : " & pSesion.NumeroPrimeraFactura
  f.Add "Final     : " & pSesion.NumeroUltimaFactura
  f.Add String(AnchoReporte, "=")
  vmTotalVentas = (pSesion.MontoFacturado - pSesion.MontoAnulaciones + pSesion.ImpuestoCobrado - pSesion.ImpuestoAnulado)
  
  f.Add stFullLength("Ingreso Total", 26) & FormatNumero(vmTotalVentas, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("Exento", 26) & FormatNumero(MontoExento, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("Gravable", 26) & FormatNumero(MontoGravable, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("Impuesto", 26) & FormatNumero(pSesion.ImpuestoCobrado - pSesion.ImpuestoAnulado, Empresa.MascaraMonetarios, 13)
  f.Add String(AnchoReporte, "=")
  
  PasarResumenLineas pSesion.SessionID, f
  PasarResumenTipos pSesion.SessionID, f

  f.Add stFullLength("TOTAL VENTAS", 26) & FormatNumero(pSesion.MontoFacturado - pSesion.MontoAnulaciones, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("IMPUESTOS", 26) & FormatNumero(pSesion.ImpuestoCobrado - pSesion.ImpuestoAnulado, Empresa.MascaraMonetarios, 13)
  If pSesion.ServicioCobrado - pSesion.ServicioAnulado > 0 Then
    f.Add stFullLength("SERVICIO", 26) & FormatNumero(pSesion.ServicioCobrado - pSesion.ServicioAnulado, Empresa.MascaraMonetarios, 13)
  End If
  If pSesion.MontoCobrado > 0 Then
    f.Add stFullLength("COBROS", 26) & FormatNumero(pSesion.MontoCobrado, Empresa.MascaraMonetarios, 13)
  End If
  f.Add String(AnchoReporte, "-")
  f.Add stFullLength("TOTAL INGRESOS", 26) & FormatNumero((pSesion.MontoCobrado + pSesion.ServicioCobrado - pSesion.ServicioAnulado + pSesion.ImpuestoCobrado - pSesion.ImpuestoAnulado + pSesion.MontoFacturado - pSesion.MontoAnulaciones), Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("EGRESOS", 26) & FormatNumero(pSesion.MontoRetirado, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("VENTAS A CREDITO", 26) & FormatNumero(pSesion.VentasACredito, Empresa.MascaraMonetarios, 13)
  f.Add String(AnchoReporte, "-")

  dblMontoDebidoCaja = pSesion.TotalEntradas - pSesion.TotalSalidas - pSesion.VentasACredito
  f.Add stFullLength("NETO EN CAJA", 26) & FormatNumero(dblMontoDebidoCaja, Empresa.MascaraMonetarios, 13)

  If pSesion.MontoEnCaja <> 0 Then
    f.Add stFullLength("MONTO REPORTADO", 26) & FormatNumero(pSesion.MontoEnCaja, Empresa.MascaraMonetarios, 13)
    f.Add stFullLength("DIFERENCIA", 26) & FormatNumero(pSesion.MontoEnCaja - dblMontoDebidoCaja, Empresa.MascaraMonetarios, 13)
  End If

  f.Add ""
  f.Add stFullLength("EFECTIVO", 26) & FormatNumero(pSesion.EfectivoEnCaja, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("CHEQUES", 26) & FormatNumero(pSesion.ChequesEnCaja, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("TARJETAS", 26) & FormatNumero(pSesion.TTCVisa, Empresa.MascaraMonetarios, 13)
  f.Add stFullLength("TARJETAS DEBITO", 26) & FormatNumero(pSesion.TDebito, Empresa.MascaraMonetarios, 13)
  f.Add String(AnchoReporte, "=")
  f.Add "FIN DEL RESUMEN", vbCenter

  ShowNonModal f

  Unload f
  Set f = Nothing
  Set pSesion = Nothing
    
End Sub

