VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsResumenMovsCta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Genera el reporte resumido de movimientos por cuenta"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Const AnchoReporte = 146
Const Formato = "#,###,###,###,##0.00"

Private mstCuentaInicio As String, _
        mstCuentaFinal As String, _
        mlPeriodoInicio As Long, _
        mlPeriodoFinal As Long
Private totDebC As Double, _
        totCredC As Double
Private f As lfQuickView

Private Function DefinirParametros() As Boolean
Dim f As fselParmsListaMovsCta
    Set f = New fselParmsListaMovsCta
    f.Show 0
    While f.Visible: DoEvents: Wend
    If f.txAnhoFinal.Text = "" Then
        DefinirParametros = False
    Else
        DefinirParametros = True
        mstCuentaInicio = f.acCodeBoxCuentaInicio.Text
        mstCuentaFinal = f.acCodeBoxCuentaFin.Text
        mlPeriodoInicio = f.RefInicio
        mlPeriodoFinal = f.RefFinal
    End If
    Unload f
    Set f = Nothing
End Function
' Dos lneas por detalle...
'--------------------------------------------------------------------------------------------------------------------------------------------------
'Cuenta               Titulo                                           Saldo Inicial              Debitos             Creditos          Saldo Final
'--------------------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  9,999,999,999,999.99 9,999,999,999,999.99 9,999,999,999,999.99 9,999,999,999,999.99
'VAN                                                                                 9,999,999,999,999.99 9,999,999,999,999.99

Private Sub AddLineaTotal(stTitulo As String, Debitos As Double, Creditos As Double)
    If stTitulo <> "VIENEN" Then f.Add String(84, " ") & String(41, "-")
    f.Add stFullLength(stTitulo, 84) & FormatNumero(Debitos, Formato, 20) & " " & FormatNumero(Creditos, Formato, 20)
End Sub

Private Sub Encabezado()
Dim sOut As String
    If totDebC > 0 Or totDebC > 0 Then
        AddLineaTotal "VAN", totDebC, totCredC
        f.PageBreak
    End If
    f.Add "": f.Add ""
    f.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    f.Add ""
    f.Add stMidAlign("Resumenes de movimientos por Cuenta", AnchoReporte)
    sOut = "Seleccin: "
    If mstCuentaInicio = "" And mstCuentaFinal <> "" Then
        sOut = sOut & "Hasta la cuenta " & mstCuentaFinal
    ElseIf mstCuentaInicio <> "" And mstCuentaFinal = "" Then
        sOut = sOut & "Desde la cuenta " & mstCuentaInicio
    ElseIf mstCuentaInicio = "" And mstCuentaFinal = "" Then
        sOut = "Todas las cuentas"
    Else
        sOut = "De la cuenta " & mstCuentaInicio & " a la cuenta " & mstCuentaFinal
    End If
    sOut = sOut & ". "
    sOut = stMidAlign(sOut & "Periodo: " & Str(mlPeriodoInicio) & " -" & Str(mlPeriodoFinal), AnchoReporte)
    f.Add sOut
    f.Add stRightAlign("Pagina" & Str(f.Pagina), AnchoReporte)
    f.Add String(AnchoReporte, "-")
    f.Add "Cuenta               Titulo                                           Saldo Inicial              Debitos             Creditos          Saldo Final"
    f.Add String(AnchoReporte, "-")
    If totDebC <> 0 Or totDebC <> 0 Then AddLineaTotal "VIENEN", totDebC, totCredC
End Sub

Private Sub PasarCuenta(inst As clsCuenta)
Dim col As New Collection, instSaldo As clsSaldoCuentaPeriodo, RetVal As Double
Dim first As Boolean, Debitos As Double, Creditos As Double, Inicial As Double, Final As Double
    
    AlmacenSaldos.LlenarSaldosCuenta inst.Codigo, mlPeriodoInicio, mlPeriodoFinal, col
    first = True
    For Each instSaldo In col
        If first Then Inicial = instSaldo.SaldoInicial
        first = False
        Debitos = Debitos + instSaldo.Debitos
        Creditos = Creditos + instSaldo.Creditos
    Next
    Set col = Nothing
    If Debitos = 0 And Creditos = 0 Then
        Exit Sub
    End If
    Final = Inicial + Debitos - Creditos
    If (f.Linea > f.LineasPagina - 2) Then Encabezado
    f.Add stFullLength(inst.Codigo, 20) & " " & stFullLength(inst.Titulo, 40) & " " & _
            FormatNumero(Inicial, Formato, 20) & " " & _
            FormatNumero(Debitos, Formato, 20) & " " & _
            FormatNumero(Creditos, Formato, 20) & " " & _
            FormatNumero(Final, Formato, 20)
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  9,999,999,999,999.99 9,999,999,999,999.99 9,999,999,999,999.99 9,999,999,999,999.99
    totDebC = totDebC + Debitos
    totCredC = totCredC + Creditos
End Sub

Public Sub Generar()
Dim colCtas As Collection, instCuenta As clsCuenta

    If Not DefinirParametros Then Exit Sub
    Screen.MousePointer = vbHourglass
    Set f = New lfQuickView
    f.SetReportWidth AnchoReporte + 1
    Set colCtas = New Collection
    AlmacenCuentas.LlenarColeccionCuentas colCtas
    Encabezado
    For Each instCuenta In colCtas
        If instCuenta.Status = 2 Then
            PasarCuenta instCuenta
        End If
    Next
    Set instCuenta = Nothing
    Set colCtas = Nothing
    AddLineaTotal "TOTAL", totDebC, totCredC
    Screen.MousePointer = vbDefault
    
    f.Show
    While f.Visible: DoEvents: Wend
    Unload f
    Set f = Nothing
End Sub

