VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsResUtilProd"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Const ReportWidth = 155
Private finic As Date, ffinal As Date, TotalVenta As Currency, TotalCosto As Currency, WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim pItem As clsItemVenta, sExtract As String
Dim f2 As lfSelectRangoFechas, fView As lfQuickView
  
  bProcessed = True
  sExtract = Trim(left(Trim(strReportLine), 20))
  Set pItem = AlmacenItemsVenta.ItemVenta(sExtract)
  If Not pItem Is Nothing Then
    If nLinePos < 63 Then
      pItem.Show
    Else
      Dim r2 As clsListaVntProdDet
      Set r2 = New clsListaVntProdDet
      r2.SetItem pItem.Codigo, pItem.Descripcion
      r2.Generar
      Set r2 = Nothing
    End If
    Set pItem = Nothing
  End If
End Sub


'Inversiones La Rumba, C.A.
'Ventas y Utilidad por Producto
'Entre el 00-00-0000 y el 00-00-0000
'Pgina: 999     OPERADOR: XXXXXXXX    Emisin: 99-99-9999 99:99:99
'-----------------------------------------------------------------------------------------------------------------------------------------------------------
'Codigo del Producto  Descripcion                                 Cantidad   Precio Unit.    Total Venta Costo Promedio    Costo Total        Utilidad %Util
'-----------------------------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999,999 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99  999.999.999,99 99,99
'VAN/VIENEN/TOTAL                                                                         999.999.999,99                999.999.999,99  999.999.999,99 99,99

Private Sub PrintLinea(Codigo As String, _
                    Descripcion As String, _
                    Cantidad As Double, _
                    Precio As Currency, _
                    TotalVenta As Currency, _
                    CostoPromedio As Currency, _
                    CostoTotal As Currency)
Dim stOut As String, Utilidad As Currency
    
    Utilidad = TotalVenta - CostoTotal
    stOut = stFullLength(Codigo, 20) & " "
    stOut = stOut & stFullLength(Descripcion, 40) & " "
    stOut = stOut & FormatNumero(Cantidad, Empresa.MascaraCantidades, 11) & " "
    stOut = stOut & FormatNumero(Precio, Empresa.MascaraPrecios, 14) & " "
    stOut = stOut & FormatNumero(TotalVenta, Empresa.MascaraMonetarios, 14) & " "
    stOut = stOut & FormatNumero(CostoPromedio, Empresa.MascaraPrecios, 14) & " "
    stOut = stOut & FormatNumero(CostoTotal, Empresa.MascaraMonetarios, 14) & " "
    stOut = stOut & FormatNumero(Utilidad, Empresa.MascaraMonetarios, 14) & " "
    stOut = stOut & FormatNumero(CalcularUtilidad(TotalVenta, CostoTotal), "##0.00", 6)
    fView.Add stOut

End Sub

Private Sub Encabezado()
Dim isFirst As Boolean

    isFirst = fView.Pagina = 1 And fView.Linea = 1
    If Not isFirst Then
        PrintLinea "VAN", "", 0, 0, TotalVenta, 0, TotalCosto
        fView.PageBreak
    End If

    fView.Add stMidAlign(Empresa.NombreEmpresa, ReportWidth)
    fView.Add stMidAlign("Resumen General de Ventas por Producto", ReportWidth)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), ReportWidth)
    fView.Add "Pagina: " & FormatNumero(fView.Pagina, "##0", 3) & "        OPERADOR: " & stFullLength(UsuarioActivo.Codigo, 8) & "        Emisin: " & Format(Date, "Short Date") & " " & Format(Now, "Short Time")
    fView.Add "-----------------------------------------------------------------------------------------------------------------------------------------------------------"
    fView.Add "Codigo del Producto  Descripcion                                 Cantidad   Precio Unit.    Total Venta Costo Promedio    Costo Total        Utilidad %Util"
    fView.Add "-----------------------------------------------------------------------------------------------------------------------------------------------------------"
    
    If Not isFirst Then PrintLinea "VIENEN", "", 0, 0, TotalVenta, 0, TotalCosto

End Sub

Private Sub PasarLinea(Codigo As String, _
                    Descripcion As String, _
                    Cantidad As Double, _
                    Precio As Currency, _
                    vTotalVenta As Currency, _
                    CostoPromedio As Currency, _
                    vCostoTotal As Currency)

  On Error GoTo ErrHandler
  If fView.Linea > fView.LineasPagina - 2 Then
    Encabezado
  End If
  
  PrintLinea Codigo, Descripcion, Cantidad, Precio, vTotalVenta, CostoPromedio, vCostoTotal
  
  TotalVenta = TotalVenta + vTotalVenta
  TotalCosto = TotalCosto + vCostoTotal
  Exit Sub

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "clsResUtilProd::PasarLinea"
  Err.Clear
End Sub
'SELECT detallesItemVenta.CodigoItem, itemsVenta.Descripcion, detallesITemVenta.PrecioVenta, SUM(detallesItemVenta.Cantidad) AS Cantidad, SUM(detallesItemVenta.Cantidad * detallesItemVenta.PrecioVenta) AS Total
'From detallesItemVenta, itemsVenta
'WHERE itemsVenta.Codigo = detallesItemVenta.CodigoItem AND
'              detallesItemVenta.FechaOperacion >= paramFechaInicial AND
'              detallesItemVenta.FechaOperacion <= paramFechaFinal
'GROUP BY detallesItemVenta.CodigoItem, detallesItemVenta.PrecioVenta, itemsVenta.Descripcion
'ORDER BY detallesItemVenta.CodigoItem, detallesItemVenta.PrecioVenta;

Public Sub Generar()
Dim isOk As Boolean
Dim f As fPrmsListaMovProd
Dim qry As String, rs As Recordset
Dim Filtro As String

  On Error GoTo ErrHandler

  Set f = New fPrmsListaMovProd
  f.Show
  While f.Visible: DoEvents: Wend
  
  If f.Result Then
    finic = f.ucSelectRango1.FechaInicial
    ffinal = f.ucSelectRango1.FechaFinal
    Filtro = f.FiltroSQL("I", "D")
    isOk = True
  Else
    isOk = False
  End If
  
  Unload f
  Set f = Nothing
  
  If Not isOk Then Exit Sub
  
  qry = "SELECT D.CodigoItem, I.Descripcion, SUM(D.Cantidad) AS Cantidad, SUM(D.Cantidad * D.PrecioVenta) AS TotalVenta, Sum(D.CostoStandard * D.Cantidad) AS TotalCosto "
  qry = qry & "From detallesItemVenta D, itemsVenta I"
  qry = qry & " WHERE " & Filtro & " "
  qry = qry & "GROUP BY D.CodigoItem, I.Descripcion "
  qry = qry & "ORDER BY D.CodigoItem;"
  
  Screen.MousePointer = vbHourglass
  Set rs = dbHandle.Execute(qry)
  Screen.MousePointer = vbDefault
  
  If Not rs.EOF Then
  
    Screen.MousePointer = vbHourglass
    Set fView = New lfQuickView
    fView.Caption = "Resumen de Ventas por Producto: Utilidad"
    
    TotalVenta = 0: TotalCosto = 0
    Encabezado
    
    Do While Not rs.EOF
      If rs!Cantidad <> 0 Then
        PasarLinea rs!CodigoItem, rs!Descripcion, rs!Cantidad, rs!TotalVenta / rs!Cantidad, rs!TotalVenta, GetNumeroFromVariant(rs!TotalCosto) / rs!Cantidad, GetNumeroFromVariant(rs!TotalCosto)
      End If
      rs.MoveNext
    Loop
    
    PrintLinea "TOTAL", "", 0, 0, TotalVenta, 0, TotalCosto

    Screen.MousePointer = vbDefault
    fView.Show
    
    While fView.Visible: DoEvents: Wend
    Unload fView
    Set fView = Nothing

  End If
  
  rs.Close
  Set rs = Nothing
  
ResumePoint:
  
  Screen.MousePointer = vbDefault
  On Error GoTo 0
  Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long

  sErrD = Err.Description: nErrN = Err.Number
  ReportarError False, nErrN, sErrD, "clsResUtilProd::Generar"
  Resume ResumePoint


End Sub

