VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsResCompArticulo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 134
Private WithEvents fView As lfQuickView, finic As Date, ffinal As Date
Attribute fView.VB_VarHelpID = -1
Private totCompra As Currency, totImpuesto As Currency

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim sExtract As String, pItemInv As clsItemInventario

  sExtract = Trim(left(Trim(strReportLine), 20))
  Set pItemInv = AlmacenItemsInventario.itemInventario(sExtract)
  If Not pItemInv Is Nothing Then
    pItemInv.Show
    Set pItemInv = Nothing
  End If

End Sub

'--------------------------------------------------------------------------------------------------------------------------------------
'Codigo del Articulo  Descripcion                                Precio Medio      Cantidad   Valor Compra      Impuesto          Total
'--------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 9.999.999,999 999.999.999,99 99.999.999,99 999.999.999,99

Private Sub PasarLinea(sCodigo As String, _
                    sDescripcion As String, _
                    vmPrecio As Currency, _
                    dCantidad As Double, _
                    vmValor As Currency, _
                    vmImpuesto As Currency)
Dim stOut As String
    
    stOut = stFullLength(sCodigo, 20) & " "
    stOut = stOut & stFullLength(sDescripcion, 40) & " "
    stOut = stOut & FormatNumero(vmPrecio, Empresa.MascaraPrecios, 14) & " "
    stOut = stOut & FormatNumero(dCantidad, Empresa.MascaraCantidades, 13) & " "
    stOut = stOut & FormatNumero(vmValor, Empresa.MascaraMonetarios, 14) & " "
    stOut = stOut & FormatNumero(vmImpuesto, Empresa.MascaraMonetarios, 13) & " "
    stOut = stOut & FormatNumero(vmValor + vmImpuesto, Empresa.MascaraMonetarios, 14)
    
    fView.Add stOut
    
End Sub

Private Sub Encabezado()

    With fView
    If .Pagina > 1 Or .Linea > 1 Then
        PasarLinea "VAN", "", 0, 0, totCompra, totImpuesto
        .PageBreak
    End If
    
    .Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    .Add stMidAlign("Resumen de Productos Comprados", AnchoReporte)
    .Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    .Add ""
    .Add "Emision: " & Format(Now, "General Date") & "      OPERADOR: " & UsuarioActivo.Codigo & ".       Pgina:" & Str(fView.Pagina)
    .Add String(AnchoReporte, "-")
    .Add "Codigo del Articulo  Descripcion                                Precio Medio      Cantidad   Valor Compra      Impuesto          Total"
    .Add String(AnchoReporte, "-")
    
    If .Pagina > 1 Then
        PasarLinea "VAN", "", 0, 0, totCompra, totImpuesto
    End If
    
    End With

End Sub


Private Sub AddLinea(sCodigo As String, _
                    sDescripcion As String, _
                    vmPrecio As Currency, _
                    dCantidad As Double, _
                    vmValor As Currency, _
                    vmImpuesto As Currency)

    If fView.Linea > fView.LineasPagina - 2 Then
        Encabezado
    End If
    
    PasarLinea sCodigo, sDescripcion, vmPrecio, dCantidad, vmValor, vmImpuesto
    
    totCompra = totCompra + vmValor: totImpuesto = totImpuesto + vmImpuesto
    
End Sub

Public Sub Generar()
Dim f As frmFiltroArtProv
Dim sQuery As String, sNext As String
Dim rs As Recordset

    Set f = New frmFiltroArtProv
    f.Frame2.Enabled = False
    
    ShowNonModal f

    If Not f.Result Then
        Unload f
        Set f = Nothing
        Exit Sub
    End If

    sQuery = "SELECT D.CodigoItem, D.Descripcion, Sum((D.CantidadFacturada + D.CantidadPromocion) * D.FactorEmpaque) AS Cantidad, Sum(D.PrecioEfectivo * (D.CantidadFacturada + D.CantidadPromocion)) AS TotalPrecio, Sum(D.Impuesto1 + D.Impuesto2) AS TotalImpuesto "
    sQuery = sQuery & "FROM DetallesCompra AS D, itemsInventario AS I, Compras AS R, Proveedores AS P "
    sQuery = sQuery & "WHERE D.CodigoItem = i.Codigo "
    sQuery = sQuery & "AND D.NumeroDocumento = R.Numero "
    sQuery = sQuery & "AND P.Codigo = R.CodigoProveedor "
    sQuery = sQuery & "AND R.FechaTransaccion BETWEEN " & FechaDB(f.FechaInicial) & " AND " & FechaDB(f.FechaFinal) & " "
    
    sNext = f.ucCriteriosArticulo1.FiltroSQL("I")
    If sNext <> "" Then sQuery = sQuery & "AND " & Trim(sNext) & " "
    
    sNext = f.ucFiltroProveedores1.FiltroSQL("P")
    If sNext <> "" Then sQuery = sQuery & "AND " & Trim(sNext) & " "
    
    sQuery = sQuery & "GROUP BY D.CodigoItem, D.Descripcion "
    sQuery = sQuery & "ORDER BY D.CodigoItem"

    Unload f
    Set f = Nothing

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault
    
    If Not rs.EOF Then
    
        Screen.MousePointer = vbHourglass
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.Caption = "Resumen de compras por producto"
        
        Encabezado

        Do
            AddLinea rs!CodigoItem, rs!Descripcion, rs!TotalPrecio / rs!Cantidad, rs!Cantidad, rs!TotalPrecio, rs!TotalImpuesto
            rs.MoveNext
        Loop While Not rs.EOF
        
        PasarLinea "TOTAL", "", 0, 0, totCompra, totImpuesto
        
        Screen.MousePointer = vbDefault
        ShowNonModal fView

        Unload fView
        Set fView = Nothing
    
    End If
    
    rs.Close
    Set rs = Nothing

End Sub

'Ejemplo del Query:
'==================
'SELECT D.CodigoItem, D.Descripcion, Sum((D.CantidadFacturada + D.CantidadPromocion) * D.FactorEmpaque) AS Cantidad, Sum(D.PrecioEfectivo * (D.CantidadFacturada + D.CantidadPromocion)) AS TotalPrecio, Sum(D.Impuesto1 + D.Impuesto2) AS TotalImpuesto
'FROM DetallesCompra AS D, itemsInventario AS I, Compras AS R, Proveedores AS P
'WHERE D.CodigoItem = i.Codigo
'AND D.NumeroDocumento = R.Numero
'AND P.Codigo = R.CodigoProveedor
'AND R.FechaTransaccion BETWEEN #2000/08/01# AND #2000/08/09#
'AND I.Linea in ("PANAD", "PASTEL")
'AND P.Codigo >= "1"
'GROUP BY D.CodigoItem, D.Descripcion;

