VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsReporteExistenciasAlmacen"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public AlmacenDesde As String, AlmacenHasta As String, TipoAlmacen As Integer
Private TipoCosto As Boolean, TipoCuenta As Boolean

Private WithEvents f As lfQuickView
Attribute f.VB_VarHelpID = -1

Private tagAlmacen As String, _
        ValorAlmacen As Currency, _
        ValorTotal As Currency

Private Const ReportWidth = 120

'Nombre de la Empresa (centrado)
'Existencia de Inventario por Almacenes
'Costo: PROMEDIO/ULTIMO
'Unidad: EMPAQUE/UNIDAD
'Del Almacen XXXX al almacen ZZZZ | Almacen: AAAA
'Emisin: 99-99-9999  hh:mm
'Operador: XXXXXXXX                                                                                           Pgina: 999
'------------------------------------------------------------------------------------------------------------------------
'Codigo               Descripcion                                            Existencia          Costo              Valor
'------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx ###,###,##0.00 ###,###,##0.00 ###,###,###,##0.00
'7592530000108   agua  5 Lts. Lara                                           34,00       1.679,80          57.113,29
 
#If IsNotMain = 0 Then
Private Sub f_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim pItemInv As clsItemInventario, sExtract As String
Dim f2 As lfSelectRangoFechas
  bProcessed = True
  sExtract = Trim(left(Trim(strReportLine), 20))
  Set pItemInv = AlmacenItemsInventario.itemInventario(sExtract)
  If Not pItemInv Is Nothing Then
    If nLinePos < 73 Then
      pItemInv.Show
    Else
      Dim lMinvs As clsListaMovItemInv
      Set f2 = New lfSelectRangoFechas
      f2.Show 1
      If f2.Result Then
          Set lMinvs = New clsListaMovItemInv
          lMinvs.ListarMinvs pItemInv, f2.dtFechaInicial.Fecha, f2.dtFechaFinal.Fecha
          Set lMinvs = Nothing
      End If
      Unload f2
      Set f2 = Nothing
    End If
    Set pItemInv = Nothing
  End If
End Sub
#End If

Private Sub Encabezado(Ruptura As Boolean)
Dim stLeft As String, stRight As String

    If f.Pagina > 1 Or f.Linea > 1 Then ' No es la primera Pagina
        If Not Ruptura Then         ' No se botaron los totale
            PrintLine "VAN", "", 0, 0, ValorAlmacen
            f.PageBreak
        End If
    End If

    f.Add ""
    f.Add stMidAlign(Empresa.NombreEmpresa, ReportWidth)
    f.Add stMidAlign("Existencia de Inventario por Almacenes", ReportWidth)
    If AlmacenDesde = AlmacenHasta Then
        f.Add stMidAlign("Almacen: " & AlmacenDesde, ReportWidth)
    Else
        f.Add stMidAlign("Del almacen " & AlmacenDesde & " al almacen " & AlmacenHasta, ReportWidth)
    End If
    f.Add stMidAlign("Costo: " & IIf(TipoCosto, "PROMEDIO", "ULTIMO COSTO"), ReportWidth)
    f.Add stMidAlign("Unidad de Cuenta: " & IIf(TipoCuenta, "UNIDAD", "EMPAQUE"), ReportWidth)
    f.Add ""

    stLeft = "Emisin: " & Format(Now, "General Date") & "   Operador: " & UsuarioActivo.Codigo
    stRight = "Pagina:" & Str(f.Pagina)
    f.Add stLeft & Space(ReportWidth - (Len(stLeft) + Len(stRight))) & stRight
    
    f.Add String(ReportWidth, "-")
    f.Add "Codigo               Descripcion                                            Existencia          Costo              Valor"
    f.Add String(ReportWidth, "-")
    
    If f.Pagina > 1 And Not Ruptura Then
        PrintLine "VIENEN", "", 0, 0, ValorAlmacen
    End If

End Sub

Private Sub PrintLine(Codigo As String, Descripcion As String, ByVal Existencia As Double, ByVal CostoU As Double, ByVal Valor As Double)
Dim stOut As String
    
    stOut = stFullLength(Codigo, 21) & stFullLength(Descripcion, 51) & FormatNumero(Existencia, "###,###,##0.00", 14) & FormatNumero(CostoU, "###,###,##0.00", 15) & FormatNumero(Valor, "###,###,###,##0.00", 19)
    f.Add stOut

End Sub

Private Sub Ruptura(sNewAlmacen As String)
    
    If AlmacenDesde = AlmacenHasta Then Exit Sub

    If tagAlmacen <> "" Then
        PrintLine "Sub Total", "Total almacen " & tagAlmacen, 0, 0, ValorAlmacen
    End If
    
    ValorAlmacen = 0
    tagAlmacen = sNewAlmacen
            
    If sNewAlmacen <> "" Then
        If (f.Linea > f.LineasPagina - 5) Then
            Encabezado True
        Else
            f.Add ""
        End If
        f.Add "Almacen: " & Almacenes.NombreAlmacen(tagAlmacen) & " (" & tagAlmacen & ")"
    End If

End Sub

Private Sub PasarLinea(sAlmacen As String, Codigo As String, Descripcion As String, ByVal Existencia As Double, ByVal CostoU As Double, ByVal Valor As Double)
    
    If sAlmacen <> tagAlmacen Then
        Ruptura sAlmacen
    End If
    
    If f.Linea > f.LineasPagina - 3 Then Encabezado False

    PrintLine Codigo, Descripcion, Existencia, CostoU, Valor
    ValorAlmacen = ValorAlmacen + Valor
    ValorTotal = ValorTotal + Valor

End Sub

'SELECT ExistenciaUbicacion.*, itemsInventario.Descripcion, itemsInventario.CostoPromedio, itemsInventario.UltimoCosto, itemsInventario.CantidadEmpaque
'From ExistenciaUbicacion, itemsInventario
'WHERE ExistenciaUbicacion.Almacen >= PARAMAlmacenDesde AND
'ExistenciaUbicacion.Almacen <= PARAMAlmacenHasta AND
'ExistenciaUbicacion.TipoUbicacion = PARAMTipoUbicacion And itemsInventario.Codigo = ExistenciaUbicacion.CodigoItem
'ORDER BY Almacen, Descripcion;

Public Sub Go()
Dim sQuery As String, rsHandle As Recordset
Dim fSelect As fGetParmRepExAlm, isOk As Boolean, Existencia As Double, Valor As Currency, CostoU As Currency

    Set fSelect = New fGetParmRepExAlm
    If AlmacenDesde = "" Then
        fSelect.cbxFinal.Enabled = True
        fSelect.cbxInicial.Enabled = True
    Else
        fSelect.cbxFinal.Text = AlmacenHasta
        fSelect.cbxInicial.Text = AlmacenDesde
        fSelect.cbxFinal.Enabled = False
        fSelect.cbxInicial.Enabled = False
    End If
    fSelect.Show 1
    
    isOk = fSelect.Result
    
    If isOk Then
        If AlmacenHasta = "" Then
            AlmacenHasta = fSelect.cbxFinal.Text
            AlmacenDesde = fSelect.cbxInicial.Text
        End If
        TipoCuenta = fSelect.TipoCuenta
        TipoCosto = fSelect.TipoCosto
    End If
    
    Unload fSelect
    Set fSelect = Nothing
    
    If Not isOk Then Exit Sub

    sQuery = "SELECT ExistenciaUbicacion.*, itemsInventario.Descripcion, itemsInventario.CostoPromedio, itemsInventario.UltimoCosto, itemsInventario.CantidadEmpaque "
    sQuery = sQuery & "From ExistenciaUbicacion, itemsInventario "
    sQuery = sQuery & "WHERE ExistenciaUbicacion.Almacen BETWEEN " & StringDB(AlmacenDesde) & " AND " & StringDB(AlmacenHasta)
    sQuery = sQuery & " AND ExistenciaUbicacion.TipoUbicacion =" & NumeroDB(TipoAlmacen) & " AND itemsInventario.Codigo = ExistenciaUbicacion.CodigoItem"
    sQuery = sQuery & " ORDER BY Almacen, Descripcion;"
    
    Screen.MousePointer = vbHourglass
    Set rsHandle = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault

    With rsHandle
    
    If Not .EOF Then
        
        Screen.MousePointer = vbHourglass
        Set f = New lfQuickView
        f.Caption = "Reporte de Existencias por Almacen"
        f.SetReportWidth ReportWidth
    
        tagAlmacen = "": ValorAlmacen = 0: ValorTotal = 0
        Screen.MousePointer = vbHourglass
        
        Encabezado False
        Do While Not .EOF
            
            Existencia = .Fields("Existencia")
            CostoU = .Fields(IIf(TipoCosto, "CostoPromedio", "UltimoCosto")).Value
            Valor = CostoU * Existencia
            If Not TipoCuenta Then
                Existencia = Existencia / .Fields("CantidadEmpaque").Value
                CostoU = CostoU * .Fields("CantidadEmpaque")
            End If
            If f.Linea > f.LineasPagina - 2 Then Encabezado False
            PasarLinea .Fields("Almacen"), .Fields("CodigoItem"), .Fields("Descripcion"), Existencia, CostoU, Valor
            .MoveNext
        Loop
        
        Ruptura ""
        
        PrintLine "TOTAL GENERAL", "", 0, 0, ValorTotal
    
        Screen.MousePointer = vbDefault
        f.Show
        While f.Visible: DoEvents: Wend
        Unload f
        Set f = Nothing
    End If
    
    .Close
    End With
    
    Set rsHandle = Nothing
    
    Screen.MousePointer = vbDefault

End Sub

Private Sub Class_Initialize()
    AlmacenDesde = ""
    AlmacenHasta = ""
    TipoAlmacen = 0
End Sub
