VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRepVentTotClteProd"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 120

Private finic As Date, fFinal As Date
Private sCodCli As String, sNombreCli As String
Private fView As lfQuickView

'Inversiones La Puyita, s.r.l.

'Ventas resumidas por producto
'Cliente: XXXXXXXXXXXXXXXXXXXxXXX (XXXXXXXX)
'Intervalo de consulta: 99-99-9999 al 99-99-9999

'------------------------------------------------------------------------------------------------------------------------
'Codigo del Producto  Descripcion                                                Cantidad   Precio Medio      Valor Total
'------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX #,###,###,##0.00 ###,###,##0.00 #,###,###,##0.00

Private Sub AddLinea( _
                sCodigo As String, _
                sDescripcion As String, _
                dCantidad As Double, _
                vmTotal As Currency)
Dim sOut As String, vmUnit As Currency

    If dCantidad = 0 Then Exit Sub
    vmUnit = vmTotal / dCantidad
    sOut = stFullLength(sCodigo, 20) & " "
    sOut = sOut & stFullLength(sDescripcion, 50) & " "
    sOut = sOut & FormatNumero(dCantidad, "#,###,###,##0.00", 16) & " "
    sOut = sOut & FormatNumero(vmUnit, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmTotal, "#,###,###,##0.00", 16)
    
    If fView.Linea > fView.LineasPagina - 1 Then Encabezado
    
    fView.Add sOut

End Sub

Private Sub Encabezado()

    If fView.Pagina <> 1 Then
        fView.PageBreak
    End If
    
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Ventas Resumidas por Producto", AnchoReporte)
    fView.Add stMidAlign("Cliente: " & sNombreCli & " (" & sCodCli & ")", AnchoReporte)
    fView.Add stMidAlign("Intervalo de consulta: " & Format(finic, "Short Date") & " al " & Format(fFinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Operador: " & UsuarioActivo.Codigo & "       Emision:" & Format(Now, "General Date") & "    Pagina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add "Codigo del Producto  Descripcion                                                Cantidad   Precio Medio      Valor Total"
    fView.Add String(AnchoReporte, "-")

End Sub

Public Sub Go(sCodigo As String)
Dim f As lfSelectRangoFechas, isOK As Boolean
Dim pCli As clsClientes
Dim rs As Recordset, sQuery As String

    Set f = New lfSelectRangoFechas
    Centrar f
    f.Show 1
    If f.Result Then
        finic = f.dtFechaInicial.Fecha
        fFinal = f.dtFechaFinal.Fecha
        isOK = True
    Else
        isOK = False
    End If
    Unload f
    Set f = Nothing

    If Not isOK Then Exit Sub

    sCodCli = sCodigo
    Set pCli = New clsClientes
    If pCli.Load(sCodigo) Then
        sNombreCli = pCli.Nombre
    Else
        mAdvertencia "No localic el registro del cliente"
        isOK = False
    End If
    Set pCli = Nothing

    If Not isOK Then Exit Sub

    sQuery = "SELECT DetallesItemVenta.CodigoItem, ItemsVenta.Descripcion, Sum(DetallesItemVenta.Cantidad) AS CantidadTotal, Sum(DetallesItemVenta.Cantidad * DetallesItemVenta.PrecioVenta) AS ValorVenta "
    sQuery = sQuery & "From DetallesItemVenta, ItemsVenta "
    sQuery = sQuery & "Where FechaOperacion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(fFinal) & " "
    sQuery = sQuery & "AND CodigoCliente = " & StringDB(sCodCli) & " "
    sQuery = sQuery & "AND CodigoItem <> '' "
    sQuery = sQuery & "AND itemsVenta.Codigo = detallesItemVenta.CodigoItem "
    sQuery = sQuery & "GROUP BY CodigoItem, ItemsVenta.Descripcion "
    sQuery = sQuery & "ORDER BY ItemsVenta.Descripcion;"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then

      Screen.MousePointer = vbHourglass
      Set fView = New lfQuickView
      fView.Caption = "Resumen de ventas por Cliente/Producto"
      fView.SetReportWidth AnchoReporte
      
      Encabezado
      
      With rs
      Do While Not .EOF
        AddLinea rs!CodigoItem, rs!Descripcion, rs!CantidadTotal, rs!ValorVenta
        .MoveNext
      Loop
      End With

      Screen.MousePointer = vbDefault
      fView.Show
      
      While fView.Visible: DoEvents: Wend
      
      Unload fView
      Set fView = Nothing
    
    Else
        
      mAdvertencia "No hay datos para el reporte"
    
    End If
    
    rs.Close
    Set rs = Nothing
    Set fView = Nothing

End Sub

