Attribute VB_Name = "clsRepVentTotClteProd"
Option Explicit

Private Const AnchoReporte = 113

Private fInic As Date, fFinal As Date
Private sCurrentItem As String
Private sCodCli As String, sNombreCli As String
Private fView As lfQuickView

'Inversiones La Puyita, s.r.l.

'Ultimas ventas por producto
'Cliente: XXXXXXXXXXXXXXXXXXXxXXX (XXXXXXXX)
'Intervalo de consulta: 99-99-9999 al 99-99-9999

'-----------------------------------------------------------------------------------------------------------------
'Codigo del Producto  Descripcion                               Fecha    Factura         Cantidad     Precio Unit.
'-----------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99-99-9999 XXX-0000000 9.999.999,99 9.999.999.999,99

Private Sub AddLine(sCodigo As String, sDescripcion As String, dtFecha As Date, stSerie As String, lCorrelativo As Long, dblCantidad As Double, vmPrecioUnit As Currency)
Dim sOut As String

    sOut = stFullLength(sCodigo, 20) & " "
    sOut = sOut & stFullLength(sDescripcion, 39) & " "
    sOut = sOut & stRightAlign(Format(dtFecha, "ShortDate"), 10) & " "
    sOut = sOut & stFullLength(stSerie & "-" & Format(lCorrelativo, "0000000"), 11) & " "
    sOut = sOut & FormatNumero(dblCantidad, "#,###,##0.00", 12) & " "
    sOut = sOut & FormatNumero(vmPrecioUnit, "#,###,###,##0.00", 16)
    
    If fView.Linea > fView.LineasPagina - 1 Then Encabezado
    
    fView.Add sOut

End Sub

Private Sub Encabezado()
    
    If sCurrentItem <> "" Then
        fView.PageBreak
    End If
    
    fView.Add Empresa.NombreEmpresa
    fView.Add ""
    fView.Add "Ultimas ventas por producto"
    fView.Add "Cliente: " & sNombreCli & " (" & sCodCli
    fView.Add "Intervalo de consulta: " & Format(fInic, "Short Date") & " al " & Format(fFinal, "Short Date")
    fView.Add "Operador: " & UsuarioActivo.Codigo & "       Emision:" & Format(Now, "General Date") & "    Pagina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add "Codigo del Producto Descripcion                                Fecha    Factura         Cantidad     Precio Unit."
    fView.Add String(AnchoReporte, "-")

End Sub

Public Sub Go(sCodigo As String)
Dim f As lfSelectRangoFechas, isOk As Boolean
Dim pCli As clsClientes
Dim rs As Recordset, qry As QueryDef

    Set f = New lfSelectRangoFechas
    Centrar f
    f.Show 1
    If f.result Then
        fInic = f.dtFechaInicial.Fecha
        fFinal = f.dtFechaFinal.Fecha
        isOk = True
    Else
        isOk = False
    End If
    Unload f
    Set f = Nothing

    If Not isOk Then Exit Sub

    sCodCli = sCodigo
    Set pCli = New clsClientes
    If pCli.Load(sCodigo) Then
        sNombreCli = pCli.Nombre
    Else
        mAdvertencia "No localic el registro del cliente"
        isOk = False
    End If
    Set pCli = Nothing

    If Not isOk Then Exit Sub

    Set fView = New lfQuickView
    Set qry = dbHandle.QueryDefs("qryProductosClienteDetallado")
    qry.Parameters("txCodigoCliente") = sCodCli
    qry.Parameters("dtFechaInicial") = fInic
    qry.Parameters("dtFechaFinal") = fFinal
    Set rs = qry.OpenRecordset(dbOpenForwardOnly)
    
    If Not rs.EOF Then
    Dim pItemV As clsItemVenta

        sCurrentItem = ""
        fView.SetReportWidth AnchoReporte
        
        AlmacenItemsVenta.Abrir
        Set pItemV = New clsItemVenta
        Encabezado
        
        With rs
        Do While Not .EOF
            If sCurrentItem <> .Fields("CodigoItem") Then
                sCurrentItem = .Fields("CodigoItem")
                If Not pItemV.Load(sCurrentItem) Then
                    pItemV.Descripcion = "CODIGO NO LOCALIZADO"
                End If
                On Error Resume Next
                AddLine sCodigoItem, pItemV.Descripcion, .Fields("FechaTransaccion"), .Fields("Serie"), .Fields("Correlativo"), .Fields("Cantidad"), .Fields("PrecioEfectivo") / .Fields("Cantidad")
            End If
            .MoveNext
        Loop
        End With
        Set pItemV = Nothing
        AlmacenItemsVenta.Cerrar

        fView.Show
        
        While fView.Visible: DoEvents: Wend
    
    Else
        
        mAdvertencia "No hay datos para el reporte"
    
    End If
    
    rs.Close
    Set rs = Nothing
    Set qry = Nothing
    Set fView = Nothing

End Sub
