VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRepValoracionGeneral"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Const ANCHO_REPORTE = 131

Private TotalesPorCuenta As clsColeccionResumen
Private TotalesPorLinea As clsColeccionResumen
Private TotalGeneral As Currency
Private WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim pItemInv As clsItemInventario, sExtract As String
Dim f2 As lfSelectRangoFechas
  bProcessed = True
  sExtract = Trim(left(Trim(strReportLine), 20))
  Set pItemInv = AlmacenItemsInventario.itemInventario(sExtract)
  If Not pItemInv Is Nothing Then
    If nLinePos < 80 Then
      pItemInv.Show
    Else
      Dim lMinvs As clsListaMovItemInv
      Set f2 = New lfSelectRangoFechas
      f2.Show 1
      If f2.Result Then
          Set lMinvs = New clsListaMovItemInv
          lMinvs.ListarMinvs pItemInv, f2.dtFechaInicial.Fecha, f2.dtFechaFinal.Fecha
          Set lMinvs = Nothing
      End If
      Unload f2
      Set f2 = Nothing
    End If
    Set pItemInv = Nothing
  End If


End Sub

'Inversiones La Polla de Hugo
'Valoracin general del inventario

'-----------------------------------------------------------------------------------------------------------------------------------
'Codigo               Linea    Descripcion                                    Existencia General  CostoUnitario          Valor Total
'-----------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999,99 9.999.999.999.999,99

Private Sub EncabezadoResumen(stTituloResumen As String)

    If stTituloResumen = "" Then
        stTituloResumen = "continuacion"
    End If
    
    Encabezado stTituloResumen

    fView.Add stMidAlign("---------------------------------------------------------------------------------------------", ANCHO_REPORTE)
    fView.Add stMidAlign("Codigo               Descripcion                                     Articulos    Valor Total", ANCHO_REPORTE)
    fView.Add stMidAlign("---------------------------------------------------------------------------------------------", ANCHO_REPORTE)
    
End Sub
'---------------------------------------------------------------------------------------------
'Codigo               Descripcion                                     Articulos    Valor Total
'---------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99.999 999.999.999,99

Private Sub AddLineaResumen(stCodigo As String, stNombre As String, dblCantidad As Double, vmValor As Currency)
Dim sOut As String

    If fView.Linea + 1 >= fView.LineasPagina Then EncabezadoResumen ""
    sOut = stFullLength(stCodigo, 20) & " "
    sOut = sOut & stFullLength(stNombre, 50) & " "
    sOut = sOut & FormatNumero(dblCantidad, "##,##0", 6) & " "
    sOut = sOut & FormatNumero(vmValor, "###,###,##0.00", 14)
    fView.Add stMidAlign(sOut, ANCHO_REPORTE)

End Sub

Private Sub Encabezado(stSubTitulo As String)

    If fView.Pagina > 1 Then fView.PageBreak

    fView.Add ""
    fView.Add stMidAlign(Empresa.NombreEmpresa, ANCHO_REPORTE)
    fView.Add stMidAlign("Reporte de valoracin del Inventario", ANCHO_REPORTE)
    fView.Add stMidAlign(stSubTitulo, ANCHO_REPORTE)
    fView.Add ""
    fView.Add "Emisin: " & Format(Now, "General Date") & "        OPERADOR: " & cUsuario.Codigo & "             Pgina:" & Str(fView.Pagina)
    fView.Add ""

End Sub

Private Sub EncabezadoDetalles()

    If TotalGeneral <> 0 Then
        PasarLinea "VAN", "", "", 0, 0, TotalGeneral
    End If
    
    Encabezado "Detalles por Producto"
    
    fView.Add String(ANCHO_REPORTE, "-")
    fView.Add "Codigo               Linea    Descripcion                                    Existencia General  CostoUnitario          Valor Total"
    fView.Add String(ANCHO_REPORTE, "-")
    
    If TotalGeneral <> 0 Then
        PasarLinea "VIENEN", "", "", 0, 0, TotalGeneral
    End If

End Sub

Private Sub PasarLinea(sCodigo As String, sLinea As String, sDescripcion As String, dblExistencia As Double, vmCosto As Currency, vmValorTotal As Currency)
Dim sOut As String
    
    sOut = stFullLength(sCodigo, 20) & " "
    sOut = sOut & stFullLength(sLinea, 8) & " "
    sOut = sOut & stFullLength(sDescripcion, 50) & " "
    sOut = sOut & FormatNumero(dblExistencia, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmCosto, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmValorTotal, "#,###,###,###,##0.00", 20)
    
    fView.Add sOut

End Sub

Private Sub AddLinea(sCodigo As String, sDescripcion As String, sLinea As String, dblExistencia As Double, stCuentaActivo As String, vmCosto As Currency)
Dim vmValorTotal As Currency

    vmValorTotal = dblExistencia * vmCosto
    
    If sLinea = "" Then sLinea = "<NIL>"
    If stCuentaActivo = "" Then stCuentaActivo = Empresa.CuentaGeneralInventario
    If stCuentaActivo = "" Then stCuentaActivo = "<NIL>"
    
    If fView.Linea + 1 >= fView.LineasPagina Then EncabezadoDetalles
    
    PasarLinea sCodigo, sLinea, sDescripcion, dblExistencia, vmCosto, vmValorTotal

    TotalesPorCuenta.Acumular stCuentaActivo, 1, vmValorTotal
    TotalesPorLinea.Acumular sLinea, 1, vmValorTotal
    TotalGeneral = TotalGeneral + vmValorTotal

End Sub

Private Sub ProcesarResumenes()
Dim pAtom As clsAtomResumen, pCuenta As clsCuenta, sNombreLinea As String

    Set pCuenta = New clsCuenta
    EncabezadoResumen "Resumen por cuenta"
    
    For Each pAtom In TotalesPorCuenta.Coleccion
        
        If Not pCuenta.Load(pAtom.Codigo) Then
            pCuenta.Titulo = "CUENTA NO REGISTRADA"
        End If
        
        AddLineaResumen pAtom.Codigo, pCuenta.Titulo, pAtom.Cantidad, pAtom.Valor
    Next
    Set pCuenta = Nothing
    
    EncabezadoResumen "Resumen por Lnea"
    
    For Each pAtom In TotalesPorLinea.Coleccion
    
        sNombreLinea = Lineas.Nombre(pAtom.Codigo)
        If sNombreLinea = "" Then sNombreLinea = "LINEA NO REGISTRADA"
        
        AddLineaResumen pAtom.Codigo, sNombreLinea, pAtom.Cantidad, pAtom.Valor
        
    Next

End Sub

Public Sub Generar()
Dim rs As Recordset, sQuery As String, sOrden As String, isOk As Boolean
Dim frmParams As frmFiltroItemsInv
Dim bGo As Boolean, sFiltro As String

  Set frmParams = New frmFiltroItemsInv
  ShowNonModal frmParams
  bGo = frmParams.bResult
  sFiltro = frmParams.FiltroSQL
  Unload frmParams
  Set frmParams = Nothing
  
  If Not bGo Then Exit Sub
  
  Screen.MousePointer = vbHourglass
  sQuery = "SELECT Codigo, Descripcion, Linea, Existencia, CuentaActivo, "
  If Empresa.valoracionInventario Then
    sQuery = sQuery & "UltimoCosto "
  Else
    sQuery = sQuery & "CostoPromedio "
  End If
  sQuery = sQuery & " AS Costo FROM ItemsInventario "
  sQuery = sQuery & sFiltro
  
  Set rs = dbHandle.Execute(sQuery)
  
  With rs
  If Not .EOF Then
  
    Set TotalesPorCuenta = New clsColeccionResumen
    Set TotalesPorLinea = New clsColeccionResumen
    Set fView = New lfQuickView
    fView.Caption = "Valoracin general del inventario"
  
    EncabezadoDetalles
  
    Do While Not .EOF
        AddLinea GetStringFromVariant(.Fields("Codigo")), GetStringFromVariant(.Fields("Descripcion")), GetStringFromVariant(.Fields("Linea")), GetNumeroFromVariant(.Fields("Existencia")), GetStringFromVariant(.Fields("CuentaActivo")), GetNumeroFromVariant(.Fields("Costo"))
        .MoveNext
    Loop
    
    PasarLinea "TOTAL", "", "Valor total de la existencia", 0, 0, TotalGeneral
    
    ProcesarResumenes
    Screen.MousePointer = vbDefault
  
    fView.Show
    
    While fView.Visible: DoEvents: Wend
    
    Unload fView
    Set fView = Nothing
    
    Set TotalesPorCuenta = Nothing
    Set TotalesPorLinea = Nothing
  
  End If
  End With
  
  rs.Close
  Set rs = Nothing
  Screen.MousePointer = vbDefault
  
End Sub
