VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRepUltimaVentaProdCli"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit


Private Const AnchoReporte = 113

Private finic As Date, ffinal As Date
Private sCurrentItem As String
Private sCodCli As String, sNombreCli As String
Private fView As lfQuickView

'Inversiones La Puyita, s.r.l.

'Ultimas ventas por producto
'Cliente: XXXXXXXXXXXXXXXXXXXxXXX (XXXXXXXX)
'Intervalo de consulta: 99-99-9999 al 99-99-9999

'-----------------------------------------------------------------------------------------------------------------
'Codigo del Producto  Descripcion                               Fecha    Factura         Cantidad     Precio Unit.
'-----------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99-99-9999 XXX-0000000 9.999.999,99 9.999.999.999,99

Private Sub AddLine(sCodigo As String, sDescripcion As String, dtFecha As Date, stSerie As String, lCorrelativo As Long, dblCantidad As Double, vmPrecioUnit As Currency)
Dim sOut As String

    sOut = stFullLength(sCodigo, 20) & " "
    sOut = sOut & stFullLength(sDescripcion, 39) & " "
    sOut = sOut & stRightAlign(Format(dtFecha, "Short Date"), 10) & " "
    sOut = sOut & stFullLength(stSerie & "-" & Format(lCorrelativo, "0000000"), 11) & " "
    sOut = sOut & FormatNumero(dblCantidad, "#,###,##0.00", 12) & " "
    sOut = sOut & FormatNumero(vmPrecioUnit, "#,###,###,##0.00", 16)
    
    If fView.Linea > fView.LineasPagina - 1 Then Encabezado
    
    fView.Add sOut

End Sub

Private Sub Encabezado()
    
    If sCurrentItem <> "" Then
        fView.PageBreak
    End If
    
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Ultimas ventas por producto", AnchoReporte)
    fView.Add stMidAlign("Cliente: " & sNombreCli & " (" & sCodCli & ")", AnchoReporte)
    fView.Add stMidAlign("Intervalo de consulta: " & Format(finic, "Short Date") & " al " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Operador: " & UsuarioActivo.Codigo & "       Emision:" & Format(Now, "General Date") & "    Pagina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add "Codigo del Producto Descripcion                                Fecha    Factura         Cantidad     Precio Unit."
    fView.Add String(AnchoReporte, "-")

End Sub

Public Function UltimaVentaProducto(sCliente As String, sItem As String) As clsDetalleItemVenta
Dim pRetVal As clsDetalleItemVenta
Dim sQuery As String, rs As Recordset
  sQuery = "SELECT * FROM DetallesItemVenta " & _
           "WHERE CodigoItem = " & StringDB(sItem) & " " & _
           "AND CodigoCliente = " & StringDB(sCliente) & " " & _
           "AND TipoDocumento = 'FCT' " & _
           "AND FechaOperacion IN (SELECT MAX(FechaOperacion) " & _
                                   "FROM DetallesItemVenta " & _
                                   "WHERE CodigoCliente = " & StringDB(sCliente) & " " & _
                                   "AND TipoDocumento = 'FCT' " & _
                                   "AND CodigoItem = " & StringDB(sItem) & ");"
  Set rs = dbHandle.Execute(sQuery)
  If Not rs.EOF Then
    Set pRetVal = New clsDetalleItemVenta
    If pRetVal.LoadInstance(rs) = False Then
      Set pRetVal = Nothing
    End If
  End If

  Set UltimaVentaProducto = pRetVal
End Function

Public Sub Go(sCodigo As String)
Dim isOk As Boolean
Dim pCli As clsClientes
Dim rs As Recordset, sQuery As String, sTag As String

    isOk = True
    sCodCli = sCodigo
    Set pCli = New clsClientes
    If pCli.Load(sCodigo) Then
        sNombreCli = pCli.Nombre
    Else
        mAdvertencia "No localic el registro del cliente"
        isOk = False
    End If
    Set pCli = Nothing

    If Not isOk Then Exit Sub

    sQuery = "SELECT D.CodigoItem, D.Descripcion, D.Cantidad * D.FactorEmpaque AS ActualQty, D.PrecioEfectivo, F.Serie, F.Correlativo, F.FechaTransaccion "
    sQuery = sQuery & "FROM DetallesFactura AS D, Facturas AS F "
    sQuery = sQuery & "WHERE f.CodigoCliente = " & StringDB(sCodCli) & " "
    sQuery = sQuery & "AND D.CodigoItem <> '' "
    sQuery = sQuery & "AND F.Numero = D.NumeroDocumento "
    sQuery = sQuery & "AND F.FechaTransaccion IN "
    sQuery = sQuery & "  (SELECT Max(FechaTransaccion) FROM Facturas WHERE D.CodigoItem IN "
    sQuery = sQuery & "     (SELECT CodigoItem FROM DetallesFactura"
    sQuery = sQuery & "      WHERE detallesFactura.NumeroDocumento = Facturas.Numero"
    sQuery = sQuery & "      AND Facturas.CodigoCliente = " & StringDB(sCodCli) & "));"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault


    If Not rs.EOF Then
        
        Screen.MousePointer = vbHourglass
        sTag = ""
        Set fView = New lfQuickView
        fView.Caption = "Ultimas ventas por Producto/Cliente"
        sCurrentItem = ""
        fView.SetReportWidth AnchoReporte
        
        Encabezado
        
        With rs
        Do While Not .EOF
            If sTag <> .Fields("CodigoItem") Then
                sTag = .Fields("CodigoItem")
                AddLine sTag, .Fields("Descripcion"), .Fields("FechaTransaccion"), .Fields("Serie"), .Fields("Correlativo"), .Fields("ActualQTY"), .Fields("PrecioEfectivo") / .Fields("ActualQTY")
            End If
            .MoveNext
        Loop
        End With

        Screen.MousePointer = vbDefault
        fView.Show
        
        While fView.Visible: DoEvents: Wend
        
        Unload fView
        Set fView = Nothing
    
    Else
        
        mAdvertencia "No hay datos para el reporte"
    
    End If
    
    rs.Close
    Set rs = Nothing

End Sub


