VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRepUltimaCompraProdProv"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 159

Private finic As Date, ffinal As Date
Private sCurrentItem As String
Private sCodProv As String, sNombreProv As String
Private fView As lfQuickView

'Inversiones La Puyita, s.r.l.

'Ultimas ventas por producto
'Proveedor: XXXXXXXXXXXXXXXXXXXxXXX (XXXXXXXX)
'Intervalo de consulta: 99-99-9999 al 99-99-9999

'---------------------------------------------------------------------------------------------------------------------------------------------------------------
'Codigo del Producto  Descripcion                               Fecha    Factura      Present.     Q/Pres   Facturadas    Promocion     Valor Total     Unitario
'---------------------------------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99-99-9999 XXXXXXXXXXXX XXXXXXXXXXXX 99.999 9.999.999,99 9.999.999,99  999.999.999,99 9.999.999,99

Private Sub AddLine( _
        sCodigo As String, _
        sDescripcion As String, _
        dtFecha As Date, _
        stFactura As String, _
        stPresentacion As String, _
        dblFactorPres As Double, _
        dblCantFact As Double, _
        dblCantProm As Double, _
        vmPrecioNominal As Currency)
Dim sOut As String, vmValorTotal As Currency, vmPrecioUnit As Currency

    vmValorTotal = vmPrecioNominal * dblCantFact
    vmPrecioUnit = vmValorTotal / ((dblCantFact + dblCantProm) * dblFactorPres)

    sOut = stFullLength(sCodigo, 20) & " "
    sOut = sOut & stFullLength(sDescripcion, 39) & " "
    sOut = sOut & stRightAlign(Format(dtFecha, "Short Date"), 10) & " "
    sOut = sOut & stFullLength(stFactura, 12) & " "
    sOut = sOut & stFullLength(stPresentacion, 12) & " "
    sOut = sOut & FormatNumero(dblFactorPres, "##,##0", 6) & " "
    sOut = sOut & FormatNumero(dblCantFact, "#,###,##0.00", 12) & " "
    sOut = sOut & FormatNumero(dblCantProm, "#,###,##0.00", 12) & " "
    sOut = sOut & FormatNumero(vmValorTotal, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmPrecioUnit, "#,###,##0.00", 12) & " "
    
    If fView.Linea > fView.LineasPagina - 1 Then Encabezado
    
    fView.Add sOut

End Sub

Private Sub Encabezado()
    
    If sCurrentItem <> "" Then
        fView.PageBreak
    End If
    
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Ultimas compras por producto", AnchoReporte)
    fView.Add stMidAlign("Proveedor: " & sNombreProv & " (" & sCodProv & ")", AnchoReporte)
    fView.Add stMidAlign("Intervalo de consulta: " & Format(finic, "Short Date") & " al " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Operador: " & UsuarioActivo.Codigo & "       Emision:" & Format(Now, "General Date") & "    Pagina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add "Codigo del Producto  Descripcion                               Fecha    Factura      Present.     Q/Pres   Facturadas    Promocion     Valor Total     Unitario"
    fView.Add String(AnchoReporte, "-")

End Sub

Public Sub Go(sCodigo As String)
Dim isOk As Boolean
Dim pProv As clsProveedores
Dim rs As Recordset, sQuery As String

    isOk = True
    sCodProv = sCodigo
    Set pProv = New clsProveedores
    If pProv.Load(sCodigo) Then
        sNombreProv = pProv.Nombre
    Else
        mAdvertencia "No localic el registro del proveedor"
        isOk = False
    End If
    Set pProv = Nothing

    If Not isOk Then Exit Sub

    sQuery = "SELECT D.*, C.FechaTransaccion, C.RefProveedor "
    sQuery = sQuery & "FROM DetallesCompra AS D, Compras AS C "
    sQuery = sQuery & "WHERE D.NumeroDocumento = c.Numero "
    sQuery = sQuery & "AND D.CodigoItem <> '' "
    sQuery = sQuery & "AND C.CodigoProveedor = " & StringDB(sCodProv) & " "
    sQuery = sQuery & "AND C.FechaTransaccion  IN "
    sQuery = sQuery & "    (SELECT Max(FechaTransaccion) From Compras, DetallesCompra "
    sQuery = sQuery & "     WHERE Compras.Numero = DetallesCompra.NumeroDocumento "
    sQuery = sQuery & "     AND DetallesCompra.CodigoItem = D.CodigoItem) "
    sQuery = sQuery & "ORDER BY D.Descripcion;"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then
    
        Screen.MousePointer = vbHourglass
        Set fView = New lfQuickView
        fView.Caption = "Ultimas compras por producto"

        fView.SetReportWidth AnchoReporte
        
        Encabezado
        
        With rs
        Do While Not .EOF
            sCurrentItem = .Fields("CodigoItem")
            AddLine _
                sCurrentItem, _
                .Fields("Descripcion"), _
                .Fields("FechaTransaccion"), _
                .Fields("RefProveedor"), _
                .Fields("Presentacion"), _
                .Fields("FactorEmpaque"), _
                .Fields("CantidadFacturada"), _
                .Fields("CantidadPromocion"), _
                .Fields("PrecioNominal")
            .MoveNext
        Loop
        End With

        Screen.MousePointer = vbDefault
        fView.Show
        
        While fView.Visible: DoEvents: Wend
        
        Unload fView
        Set fView = Nothing
    
    Else
        
        mAdvertencia "No hay datos para el reporte"
    
    End If
    
    rs.Close
    Set rs = Nothing

End Sub

