VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRepListaMovimientosBanco"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Const AnchoReporte = 115

'Inversiones La Cucaracha
'Movimientos Bancarios
'Banco: XXXXXXXXXXXXX (XXXXXXXXX)
'Entre el 99-99-9999 y el 99-99-9999
'
'Operador: XXXXXXXXX  Emision: XXXXXXXXXXXXXXX       Pg: 999
'-------------------------------------------------------------------------------------------------------------------
'Fecha      Tipo Numero       Beneficiario/Descripcion                                     Debitos          Creditos
'-------------------------------------------------------------------------------------------------------------------
'99-99-9999 XXX  XXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99.999.999.999,99 99.999.999.999,99

Private sCodigo As String, pBanco As clsBancos
Private finic As Date, ffinal As Date
Private fView As lfQuickView
Private vmTotDebe As Currency, vmTotHaber As Currency

Private Sub Encabezado(isFirst As Boolean)

    If Not isFirst Then
        AddLinea "VAN", "", "", "", vmTotDebe, vmTotHaber
        fView.PageBreak
    End If

    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Listado de Movimientos del Banco", AnchoReporte)
    fView.Add stMidAlign("Banco: " & pBanco.Cuenta & " (" & pBanco.Codigo & ")", AnchoReporte)
    fView.Add stMidAlign("Intervalo de consulta: " & Format(finic, "Short Date") & " al " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Operador: " & UsuarioActivo.Codigo & "       Emision:" & Format(Now, "General Date") & "    Pagina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add "Fecha      Tipo Numero       Beneficiario/Descripcion                                     Debitos          Creditos"
    fView.Add String(AnchoReporte, "-")

    If Not isFirst Then
        AddLinea "VIENEN", "", "", "", vmTotDebe, vmTotHaber
    End If

End Sub

Private Sub AddLinea( _
    dFecha As String, _
    sTipo As String, _
    sNumero As String, _
    sDescripcion As String, _
    vmDebe As Currency, _
    vmHaber As Currency)
Dim sOut As String

'99-99-9999 XXX  XXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99.999.999.999,99 99.999.999.999,99
    sOut = stFullLength(dFecha, 10) & " "
    sOut = sOut & stFullLength(sTipo, 3) & "  "
    sOut = sOut & stFullLength(sNumero, 12) & " "
    sOut = sOut & stFullLength(sDescripcion, 50) & " "
    sOut = sOut & FormatNumero(vmDebe, "##,###,###,##0.00", 17) & " "
    sOut = sOut & FormatNumero(vmHaber, "##,###,###,##0.00", 17)
    
    If sTipo <> "" Then
        If fView.Linea >= fView.LineasPagina - 3 Then
            Encabezado False
        End If
    End If

    fView.Add sOut

End Sub

Public Sub Go(stCodigoBanco As String)
Dim f As fSelParmsListaMovsBanco, i As Integer
Dim bTiposMov(4) As Boolean, sQuery As String
Dim rs As Recordset
Dim vmDebe As Currency, vmHaber As Currency, stDescField As String, stDateField As String, vmMonto As Currency

    Set pBanco = New clsBancos
    If Not pBanco.Load(stCodigoBanco) Then
        mAdvertencia "Imposible acceder a ficha del banco " & stCodigoBanco
        Set pBanco = Nothing
        Exit Sub
    End If
    
    Set f = New fSelParmsListaMovsBanco
    
    Centrar f
    f.Show
    While f.Visible: DoEvents: Wend

    If Not f.Result Then
        Unload f
        Set f = Nothing
        Set pBanco = Nothing
        Exit Sub
    End If

    finic = f.dtFechaInicial
    ffinal = f.dtFechaFinal
    For i = 0 To 3
        bTiposMov(i) = (f.chkTiposMov(i).Value = vbChecked)
    Next

    Unload f
    Set f = Nothing


    sQuery = "SELECT FechaTransaccion, Operador, Tipo, Concepto, Beneficiario, Monto, ReferenciaBanco, Conciliado, FechaEfectivo "
    sQuery = sQuery & "From MovimientosBanco "
    sQuery = sQuery & "Where CodigoBanco = " & StringDB(stCodigoBanco) & " "
    sQuery = sQuery & "AND FechaTransaccion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & " "
    sQuery = sQuery & "ORDER BY FechaTransaccion, Numero;"

    Screen.MousePointer = vbHourglass

    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault

    With rs
    If Not .EOF Then
        Set fView = New lfQuickView
        fView.Caption = "Listado de Movimientos Bancarios"
        fView.SetNotify Me

        Encabezado True
        
        Do While Not .EOF
        
            If bTiposMov(.Fields("Tipo")) Then

                If .Fields("Tipo") = TMB_CHEQUE Then
                    stDescField = .Fields("Beneficiario")
                Else
                    stDescField = .Fields("Concepto")
                End If

                vmMonto = .Fields("Monto")
                If vmMonto < 0 Then
                    vmDebe = 0
                    vmHaber = -vmMonto
                Else
                    vmDebe = vmMonto
                    vmHaber = 0
                End If
                vmTotDebe = vmTotDebe + vmDebe
                vmTotHaber = vmTotHaber + vmHaber

                stDateField = Format(.Fields("FechaTransaccion"), "Short Date")
                
                AddLinea stDateField, pBanco.ImagenTipoMovimiento(.Fields("Tipo")), .Fields("ReferenciaBanco"), stDescField, vmDebe, vmHaber
                
                If .Fields("Tipo") = TMB_CHEQUE Then
                    AddLinea "", "", "", .Fields("Concepto"), 0, 0
                End If
            
            End If

            .MoveNext

        Loop
    
        AddLinea "TOTAL", "", "", "", vmTotDebe, vmTotHaber
        
        fView.Show
        
        While fView.Visible: DoEvents: Wend
        
        Unload fView
        Set fView = Nothing

    End If
    .Close
    End With
    
    Set rs = Nothing

End Sub

'Fecha      Tipo Numero       Beneficiario/Descripcion                                     Debitos          Creditos
'-------------------------------------------------------------------------------------------------------------------
'99-99-9999 XXX  XXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99.999.999.999,99 99.999.999.999,99

Public Sub ReportClicked(sLinea As String, lPos As Long)
Dim s As String, sTipo As String, sRef As String
Dim pMov As clsMovimientoBanco

    s = Trim(sLinea)
    sTipo = Trim(Mid(sLinea, 13, 3))
    sRef = Trim(Mid(sLinea, 17, 12))
    Set pMov = New clsMovimientoBanco
    If pMov.LoadFromRef(pBanco.Codigo, sTipo, sRef) Then
        pMov.Show
    End If
    Set pMov = Nothing

End Sub
