VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRepLibroVentas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 209

Private fView As lfQuickView
Private finic As Date, ffinal As Date
Private pCliente As clsClientes
Private totGen As Currency, totExento As Currency, _
        totGravable1 As Currency, totImpuesto1 As Currency, _
        totGravable2 As Currency, totImpuesto2 As Currency
'Fecha      Nombre del Proveedor                     Factura           Comentarios              R.I.F.          Monto Total         Exento     Gravable 1   (%)     Impuesto 1     Gravable 2   (%)     Impuesto 2
'99-99-9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXX 999.999.999,99 999.999.999,99 999.999.999,99 99,99 999.999.999,99 999.999.999,99 99,99 999.999.999,99

Private Sub ImprimirLinea( _
                sFecha As String, _
                sNombre As String, _
                sRef As String, _
                sDoc As String, _
                sRif As String, _
                vTotal As Currency, _
                vExento As Currency, _
                vGravable1 As Currency, _
                dPorcentaje1 As Double, _
                vImpuesto1 As Currency, _
                vGravable2 As Currency, _
                dPorcentaje2 As Double, _
                vImpuesto2 As Currency)
Dim sOut As String

  sOut = stFullLength(sFecha, 10) & " "
  sOut = sOut & stFullLength(sNombre, 40) & " "
  sOut = sOut & stFullLength(sRef, 17) & " "
  sOut = sOut & stFullLength(sDoc, 24) & " "
  sOut = sOut & stFullLength(sRif, 12) & " "
  sOut = sOut & FormatNumero(vTotal, Empresa.MascaraMonetarios, 14) & " "
  sOut = sOut & FormatNumero(vExento, Empresa.MascaraMonetarios, 14) & " "
  sOut = sOut & FormatNumero(vGravable1, Empresa.MascaraMonetarios, 14) & " "
  sOut = sOut & FormatNumero(dPorcentaje1, "#0.00", 5) & " "
  sOut = sOut & FormatNumero(vImpuesto1, Empresa.MascaraMonetarios, 14)
  sOut = sOut & FormatNumero(vGravable2, Empresa.MascaraMonetarios, 14) & " "
  sOut = sOut & FormatNumero(dPorcentaje2, "#0.00", 5) & " "
  sOut = sOut & FormatNumero(vImpuesto2, Empresa.MascaraMonetarios, 14)

  fView.Add sOut

End Sub

Private Sub Encabezado()

  If fView.Pagina > 1 Or fView.Linea > 1 Then
    ImprimirLinea "VAN", "", "", "", "", totGen, totExento, totGravable1, 0#, totImpuesto1, totGravable2, 0#, totImpuesto2
    fView.PageBreak
  End If
  
  fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
  fView.Add stMidAlign("LIBRO DE VENTAS", AnchoReporte)
  fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
  fView.Add ""
  fView.Add "Emision: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo & ".     Pgina: " & fView.Pagina
  fView.Add String(AnchoReporte, "-")
  fView.Add "Fecha      Nombre del Cliente                       Factura           Comentarios              R.I.F.          Monto Total         Exento     Gravable 1   (%)     Impuesto 1     Gravable 2   (%)     Impuesto 2"
  fView.Add String(AnchoReporte, "-")
  
  If fView.Pagina > 1 Then
    ImprimirLinea "VIENEN", "", "", "", "", totGen, totExento, totGravable1, 0#, totImpuesto1, totGravable2, 0#, totImpuesto2
  End If

End Sub

Private Sub PasarLinea( _
                dFecha As Date, _
                sCodigo As String, _
                sRef As String, _
                sRif As String, _
                sDocumento As String, _
                vTotal As Currency, _
                vExento As Currency, _
                vGravable1 As Currency, _
                dPorcentaje1 As Double, _
                vImpuesto1 As Currency, _
                vGravable2 As Currency, _
                dPorcentaje2 As Double, _
                vImpuesto2 As Currency)

  If fView.Linea > fView.LineasPagina - 4 Then
    Encabezado
  End If
  
  If Not pCliente.Load(sCodigo) Then
    pCliente.Nombre = "DESAPARECIDO!!!"
  End If

  ImprimirLinea Format(dFecha, "Short Date"), pCliente.Nombre, sRef, sDocumento, sRif, vTotal, vExento, vGravable1, dPorcentaje1, vImpuesto1, vGravable2, dPorcentaje2, vImpuesto2
  
  totGen = totGen + vTotal
  totExento = totExento + vExento
  totGravable1 = totGravable1 + vGravable1
  totImpuesto1 = totImpuesto1 + vImpuesto1
  totGravable2 = totGravable2 + vGravable2
  totImpuesto2 = totImpuesto2 + vImpuesto2

End Sub

Public Sub Generar()
Dim f As lfSelectRangoFechas, bResult As Boolean
Dim rs As Recordset, sQuery As String

  Set f = New lfSelectRangoFechas
  
  f.dtFechaFinal = Date
  f.dtFechaInicial = BuildFecha(1, Month(Date), Year(Date))
  
  f.Caption = "Libro de Ventas"
  
  f.Show 1
  
  finic = f.dtFechaInicial: ffinal = f.dtFechaFinal

  bResult = f.Result
  
  Unload f
  Set f = Nothing

  If Not bResult Then Exit Sub

  sQuery = "SELECT * FROM LibroVentas WHERE Fecha BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & " ORDER BY Fecha, Factura"
  
  Screen.MousePointer = vbHourglass
  Set rs = dbHandle.Execute(sQuery)
  Screen.MousePointer = vbDefault
  
  If Not rs.EOF Then
  
    totGen = 0
    totExento = 0
    totGravable1 = 0
    totImpuesto1 = 0
    totGravable2 = 0
    totImpuesto2 = 0

    Screen.MousePointer = vbHourglass
    Set pCliente = New clsClientes
    Set fView = New lfQuickView
    fView.SetReportWidth AnchoReporte
    fView.Caption = "Libro de Ventas, entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date")
    Encabezado
    
    Do While Not rs.EOF
      PasarLinea rs!Fecha, rs!Cliente, rs!Factura, rs!RIF, GetStringFromVariant(rs!Documento), _
                GetNumeroFromVariant(rs!MontoBruto), GetNumeroFromVariant(rs!Exento), _
                GetNumeroFromVariant(rs!Gravable1), GetNumeroFromVariant(rs!Porcentaje1), _
                GetNumeroFromVariant(rs!MontoRetencion1), GetNumeroFromVariant(rs!Gravable2), _
                GetNumeroFromVariant(rs!Porcentaje2), GetNumeroFromVariant(rs!MontoRetencion2)
      rs.MoveNext
    Loop

    ImprimirLinea "TOTAL", "", "", "", "", totGen, totExento, totGravable1, 0#, totImpuesto1, totGravable2, 0#, totImpuesto2
    
    Screen.MousePointer = vbDefault
    ShowNonModal fView
    
    Unload fView
    Set fView = Nothing
    Set pCliente = Nothing

  End If


  rs.Close
  Set rs = Nothing

End Sub

