VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRepDocumentosEntidad"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 99

Private finic As Date, ffinal As Date
Private sCurrentItem As String
Private sCodEnt As String, sNombreEnt As String, sClaseEnt As String
Private vmLadoNormal As Currency
Private fView As lfQuickView
Private nCurDoc As Long
Private tDeb As Currency, tCred As Currency, SaldoFinal As Currency

'---------------------------------------------------------------------------------------------------
'Fecha      Descripcion                                                      DEBE              HABER
'---------------------------------------------------------------------------------------------------
'99-99-9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ###,###,###,##0,00 ###,###,###,##0.00


Private Sub Encabezado()
    
    If nCurDoc <> 0 Then
        fView.PageBreak
    End If
    
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Documentos Pendientes", AnchoReporte)
    fView.Add stMidAlign(sClaseEnt & ": " & sNombreEnt & " (" & sCodEnt & ")", AnchoReporte)
    fView.Add ""
    fView.Add "Operador: " & UsuarioActivo.Codigo & "       Emision:" & Format(Now, "General Date") & "    Pagina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add "Fecha      Descripcion                                                      DEBE              HABER"
    fView.Add String(AnchoReporte, "-")

End Sub

Private Sub AddLine(nDoc As Long, dFecha As Date, sDescripcion As String, vmDebitos As Currency, vmCreditos As String)
Dim sOut As String
'99-99-9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ###,###,###,##0,00 ###,###,###,##0.00

    If nDoc <> nCurDoc Then
        
        If nCurDoc Then
          SaldoFinal = SaldoFinal + tDeb - tCred

          If tDeb > tCred Then
              tDeb = tDeb - tCred
              tCred = 0
          Else
              tCred = tCred - tDeb
              tDeb = 0
          End If
          sOut = stFullLength("Saldo actual del documento", 62) & FormatNumero(tDeb, "###,###,###,##0.00", 18) & " " & FormatNumero(tCred, "###,###,###,##0.00", 18)
          fView.Add sOut
          fView.Add ""
        
        End If
        
        tDeb = 0: tCred = 0
        nCurDoc = nDoc
    
    End If

    If fView.Linea >= fView.LineasPagina - 2 Then
        
        Encabezado
    
    End If

    sOut = stFullLength(Format(dFecha, "Short Date"), 10) & " "
    sOut = sOut & stFullLength(sDescripcion, 50) & " "
    sOut = sOut & FormatNumero(vmDebitos, "###,###,###,##0.00", 18) & " "
    sOut = sOut & FormatNumero(vmCreditos, "###,###,###,##0.00", 18)
    
    fView.Add sOut

    tDeb = tDeb + vmDebitos
    tCred = tCred + vmCreditos
End Sub

Public Sub Go(stTipo As String, stCodigo As String, stNombre As String, stClase As String)
Dim sQuery As String, rs As Recordset

    sCodEnt = stCodigo: sNombreEnt = stNombre: sClaseEnt = stClase

    sQuery = "SELECT * FROM DocumentosISPC LEFT JOIN DetallesCuentaEntidad ON DocumentosISPC.Numero = DetallesCuentaEntidad.Documento "
    sQuery = sQuery & "WHERE DocumentosISPC.TipoEntidad = " & StringDB(stTipo) & " "
    sQuery = sQuery & "AND DocumentosISPC.CodigoEntidad = " & StringDB(stCodigo) & " "
    sQuery = sQuery & "AND DocumentosISPC.Saldo <> 0;"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then

        Screen.MousePointer = vbHourglass
        Set fView = New lfQuickView
        fView.Caption = "Documentos pendientes: " & stClase & ", " & stNombre

        fView.SetReportWidth AnchoReporte
        nCurDoc = 0
        Encabezado

        With rs
        Do While Not .EOF
            AddLine GetNumeroFromVariant(.Fields("Numero")), GetDateFromVariant(.Fields("Fecha")), stGetStringFromVariant(.Fields("Descripcion")), GetNumeroFromVariant(.Fields("Debe")), GetNumeroFromVariant(.Fields("Haber"))
            .MoveNext
        Loop
        End With

        SaldoFinal = SaldoFinal + tDeb - tCred

        If tDeb > tCred Then
            tDeb = tDeb - tCred
            tCred = 0
        Else
            tCred = tCred - tDeb
            tDeb = 0
        End If

        fView.Add stFullLength("Saldo actual del documento", 62) & FormatNumero(tDeb, "###,###,###,##0.00", 18) & " " & FormatNumero(tCred, "###,###,###,##0.00", 18)
        fView.Add stFullLength("Saldo total", 81) & FormatNumero(SaldoFinal, "###,###,###,##0.00", 18)
        fView.Caption = "Documentos pendientes del " & stClase & stNombre
        Screen.MousePointer = vbDefault
        fView.Show

        While fView.Visible: DoEvents: Wend
        
        Unload fView
        Set fView = Nothing
    
    Else
        
        mAdvertencia "No hay datos para el reporte"
    
    End If
    
    rs.Close
    Set rs = Nothing

End Sub
