VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRepCompTotProvProd"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 120

Private finic As Date, fFinal As Date
Private sCodProv As String, sNombreProv As String
Private fView As lfQuickView

'Inversiones La Puyita, s.r.l.

'Ventas resumidas por producto
'Cliente: XXXXXXXXXXXXXXXXXXXxXXX (XXXXXXXX)
'Intervalo de consulta: 99-99-9999 al 99-99-9999

'------------------------------------------------------------------------------------------------------------------------
'Codigo del Producto  Descripcion                                                Cantidad   Precio Medio      Valor Total
'------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX #,###,###,##0.00 ###,###,##0.00 #,###,###,##0.00

Private Sub AddLine(sCodigo As String, sDescripcion As String, dCantidad As Double, vmTotal As Currency)
Dim vmUnit As Currency
Dim sOut As String

    If Abs(dCantidad) < 0.1 Then Exit Sub
    vmUnit = vmTotal / dCantidad
    sOut = stFullLength(sCodigo, 20) & " "
    sOut = sOut & stFullLength(sDescripcion, 50) & " "
    sOut = sOut & FormatNumero(dCantidad, "#,###,###,##0.00", 16) & " "
    sOut = sOut & FormatNumero(vmUnit, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmTotal, "#,###,###,##0.00", 16)
    
    If fView.Linea > fView.LineasPagina - 1 Then Encabezado
    
    fView.Add sOut

End Sub

Private Sub Encabezado()
    
    If fView.Pagina <> 1 Then
        fView.PageBreak
    End If
    
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Compras Resumidas por Producto", AnchoReporte)
    fView.Add stMidAlign("Proveedor: " & sNombreProv & " (" & sCodProv & ")", AnchoReporte)
    fView.Add stMidAlign("Intervalo de consulta: " & Format(finic, "Short Date") & " al " & Format(fFinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Operador: " & UsuarioActivo.Codigo & "       Emision:" & Format(Now, "General Date") & "    Pagina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add "Codigo del Producto  Descripcion                                                Cantidad   Precio Medio      Valor Total"
    fView.Add String(AnchoReporte, "-")

End Sub

Public Sub Go(sCodigo As String)
Dim f As lfSelectRangoFechas, isOk As Boolean
Dim pProv As clsProveedores
Dim rs As Recordset, sQuery As String

    Set f = New lfSelectRangoFechas
    Centrar f
    f.Show 1
    If f.Result Then
        finic = f.dtFechaInicial.Fecha
        fFinal = f.dtFechaFinal.Fecha
        isOk = True
    Else
        isOk = False
    End If
    Unload f
    Set f = Nothing

    If Not isOk Then Exit Sub

    sCodProv = sCodigo
    Set pProv = New clsProveedores
    If pProv.Load(sCodigo) Then
        sNombreProv = pProv.Nombre
    Else
        mAdvertencia "No localic el registro del Proveedor"
        isOk = False
    End If
    Set pProv = Nothing

    If Not isOk Then Exit Sub

    sQuery = "SELECT DetallesCompra.CodigoItem, DetallesCompra.Descripcion, "
    sQuery = sQuery & "Sum((DetallesCompra.CantidadFacturada + DetallesCompra.CantidadPromocion) * DetallesCompra.FactorEmpaque) AS CantidadTotal, "
    sQuery = sQuery & "Sum(DetallesCompra.CantidadFacturada * DetallesCompra.FactorEmpaque * DetallesCompra.CostoUnitario) AS ValorVenta "
    sQuery = sQuery & "FROM DetallesCompra, Compras "
    sQuery = sQuery & "WHERE Compras.FechaTransaccion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(fFinal) & " "
    sQuery = sQuery & "AND Compras.CodigoProveedor = " & StringDB(sCodProv) & " "
    sQuery = sQuery & "AND CodigoItem <> '' "
    sQuery = sQuery & "AND Compras.Numero = DetallesCompra.NumeroDocumento "
    sQuery = sQuery & "GROUP BY CodigoItem, Descripcion "
    sQuery = sQuery & "ORDER BY Descripcion;"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then
    Dim pItemInv As clsItemInventario

        Screen.MousePointer = vbHourglass
        Set fView = New lfQuickView
        fView.Caption = "Compras al proveedor resumidas por producto"
        fView.SetReportWidth AnchoReporte
        
        Encabezado
        
        With rs
        Do While Not .EOF
            On Error GoTo 0
            AddLine .Fields("CodigoItem"), .Fields("Descripcion"), .Fields("CantidadTotal"), .Fields("ValorVenta")
            .MoveNext
        Loop
        End With

        Screen.MousePointer = vbDefault
        fView.Show
        
        While fView.Visible: DoEvents: Wend
        
        Unload fView
        Set fView = Nothing
    
    Else
        
        mAdvertencia "No hay datos para el reporte"
    
    End If
    
    rs.Close
    Set rs = Nothing
    Set fView = Nothing

End Sub

