VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRenglonSesion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public SesionID As Long
Public NumeroRenglon As Integer
Public CodigoItem As String
Public PrecioUnitario As Currency
Public Cantidad As Double
Public PorcentajeImpuesto As Double
Public TipoImpuesto As String
Public PrecioLista As Currency
Public Usuario As String

Private Const Redondeo = 5

Public Function PrecioUnitarioConIVA() As Currency

    LoadPorcentajeImpuesto
    PrecioTotal
    PrecioUnitarioConIVA = PrecioUnitario * (1# + PorcentajeImpuesto / 100)

End Function

Public Function PrecioTotalConIVA() As Currency

    LoadPorcentajeImpuesto
    PrecioTotal
    PrecioTotalConIVA = PrecioUnitario * Cantidad * (1# + PorcentajeImpuesto / 100)

End Function

Public Function ItemVenta() As clsItemVenta
Dim pItemVenta As clsItemVenta

    Set pItemVenta = New clsItemVenta
    If Not pItemVenta.Load(Me.CodigoItem) Then
        Set pItemVenta = Nothing
    End If
    
    Set ItemVenta = pItemVenta

End Function

'Public Function PrecioLista() As Currency
'Dim pItem As clsItemVenta
'
'    Set pItem = Me.ItemVenta
'    If pItem Is Nothing Then
'        PrecioLista = Me.PrecioUnitario
'    Else
'        PrecioLista = pItem.PrecioNeto(1)
'        Set pItem = Nothing
'    End If
'
'End Function

Public Sub LoadPorcentajeImpuesto()
Dim rs As Recordset
  Set rs = dbHandle.Execute("SELECT TipoImpuesto1 FROM ItemsVenta WHERE Codigo = " & StringDB(Me.CodigoItem))
  If rs.EOF Then
    PorcentajeImpuesto = 0
  Else
    PorcentajeImpuesto = TiposImpuesto.ValorActualImpuesto(GetStringFromVariant(rs(0)))
  End If
End Sub

Public Function PrecioTotal() As Currency
Dim dblPrecio As Double
Static vmFactor As Currency
Dim bModificarLista As Currency

  If vmFactor = 0 Then
    vmFactor = Val(GetSetting("ClearLight", "General", "RedondeoPOS", "0"))
  End If
  
  If vmFactor = 0 Then
  PrecioTotal = Int(Cantidad * 1000 + 0.5) / 1000 * PrecioUnitario
  Exit Function
  End If
  
  If Cantidad = 0 Then
    PrecioTotal = 0
    Exit Function
  End If
  
  bModificarLista = (PrecioLista = PrecioUnitario)
  
  dblPrecio = Cantidad * PrecioUnitario
  dblPrecio = dblPrecio * (1# + PorcentajeImpuesto / 100#)
  dblPrecio = Int(dblPrecio / vmFactor + 0.51) * vmFactor
  dblPrecio = dblPrecio / (1# + PorcentajeImpuesto / 100#)
  PrecioUnitario = dblPrecio / Cantidad
  
  If (bModificarLista) Then
    PrecioLista = PrecioUnitario
  End If
  
  PrecioTotal = dblPrecio
End Function

Public Function ValorImpuesto() As Currency
    
    ValorImpuesto = PrecioTotal / 100@ * PorcentajeImpuesto

End Function

Public Function Descripcion() As String
Dim pItem As clsItemVenta, stRet As String
    Set pItem = New clsItemVenta
    If pItem.Load(Me.CodigoItem) Then
        stRet = pItem.Descripcion
    Else
        stRet = "NO LOCALIZADO!!"
    End If
    Set pItem = Nothing
    
    Descripcion = stRet
End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim pItem As clsItemVenta, vM1 As Currency, VM2 As Currency

    Select Case Trim(UCase(sVarId))
    
    Case "CODIGO"
        vRetBuffer = CodigoItem
        sRetString = CodigoItem
    
    Case "CANTIDAD"
        vRetBuffer = Cantidad
        sRetString = Format(Cantidad, Empresa.MascaraCantidades)

    Case "DESCRIPCION"
        vRetBuffer = Me.Descripcion
        sRetString = vRetBuffer

    Case "ITEM", "RENGLON"
        vRetBuffer = NumeroRenglon
        sRetString = Str(NumeroRenglon)

    Case "IVAP", "PORCENTAJEIMPUESTO"
        vRetBuffer = PorcentajeImpuesto
        sRetString = Format(vRetBuffer, "#0.00")

    Case "TOTAL_RENGLON", "TOTALRENGLON", "TOTAL_LINEA", "TOTALLINEA"
        vRetBuffer = Me.PrecioTotal
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)

    Case "PRECIO_VENTA", "PRECIO_UNITARIO", "PRECIOUNITARIO", "PRECIO"
        vRetBuffer = Me.PrecioUnitario
        sRetString = Format(vRetBuffer, Empresa.MascaraPrecios)

    Case "PRECIO_CON_IVA", "PRECIOCONIVA"
        vRetBuffer = Me.PrecioUnitarioConIVA
        sRetString = Format(vRetBuffer, Empresa.MascaraPrecios)
    
    Case "TOTALCONIVA"
        vRetBuffer = Me.PrecioTotalConIVA
        sRetString = Format(vRetBuffer, Empresa.MascaraPrecios)
        
    Case "TIPOIMPUESTO", "TIPO_IMPUESTO", "CODIGO_IMPUESTO"
        Set pItem = Me.ItemVenta
        If pItem Is Nothing Then
            vRetBuffer = "??"
            sRetString = vRetBuffer
            Set pItem = Nothing
        Else
            vRetBuffer = pItem.TipoImpuesto1
            sRetString = vRetBuffer
        End If

    Case "CODIGOIMPUESTO"
        LoadPorcentajeImpuesto
        If Me.PorcentajeImpuesto = 0 Then
            sRetString = "EX"
        Else
            sRetString = "VG"
        End If
        vRetBuffer = sRetString
    
    Case "VALORIMPUESTO"
        LoadPorcentajeImpuesto
        vRetBuffer = Me.ValorImpuesto
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)
        
    Case "PRECIOLISTA", "PRECIO_LISTA"
        Set pItem = Me.ItemVenta
        If pItem Is Nothing Then
            vRetBuffer = Me.PrecioUnitario
        Else
            vRetBuffer = pItem.Precio(nPrecioStandard)
            Set pItem = Nothing
        End If
        sRetString = Format(vRetBuffer, Empresa.MascaraPrecios)

    Case "TOTALLISTA", "TOTPLISTA", "TOTALPRECIOLISTA"
        Set pItem = Me.ItemVenta
        If pItem Is Nothing Then
            vRetBuffer = Me.PrecioTotal
        Else
            vRetBuffer = pItem.PrecioNeto(1) * Me.Cantidad
            Set pItem = Nothing
        End If
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)

    Case "DESCUENTOUNITARIO"
        Set pItem = Me.ItemVenta
        If pItem Is Nothing Then
            vM1 = Me.PrecioUnitario
        Else
            vM1 = pItem.PrecioNeto(1)
            Set pItem = Nothing
        End If
        vRetBuffer = vM1 - Me.PrecioUnitario
        sRetString = Format(vRetBuffer, Empresa.MascaraPrecios)
        
    Case "DESCUENTORENGLON"
        Set pItem = Me.ItemVenta
        If pItem Is Nothing Then
            vM1 = Me.PrecioTotal
        Else
            vM1 = pItem.PrecioNeto(1) * Me.Cantidad
            Set pItem = Nothing
        End If
        vRetBuffer = vM1 - Me.PrecioUnitario
        sRetString = Format(vRetBuffer, Empresa.MascaraPrecios)

    Case "DESCUENTO", "PDESC", "PORCENTAJEDESCUENTO", "P_DESC", "PORCENTAJE_DESCUENTO"
        Set pItem = Me.ItemVenta
        If pItem Is Nothing Then
            vM1 = Me.PrecioUnitario
        Else
            vM1 = pItem.PrecioNeto(1)
            Set pItem = Nothing
        End If

        VM2 = vM1 - PrecioUnitario
        VM2 = vM1 / VM2 * 100
        
        vRetBuffer = VM2
        sRetString = Format(VM2, "#0.00")
        
    Case Else
    
        EvalVar = False
        Exit Function

    End Select
    
    EvalVar = True

End Function
