VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRenglonFactPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public IDMaquina As Long
Public NumeroTicket As Long
Public NumeroLinea As Integer
Public Producto As String
Public Cantidad As Double
Public PrecioUnitario As Currency
Public PorcentajeImpuesto As Double

Public Sub LoadInstance(rs As Recordset, Optional pDest As clsRenglonFactPOS = Nothing)

    With rs
    Me.IDMaquina = GetNumeroFromVariant(rs.Fields("IdMaquina"))
    Me.NumeroTicket = GetNumeroFromVariant(rs.Fields("NumeroTicket"))
    Me.NumeroLinea = GetNumeroFromVariant(rs.Fields("NumeroLinea"))
    Me.Producto = stGetStringFromVariant(rs.Fields("Producto"))
    Me.Cantidad = GetNumeroFromVariant(rs.Fields("Cantidad"))
    Me.PrecioUnitario = GetNumeroFromVariant(rs.Fields("PrecioUnitario"))
    Me.PorcentajeImpuesto = GetNumeroFromVariant(rs.Fields("PorcentajeImpuesto"))
    End With

End Sub

Public Function ItemVenta() As clsItemVenta
Dim pItemVenta As clsItemVenta

    Set pItemVenta = New clsItemVenta
    If Not pItemVenta.Load(Me.Producto) Then
        Set pItemVenta = Nothing
    End If
    
    Set ItemVenta = pItemVenta

End Function

Public Function PrecioLista() As Currency
Dim pItem As clsItemVenta

    Set pItem = Me.ItemVenta
    If pItem Is Nothing Then
        PrecioLista = Me.PrecioUnitario
    Else
        PrecioLista = pItem.PrecioNeto(1)
        Set pItem = Nothing
    End If

End Function

Public Sub LoadPorcentajeImpuesto()
Dim pItem As clsItemVenta

    Set pItem = ItemVenta
    If pItem Is Nothing Then
        PorcentajeImpuesto = 0
    Else
        PorcentajeImpuesto = TiposImpuesto.ValorActualImpuesto(pItem.TipoImpuesto1)
    End If
    Set pItem = Nothing

End Sub

Public Function PrecioTotal() As Currency
Dim dblPrecio As Double

  On Error GoTo ErrHandler
  
  If Cantidad = 0 Then
    PrecioTotal = 0
    Exit Function
  End If

  dblPrecio = Cantidad * PrecioUnitario
  dblPrecio = dblPrecio * (1# + PorcentajeImpuesto / 100#)
  dblPrecio = Int(dblPrecio / 5# + 0.51) * 5#
  dblPrecio = dblPrecio / (1# + PorcentajeImpuesto / 100#)
  PrecioUnitario = dblPrecio / Cantidad
  PrecioTotal = dblPrecio
  
  Exit Function

ErrHandler:

  Err.Clear
  mAdvertencia "ERROR: Detalle Invlido." & vbCrLf & _
               "Producto: " & Me.Producto & vbCrLf & _
               "Descripcion: " & Me.Descripcion & vbCrLf & _
               "Precio Unit: " & Format(Me.PrecioUnitario, Empresa.MascaraPrecios) & vbCrLf & _
               "Cantidad: " & Format(Me.Cantidad, Empresa.MascaraCantidades)
  PrecioTotal = 0

End Function

Public Function ValorImpuesto() As Currency
    
    ValorImpuesto = PrecioTotal / 100@ * PorcentajeImpuesto

End Function

Public Function Descripcion() As String
Dim pItem As clsItemVenta, stRet As String
    Set pItem = New clsItemVenta
    If pItem.Load(Me.Producto) Then
        stRet = pItem.Descripcion
    Else
        stRet = "NO LOCALIZADO!!"
    End If
    Set pItem = Nothing
    
    Descripcion = stRet
End Function

Public Sub Ajustar(ovmReal As Currency, ovmAjustado As Currency, ovmIVAOriginal As Currency, ovmIVATrampeado As Currency, idblFactor As Double)
' idblFactor es el Factor de Reduccin deseado (/100)
Dim dblFactor As Double         ' Factor acumulado
Dim pItemVenta As clsItemVenta
Dim dblAplicar As Double        ' Reduccin a aplicar
Dim isPorPeso As Boolean, isGenerico As Boolean

    If ovmReal = 0 Then
        dblFactor = 0 '
    Else
        dblFactor = (ovmReal - ovmAjustado) / ovmReal
    End If

    dblAplicar = 1 - idblFactor / 100

    Set pItemVenta = Me.ItemVenta
    isPorPeso = StrComp(left(pItemVenta.Unidad, 2), "KG", vbTextCompare) = 0
    Set pItemVenta = Nothing

' Incondicional:
    ovmReal = ovmReal + Me.PrecioTotal
    ovmIVAOriginal = ovmIVAOriginal + Me.PrecioTotal * Me.PorcentajeImpuesto / 100#

' Descartar

    If isPorPeso And Me.Cantidad < 0.1 Then
        ovmAjustado = ovmAjustado + Me.PrecioTotal
        ovmIVATrampeado = ovmIVATrampeado + Me.PrecioTotal * Me.PorcentajeImpuesto / 100
        Exit Sub        ' No se hace nada
    End If

    isGenerico = False
    
    If Not isPorPeso And Me.Cantidad = 1 Then
        isGenerico = (InStr(1, "VARIOS|CHARCUTERIA|PANADERIA|PASTELERIA|LUNCHERIA", Me.Producto, vbTextCompare) = 0)
        If (Not isGenerico) Or Me.PrecioTotal < 100# Then
            ovmAjustado = ovmAjustado + Me.PrecioTotal
            ovmIVATrampeado = ovmIVATrampeado + Me.PrecioTotal * Me.PorcentajeImpuesto / 100
            Exit Sub        ' No se hace nada
        End If
    End If

    If dblAplicar < dblFactor Then ' Estamos excedidos en el margen de evasin...
        ovmAjustado = ovmAjustado + Me.PrecioTotal
        ovmIVATrampeado = ovmIVATrampeado + Me.PrecioTotal * Me.PorcentajeImpuesto / 100
        Exit Sub        ' No se hace nada
    End If

' Redondear hacia abajo (incondicional)

    If isPorPeso Then
        Me.Cantidad = Me.Cantidad * dblAplicar
        If Me.Cantidad < 0.1 Then
            Me.Cantidad = Me.Cantidad / dblAplicar
            ovmAjustado = ovmAjustado + Me.PrecioTotal
            ovmIVATrampeado = ovmIVATrampeado + Me.PrecioTotal * Me.PorcentajeImpuesto / 100
            dbHandle.Execute "UPDATE RenglonesFacturaPOS SET Cantidad = " & NumeroDB(Me.Cantidad) & ", PrecioUnitario = " & NumeroDB(Me.PrecioUnitario) & " WHERE idMaquina = " & NumeroDB(Me.IDMaquina) & " AND numeroTicket = " & Me.NumeroTicket & " AND numeroLinea = " & NumeroDB(Me.NumeroLinea)
            Exit Sub
        End If
    ElseIf isGenerico Then
        If Me.PrecioUnitario = 1# Then  ' Mansin: Comanderas
            Me.Cantidad = Int(Me.Cantidad * dblAplicar)
            If Me.Cantidad < 1 Then
                Me.Cantidad = 1
            End If
        Else
            Me.PrecioUnitario = Int(Me.PrecioUnitario * dblAplicar / 5) * 5
        End If
    Else    ' If Not isGenerico and Not isPorPeso
        If Me.Cantidad > 1 Then
            Me.Cantidad = Int(Me.Cantidad * dblAplicar)
            If Me.Cantidad = 0 Then Me.Cantidad = 1
        End If
    End If

    ovmAjustado = ovmAjustado + Me.PrecioTotal
    ovmIVATrampeado = ovmIVATrampeado + Me.PrecioTotal * Me.PorcentajeImpuesto / 100
    dbHandle.Execute "UPDATE RenglonesFacturaPOS SET Cantidad = " & NumeroDB(Me.Cantidad) & ", PrecioUnitario = " & NumeroDB(Me.PrecioUnitario) & " WHERE idMaquina = " & NumeroDB(Me.IDMaquina) & " AND numeroTicket = " & Me.NumeroTicket & " AND numeroLinea = " & NumeroDB(Me.NumeroLinea)

End Sub

