VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRenglonConsumo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public CodigoItem As String
Public PrecioUnitario As Currency
Public Cantidad As Double
Public Descripcion As String
Public Extras As Collection ' of clsExtra
Public Removibles As Collection

'Original
'Public CodigoItem As String
'Public PrecioUnitario As Currency
'Public Cantidad As Double
'Public Descripcion As String
'Public Componentes As Collection ' of clsComponenteRenglon
'Public Extras As Collection ' of clsExtra

' Estructura {
'   CodigoItem
'   PrecioUnitario
'   Cantidad
'   Componentes {
'       Codigo
'       Cantidad
'       Extras {
'           Codigo
'           Precio
'           Cantidad
'       }
'       Remover {
'           Codigo
'       }
'   }
'   Extras {
'       Codigo
'       Precio
'       Cantidad
'   }
'   Remover {
'       Codigo
'   }
' }

'Public Event ItemDefined()
Public bDefiniendo As Boolean

Public Event ItemDefined()
Private WithEvents frmDefinicion As frmDefinirConsumo
Attribute frmDefinicion.VB_VarHelpID = -1
Private WithEvents frmDefinicion2 As frmDefinirComentariosConsumo
Attribute frmDefinicion2.VB_VarHelpID = -1

Public Sub SetModoDefinicion(istrItem As String)
Dim pItem As clsItemVenta

    bDefiniendo = True
    CodigoItem = istrItem
    Set pItem = AlmacenItemsVenta.ItemVenta(istrItem)
    If (pItem Is Nothing) Then
        Err.Raise 10000, "clsRenglonConsumo::SetModoDefinicion", "Cdigo Invlido: " & istrItem
        Exit Sub
    End If
    PrecioUnitario = pItem.Precio(nPrecioStandard)
    Cantidad = 1
    Set Removibles = New Collection
    Set Extras = New Collection
    Me.Descripcion = pItem.Descripcion

    If pItem.TieneAtributo("COMBO") Or pItem.TieneAtributo("EXTRA") Or pItem.TieneAtributo("SIN") Then  ' Items "Extensibles"
      Set frmDefinicion = New frmDefinirConsumo
      frmDefinicion.SetRenglon Me
      While frmDefinicion.Visible: DoEvents: Wend
      Unload frmDefinicion
      Set frmDefinicion = Nothing
      Exit Sub
    ElseIf pItem.TieneAtributo("USACOMENT") Then   ' Items "comentables"
      Set frmDefinicion2 = New frmDefinirComentariosConsumo
      frmDefinicion2.SetRenglon Me
      While frmDefinicion2.Visible: DoEvents: Wend
      Unload frmDefinicion2
      Set frmDefinicion2 = Nothing
      Exit Sub
    Else
      If mScriptExecute.ExisteProcedimiento(pScriptPOS, "CalcularPrecio") Then
        pScriptPOS.ExecuteStatement "Codigo = """ & istrItem & """"
        pScriptPOS.ExecuteStatement "Cantidad = " & Cantidad
        pScriptPOS.ExecuteStatement "Precio = " & Trim(Str(PrecioUnitario))
        pScriptPOS.ExecuteStatement "TipoImpuesto = """ & pItem.TipoImpuesto1 & """"
        PrecioUnitario = pScriptPOS.Eval("CalcularPrecio")
      End If
    End If

    RaiseEvent ItemDefined
    bDefiniendo = False
End Sub

Private Sub frmDefinicion_RenglonDefinido()
  RaiseEvent ItemDefined
End Sub

Private Sub frmDefinicion2_RenglonDefinido()
  RaiseEvent ItemDefined
End Sub

' Salva un renglon de consumo:
' idOwner: Identificacin del propietario (cuenta o sesion)
' nRenglon: Identificacin del numero del renglon de cuenta asociado
' nTipo: True: Sesion
'        False: CuentaPOS
Public Sub SaveDescripcion(idOwner As Long, nRenglon As Long) ' Como extensin de renglon cuenta
Dim sQuery As String, iNextDet As Integer

  sQuery = "INSERT INTO RenglonesConsumoSesion (OwnerID, Renglon, Descripcion) SELECT "
  sQuery = sQuery & NumeroDB(idOwner) & ", "
  sQuery = sQuery & NumeroDB(nRenglon) & ", "
  sQuery = sQuery & StringDB(Me.Descripcion) & ";"
  dbHandle.Execute sQuery
  iNextDet = 1

End Sub

Public Function LoadDescripcion(idOwner As Long, nRenglon As Long) As Boolean
Dim sQuery As String, rs As Recordset, bRetVal As Boolean

  sQuery = "SELECT Descripcion FROM RenglonesConsumoSesion "
  sQuery = sQuery & "WHERE OwnerID = " & NumeroDB(idOwner) & " "
  sQuery = sQuery & "AND Renglon = " & NumeroDB(nRenglon) & ";"
  
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    Me.Descripcion = ""
    bRetVal = False
  Else
    Me.Descripcion = GetStringFromVariant(rs!Descripcion)
    bRetVal = True
  End If
  rs.Close
  Set rs = Nothing
  
  LoadDescripcion = bRetVal

End Function

Public Sub EliminarRenglonesSesion(idOwner As Long)
  dbHandle.Execute "DELETE FROM RenglonesConsumoSesion WHERE OwnerID = " & NumeroDB(idOwner)
End Sub

