VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsReciboMercancia"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Numero As Long
Public FechaRegistro As Date
Public FechaTransaccion As Date
Public Operador As String
Public CodigoProveedor As String
Public RefProveedor As String
Public NombreProveedor As String
Public CostoMercancia As Currency
Public Descuento1 As Double
Public Descuento2 As Double
Public Impuesto1 As Currency
Public Impuesto2 As Currency
Public Almacen As String
Public EstadoRecepcion As StatDespacho
Public EstadoAdministrativo As StatAdmin
Public Condicion As String
Public Notas As String
Public Saldo As Currency
Public NumeroControl As Long
Private inProcess As Boolean
Private RecargoDirecto As Currency

Public bExcluirVarios As Boolean       ' Definida en el Entorno (Registry)

Public NextDetalle As Integer, lDoAdmin As Boolean
Public instComprobante As clsBufferComprobante  ' Definir Privada ms adelante.
Private AlmacenCotizaciones As clsAlmacenCotsPP

Public MontoRecargo As Currency, CuentaRecargo As String

Private pEvaluadorVariables As CExpEvalDocCompra

' **********************************************
' Funciones y mtodos y miembros Standard ISDOC:
' **********************************************
Public TipoEntidad As String            ' ISDOC

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Function Descripcion() As String
    Descripcion = NombreProveedor
End Function

Public Function Load(Numero As Long) As Boolean
Dim bRetVal As Boolean
Dim pDetalle As clsDetallesCompra

    bRetVal = AlmacenCompras.Load(Me, Numero)
    If bRetVal Then
      MontoRecargo = 0
      For Each pDetalle In Detalles
        If left(pDetalle.CodigoItem, 1) = "@" Then
          MontoRecargo = MontoRecargo + pDetalle.PrecioEfectivo * pDetalle.CantidadFacturada
        End If
      Next
    End If
    Load = bRetVal

End Function

Public Function Referencia() As String  ' Forma parte de la ISDOC
    Referencia = CodigoProveedor & "-" & RefProveedor
End Function

Public Function Concepto() As String
    Concepto = "Factura de compra " & Me.RefProveedor
End Function

Public Function NombreArchivoFormato() As String
  NombreArchivoFormato = DeterminarFormato("FormatoCompra", "FormatosCompra", BuildDataPath("FormatoCompra.txt", AppName), Me)
End Function

Public Function Detalles() As Collection
Dim colRetVal As Collection
    
    Set colRetVal = New Collection
    mMain.AlmacenDetallesCompra.FillCollection Me.Numero, colRetVal
    Set Detalles = colRetVal

End Function

Public Function ValorImpuesto(CodigoImpuesto) As Currency
Dim det As clsDetallesCompra
Dim retVal As Currency, tasa As Double
  retVal = 0: tasa = TiposImpuesto.ValorActualImpuesto(CStr(CodigoImpuesto))
  For Each det In Detalles
    Dim Item As clsItemInventario
    Set Item = AlmacenItemsInventario.itemInventario(det.CodigoItem)
    If Not Item Is Nothing Then
      If Item.claseImpuesto1 = CodigoImpuesto Then
        retVal = retVal + det.PrecioEfectivo * det.CantidadFacturada * tasa / 100
      End If
    End If
  Next
  ValorImpuesto = retVal
End Function

Public Function BaseGravable(CodigoImpuesto) As Currency
Dim det As clsDetallesCompra
Dim retVal As Currency, tasa As Double
  retVal = 0: tasa = TiposImpuesto.ValorActualImpuesto(CStr(CodigoImpuesto))
  For Each det In Detalles
    Dim Item As clsItemInventario
    Set Item = AlmacenItemsInventario.itemInventario(det.CodigoItem)
    If Not Item Is Nothing Then
      If Item.claseImpuesto1 = CodigoImpuesto Then
        retVal = retVal + det.PrecioEfectivo * det.CantidadFacturada
      End If
    End If
  Next
  BaseGravable = retVal
End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evCompra.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, v, s)
Dim localV As Variant, localStr As String, bRetVal As Boolean
    
    bRetVal = pEvaluadorVariables.EvalVar(sVarId, localV, localStr, Me)
    
    If Not bRetVal Then
        bRetVal = ExtendEval(sVarId, localV, localStr)
    End If

    If bRetVal Then
        v = localV
        s = localStr
    End If
    
    EvalVar = bRetVal
End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String
    bRetVal = EvalVar(sVarId, vBuf, sBuf)
    GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)
End Function

Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim sProveedor As String, sRefProv As String, posSep As Integer, bRetVal As Boolean
Dim pDetalle As clsDetallesCompra
    
    posSep = InStr(1, sRef, "-")
    If posSep = 0 Then
        LoadByReferenciaISDOC = False
        Exit Function
    End If
    sProveedor = left(sRef, posSep - 1)
    sRefProv = right(sRef, Len(sRef) - posSep)
    bRetVal = LoadByReferencia(sProveedor, sRefProv)
    If bRetVal Then
      MontoRecargo = 0
      For Each pDetalle In Detalles
        If left(pDetalle.CodigoItem, 1) = "@" Then
          MontoRecargo = MontoRecargo + pDetalle.PrecioEfectivo * pDetalle.CantidadFacturada
        End If
      Next
    End If
    LoadByReferenciaISDOC = bRetVal
End Function

Public Sub Show()
Dim f As frmViewRecibo

    Set f = New frmViewRecibo
    f.SetRecibo Me
    
    ShowNonModal f
    
    Unload f
    Set f = Nothing

End Sub

Public Sub ViewPrint(AutoPrint As Boolean)

  If Dir(Me.NombreArchivoFormato) <> "" Then
    Me.ShowFormato (False)
    Exit Sub
  End If

  Me.Load Me.Numero
  Dim Informe As New CInformeReciboMercancia
  Informe.SetRecibo Me
  
End Sub

Public Sub ShowFormato(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
    
    Set cFormato = New CFormatoDocumento
    cFormato.SetDocumento Me, Not AutoPrint
    Set cFormato = Nothing

End Sub

' **************************************************************
' ************ END ISDOC
' **************************************************************

Private Sub Class_Initialize()
    TipoEntidad = "RCM"
    inProcess = False
    bExcluirVarios = Not CBool(Val(GetSetting(AppName, "General", "AplicarDescuentoExtras", "-1")))
    Set pEvaluadorVariables = New CExpEvalDocCompra
End Sub

Public Sub Blank(FechaTrans As Date)
    Numero = 0
    FechaRegistro = Date
    FechaTransaccion = FechaTrans
    Operador = UsuarioActivo.Codigo
    CodigoProveedor = ""
    RefProveedor = ""
    NombreProveedor = ""
    CostoMercancia = 0
    Descuento1 = 0
    Descuento2 = 0
    Impuesto1 = 0
    Impuesto2 = 0
    Almacen = ""
    EstadoRecepcion = SD_FACTURA_ABIERTA
    EstadoAdministrativo = SA_FACTURA_ABIERTA
    Condicion = ""
    Notas = ""
    Saldo = 0@
End Sub

Public Function AnotarItemDevuelto(lngRenglon As Long, dblCantidad As Double) As Boolean
Dim sqlQuery As String, isOk As Boolean, rs As Recordset, dDevueltas As Double

    isOk = True
    sqlQuery = "UPDATE DetallesCompra SET Devueltas = Devueltas +" & NumeroDB(dblCantidad) & " WHERE NumeroDocumento=" & NumeroDB(Me.Numero) & " AND Renglon = " & NumeroDB(lngRenglon)
    dbHandle.Execute sqlQuery

    AnotarItemDevuelto = isOk
    Exit Function

End Function

Public Function LoadByReferencia(Proveedor As String, RefProv As String) As Boolean
Dim bRetVal As Boolean
Dim pDetalle As clsDetallesCompra

  bRetVal = AlmacenCompras.LoadByReferencia(Me, Proveedor, RefProv)

  If bRetVal Then
    MontoRecargo = 0
    For Each pDetalle In Detalles
      If left(pDetalle.CodigoItem, 1) = "@" Then
        MontoRecargo = MontoRecargo + pDetalle.PrecioEfectivo * pDetalle.CantidadFacturada
      End If
    Next
  End If

  LoadByReferencia = bRetVal
End Function

Public Function isNew() As Boolean
    isNew = Not AlmacenCompras.Load(Nothing, Me.Numero)
End Function

' Soporte para los servicios de usuario.
' Reglas de negocio
Public Function ErrorValidacion() As Boolean
  If Me.CodigoProveedor = "" Then
    mAdvertencia "Debe llenar el cdigo del proveedor"
    ErrorValidacion = 1
    Exit Function
  End If
  
  If Me.RefProveedor = "" Then
    mAdvertencia "Debe llenar la referencia del proveedor"
    ErrorValidacion = 2
    Exit Function
  End If
  
  If Me.NombreProveedor = "" Then
    mAdvertencia "Debe llenar el nombre del proveedor"
    ErrorValidacion = 3
    Exit Function
  End If
  
  If Not Condiciones.ValidarCondicion(Me.Condicion) Then
    mAdvertencia "ERROR: Condicion invlida (" & Me.Condicion & ")"
    ErrorValidacion = 4
    Exit Function
  End If

  If Not Almacenes.ValidarAlmacen(Me.Almacen) Then
    mAdvertencia "ERROR: Almacen invalido"
    ErrorValidacion = 5
    Exit Function
  End If

  ErrorValidacion = 0
End Function

' Determin la consistencia del tipo de proceso definido para la operacion
Public Function SupervisarConsistenciaOperacion(bDoAdmin As Boolean, nStatDespacho As StatDespacho) As Boolean
    
  If bDoAdmin And nStatDespacho <> SD_FACTURA_ENTREGADA Then ' No coformidad con regla 1
    mAdvertencia "Esta versin no permite separar la recepcin del proceso administrativo"
    SupervisarConsistenciaOperacion = False
    Exit Function
  End If
  
  If nStatDespacho = SD_FACTURA_ENTREGADA And Not bDoAdmin Then ' No conformidad con la regla 2
     mAdvertencia "Esta versin no permite separar la recepcin del proceso administrativo"
     SupervisarConsistenciaOperacion = False
     Exit Function
  End If
  
  SupervisarConsistenciaOperacion = True
End Function

' --------------------------------------------------------
' PROCESO: Servicios locales: Interfaz con otras entidades
' --------------------------------------------------------
Private Function CargarMercancia(f As lfProgresoOperacion) As Boolean
Dim instAlmacen As clsAlmacen, col As Collection
Dim instItemInv As clsItemInventario
Dim instDetCompra As clsDetallesCompra
Dim isOk As Boolean, stCuenta As String

  Set instAlmacen = Almacenes.Item(Me.Almacen)
  If instAlmacen Is Nothing Then
    Err.Raise 10010, "CargarMercancia", "Almacen Invalido"
  End If

  isOk = instAlmacen.StartComprobante(Me.FechaTransaccion, Me.TipoEntidad, Me.Numero, 0, "Recepcin de la compra " & Me.Referencia)
  If isOk Then

    If Not f Is Nothing Then
      f.Caption = "Actualizando el inventario"
      f.ProgressBar1.value = 0
    End If
    Set instItemInv = New clsItemInventario
    Set col = Me.Detalles

    For Each instDetCompra In col
      If Not f Is Nothing Then f.NextPoint
      With instDetCompra
      If .CodigoItem <> "" And left(.CodigoItem, 1) <> "@" Then
        If Not instItemInv.Load(.CodigoItem) Then
          If Not f Is Nothing Then f.ShowException "ERROR: Desapareci el artculo con cdigo " & .CodigoItem, True
        Else
          isOk = instAlmacen.RegistrarMINV(.CodigoItem, .CantidadTotal, .CostoUnitario)
          If isOk Then isOk = instItemInv.RegistrarCompra(Me.CodigoProveedor, Me.FechaTransaccion, .CostoUnitario, .CantidadTotal, Empresa.indexarPrecios <> 0)
        End If
        isOk = Not f.doBreak
        If Not isOk Then Exit For
      End If
      End With
    Next

    Set instItemInv = Nothing
    Set col = Nothing
  End If

  If isOk Then
    isOk = instAlmacen.CerrarComprobante(instComprobante)
  End If

  Set instAlmacen = Nothing
  
  If MontoRecargo > 0 Then
    instComprobante.AddDetalle CuentaRecargo, "Recargo a los costos. " & Me.Referencia, 0, MontoRecargo
  End If

End Function

Private Function ProcesarEfectosAdministrativos(f As lfProgresoOperacion, DocFis As CDocumentoFiscal) As Boolean
Dim instProveedor As clsProveedores, _
    instDocumento As clsDocumentosISPC, _
    instDetalle As clsDetalleCuentaEntidad, _
    instCondicion As clsCondicion
Dim Valor As Currency, Cuenta As String

  f.Caption = "Proceso administrativo de la factura"
  f.ProgressBar1.value = 0
  f.lblPercent.Caption = "0%"
  
  Set instProveedor = New clsProveedores
  If Not instProveedor.Load(Me.CodigoProveedor) Then
    ReportarError False, ERR_ITEM_NOT_FOUND, "Proveedor no localizado: " & Me.CodigoProveedor, "ReciboMercancia.ProcesarEfectosAdministrativos"
    ProcesarEfectosAdministrativos = False
    Set instProveedor = Nothing
    Exit Function
  End If

' 2.- Registro contable del Impuesto
  
'   instComprobante.AddDetalle Empresa.CuentaImpuesto1, "Impuesto pagado en Factura " & Me.Referencia, Me.Impuesto1, 0#
' (DELEGADO AL DOCUMENTO FISCAL)
'   instComprobante.AddDetalle Empresa.CuentaImpuesto2, "Impuesto pagado en Factura " & Me.Referencia, Me.Impuesto2, 0#
  
' 4.- Actualizacion de la cuenta del Cliente (a travs de un documento ISPC)
  
  If Me.Condicion = "CONTADO" Then
    Me.EstadoAdministrativo = SA_FACTURA_CANCELADA
    Me.Saldo = 0
  Else
    Set instDocumento = New clsDocumentosISPC
    instDocumento.CreateNewDoc instProveedor.TipoEntidad, Me.CodigoProveedor, Me.Numero, Me.TipoEntidad, Me.FechaTransaccion, -(Me.CostoMercancia + Me.Impuesto1 + Me.Impuesto2 + RecargoDirecto), "Factura " & Me.Referencia, instComprobante
    instDocumento.AplicarCondicion Me.Condicion
    If Not DocFis Is Nothing Then
      If DocFis.Retencion <> 0 Then
        Dim Detalle As New clsDetalleCuentaEntidad
        Detalle.Add instDocumento.Numero, instDocumento.CodigoEntidad, instDocumento.TipoEntidad, Me.FechaTransaccion, "IVA Retenido en factura " & Me.RefProveedor, Abs(DocFis.Retencion), instComprobante
      End If
    End If
    Set instDocumento = Nothing
    Me.EstadoAdministrativo = SA_FACTURA_PENDIENTE
    Me.Saldo = Me.CostoMercancia + Me.Impuesto1 + RecargoDirecto ' + Me.Impuesto2
  End If

  If Not DocFis Is Nothing Then
    DocFis.FillComprobante Empresa, instComprobante
    DocFis.NombreEntidad = Me.NombreProveedor
    DocFis.NumeroDoc = Me.Numero
    DocFis.Grabar New CFactoria
  End If
  Set instProveedor = Nothing
  
  ProcesarEfectosAdministrativos = True

End Function

' ---------- PROCESO: Interfaz con la aplicacin: ------------

Public Sub StartProcess(ByVal TipoProceso As Integer, doAdmin As Boolean, Almacen As String, vmRecargo As Currency, stCuentaRecargo As String, vmRecargoDirecto As Currency)
Dim bProcessStarted As Boolean, lOrgNumero As Long
Dim lProveedor As clsProveedores

'    While inProcess: DoEvents: Wend
  inProcess = True
  
  MontoRecargo = vmRecargo
  RecargoDirecto = vmRecargoDirecto
  CuentaRecargo = stCuentaRecargo

  Set lProveedor = New clsProveedores
  If Not lProveedor.Load(Me.CodigoProveedor) Then
    Err.Raise 10010, "StartProcess", "Proveedor " & Me.CodigoProveedor & " no registrado"
  End If

  lOrgNumero = Me.Numero

  Me.EstadoRecepcion = TipoProceso
  Me.FechaRegistro = Date
  Me.Operador = UsuarioActivo.Codigo
  Me.Saldo = 0#
  Me.EstadoAdministrativo = doAdmin
  Me.Almacen = Almacen
  Me.Impuesto2 = 0

  lDoAdmin = doAdmin


  AlmacenCompras.StartProcess Me

  If lOrgNumero Then  ' Resetear cualquier efecto anterior de la factura...
    AlmacenDetallesCompra.KillDetalles lOrgNumero
  End If
  NextDetalle = 1
  Set AlmacenCotizaciones = New clsAlmacenCotsPP
  Set instComprobante = New clsBufferComprobante
  instComprobante.StartComprobante Me.FechaTransaccion, Me.TipoEntidad & Me.Referencia, Me.NombreProveedor

End Sub

Public Sub AddDetalle(istCodigoItem As String, _
                istDescripcion As String, _
                istUnidad As String, _
                ByVal idblCantidadFacturada As Double, _
                ByVal idblCantidadPromocion As Double, _
                ByVal ivmPrecio As Currency, _
                fProgress As lfProgresoOperacion)
Dim instDetalle As clsDetallesCompra, instItemInv As clsItemInventario
Dim dFactorDescuento As Double, FactorRecargo As Double
'Dim pSerial As clsSeriales, sVar As Variant

  If CostoMercancia > 0 Then
    FactorRecargo = (CostoMercancia + MontoRecargo + RecargoDirecto) / CostoMercancia
  Else
    FactorRecargo = 1
  End If
  
  If istCodigoItem <> "" Then
    Set instItemInv = New clsItemInventario
    If Not instItemInv.Load(istCodigoItem) Then
      If Not fProgress Is Nothing Then
        fProgress.ShowException "No encontr el articulo " & istCodigoItem, True
      End If
      Err.Raise 10012, "AddDetalle", "Articulo " & istCodigoItem & " no registrado"
    End If
  End If

  Set instDetalle = New clsDetallesCompra
  
  With instDetalle
  .NumeroDocumento = Me.Numero
  .Renglon = NextDetalle: NextDetalle = NextDetalle + 1
  .CodigoItem = istCodigoItem
  .Descripcion = istDescripcion
  If istCodigoItem <> "" Then
    .Presentacion = istUnidad
    .FactorEmpaque = instItemInv.FactorPresentacion(istUnidad)
    .CantidadFacturada = idblCantidadFacturada
    .CantidadPromocion = idblCantidadPromocion
    .PrecioNominal = ivmPrecio
    If left(istCodigoItem, 1) <> "@" Or Not bExcluirVarios Then
      .PrecioEfectivo = ivmPrecio * (1# - ValorDescuentosSucesivos(Me.Descuento1, Me.Descuento2) / 100#)
    Else
      .PrecioEfectivo = ivmPrecio
    End If
  '       CostoMercancia = CostoMercancia + .PrecioEfectivo * idblCantidadFacturada
  
    .Impuesto1 = idblCantidadFacturada * .PrecioEfectivo * TiposImpuesto.ValorActualImpuesto(instItemInv.TipoImpuesto(1)) / 100#
    .Impuesto2 = 0 ' .CantidadFacturada * .PrecioEfectivo * TiposImpuesto.ValorActualImpuesto(instItemInv.TipoImpuesto2) / 100#
    .PrecioEfectivo = .PrecioEfectivo * .CantidadFacturada / (idblCantidadFacturada + idblCantidadPromocion)
    
    If left(istCodigoItem, 1) <> "@" Then
      .CostoUnitario = .PrecioEfectivo / .FactorEmpaque * FactorRecargo
      AlmacenCotizaciones.RegistrarCompra Me.CodigoProveedor, .CodigoItem, Me.FechaTransaccion, .CostoUnitario
    Else
      .CostoUnitario = 0
    End If
  End If
  End With
  
  AlmacenDetallesCompra.Add instDetalle
  If Not fProgress Is Nothing Then fProgress.NextPoint

End Sub

Public Sub EndProcess(doPrint As Boolean, fProgress As lfProgresoOperacion, DocFis As CDocumentoFiscal)
    
  Set AlmacenCotizaciones = Nothing

  If Me.EstadoRecepcion = SD_FACTURA_ENTREGADA Then
    CargarMercancia fProgress
  End If

  If lDoAdmin Then
    If Not ProcesarEfectosAdministrativos(fProgress, DocFis) Then
      AbortProcess
      Exit Sub
    End If
  End If
  
  instComprobante.Procesar
  
  Set instComprobante = Nothing
  Set AlmacenCotizaciones = Nothing
  SubmitDoc Me
  inProcess = False

End Sub

Public Sub AbortProcess()
    
    Set instComprobante = Nothing
    Set AlmacenCotizaciones = Nothing

    inProcess = False

End Sub

Public Function RegistrarVariacion(vmMonto As Currency, pComprobante As clsBufferComprobante) As Boolean
  
  If Not AlmacenCompras.RegistrarVariacion(Me, vmMonto) Then
    RegistrarVariacion = False
    Exit Function
  End If
  
  Me.Saldo = Me.Saldo - vmMonto
  If Abs(Me.Saldo) < 1 Then
    dbHandle.Execute "UPDATE IVARetenido SET Cancelado = 1 WHERE TipoDoc = 'RCM' AND NumeroDoc = " & NumeroDB(Me.Numero)
  End If
  
  RegistrarVariacion = True

End Function

Public Function DetalleItem(ByVal lNumRenglon As Long) As clsDetallesCompra
Dim pDetalle As clsDetallesCompra, rs As Recordset

  Set rs = dbHandle.Execute("SELECT * FROM DetallesCompra WHERE NumeroDocumento =" & NumeroDB(Me.Numero) & " AND Renglon =" & NumeroDB(lNumRenglon))
  If rs.EOF Then
    Set pDetalle = Nothing
  Else
    Set pDetalle = New clsDetallesCompra
    AlmacenDetallesCompra.LoadInstance pDetalle, rs
  End If
  rs.Close
  Set rs = Nothing
  
  Set DetalleItem = pDetalle
  
End Function

'Public Function RetencionIVA() As clsRetencionIVAPRV
'Dim retVal As clsRetencionIVAPRV
'  Set retVal = New clsRetencionIVAPRV
'  If retVal.LoadByRefDoc(Me.CodigoProveedor, Me.RefProveedor) = False Then
'    Set retVal = Nothing
'  End If
'  Set RetencionIVA = retVal
'End Function

Private Sub Class_Terminate()
    Set pEvaluadorVariables = Nothing
End Sub

