VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsProveedores"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' clsClassGenerator V1.0
Public Codigo As String
Public Nombre As String
Public Tipo As String
Public RIF As String
Public CuentaPasivo As String
Public Condiciones As String
Public Direccion1 As String
Public Direccion2 As String
Public Direccion3 As String
Public Direccion4 As String
Public Telefono As String
Public SaldoActual As Double
Public LimiteCredito As Double
Public FechaUltimaCompra As Date
Public Notas As String

Public FactorNormal As Currency
Public TipoEntidad As String

Public Property Get NombreTabla() As String
  NombreTabla = "Proveedores"
End Property

Public Property Get CGCuenta() As String
Dim sRetVal As String

    sRetVal = Me.CuentaPasivo
    If sRetVal = "" Then sRetVal = Empresa.CuentaGeneralDeudas
    CGCuenta = sRetVal

End Property

Private Sub Class_Initialize()
    Me.TipoEntidad = "PRV"
    Me.FactorNormal = -1@
End Sub

Public Function Contactos() As Collection
    Set Contactos = AlmacenContactos.Contactos(TipoEntidad, Me.Codigo)
End Function

Public Function EvalVar(sVarId, v, s) As Boolean
Dim bRetVal As Boolean

    bRetVal = True

    Select Case UCase(sVarId)
    Case "RIF", "RIFPROVEEDOR"
        s = Me.RIF
        v = s
    Case "DIRECCION", "DIRPROVEEDOR"
        s = Me.Direccion
        v = s
    Case "TELEFONO", "TELEFONOPROVEEDOR"
        s = Me.Telefono
        v = s
    Case "NOTASPROVEEDOR", "NOTASPROV"
        s = Me.Notas
        v = s
    Case Else
        bRetVal = False
    End Select
    
    EvalVar = bRetVal

End Function

Public Function EliminarContactos()
    
    EliminarContactos = AlmacenContactos.EliminarContactos(Me.Codigo, TipoEntidad)

End Function

Public Function Eliminar() As Boolean
Dim bRetVal As Boolean, pAtributo As clsAtributoEntidad

    StartTransaction
    
    bRetVal = EliminarContactos
    If bRetVal Then bRetVal = AlmacenProveedores.Eliminar(Me.Codigo)
    
    Set pAtributo = New clsAtributoEntidad
    pAtributo.DeleteAtributosEntidad Me.TipoEntidad, Me.Codigo
    Set pAtributo = Nothing
    
    If bRetVal Then
        CommitTransaction
    Else
        AbortTransaction
    End If
    
    Eliminar = bRetVal

End Function

Public Property Get Direccion() As String
Dim stRetBuffer As String
    stRetBuffer = Trim(Me.Direccion1) & " "
    stRetBuffer = stRetBuffer & Trim(Me.Direccion2) & " "
    stRetBuffer = stRetBuffer & Trim(Me.Direccion3) & " "
    stRetBuffer = stRetBuffer & Trim(Me.Direccion4) & " "
    Direccion = stRetBuffer
End Property

Public Property Let Direccion(s As String)
Dim nextStr As String, resto As String, i As Integer, j As Integer
    resto = s: i = 0
    Do While resto <> "" And i < 4
        j = InStr(1, resto, Chr(13), vbTextCompare)
        If j = 0 Or j > 40 Then
            j = 40
            If j > Len(resto) Then j = Len(resto)
            If (j < Len(resto)) Then
                Do While j > 1 And Mid(resto, j, 1) <> " "
                    j = j - 1
                Loop
                If (j > 1) Then
                    nextStr = left(resto, j - 1)
                Else
                    j = 40
                    nextStr = left(resto, j)
                End If
                j = j + 1
            Else
                nextStr = resto
                j = Len(resto)
            End If
        Else
            nextStr = left(resto, j - 1)
            j = j + 2
        End If
        If (j < Len(resto)) Then
            resto = right(resto, Len(resto) - j + 1)
        Else
            resto = ""
        End If
        Select Case i
        Case 0
            Direccion1 = nextStr
        Case 1
            Direccion2 = nextStr
        Case 2
            Direccion3 = nextStr
        Case 3
            Direccion4 = nextStr
        End Select
        i = i + 1
    Loop
End Property

Public Function ValidarCodigo(stiCodigo As String) As Boolean
    ValidarCodigo = AlmacenProveedores.Validar(stiCodigo)
End Function

Public Function Load(ByVal Codigo As String) As Boolean
Dim retVal As Boolean
    Me.Codigo = Codigo
    retVal = AlmacenProveedores.Load(Codigo, Me)
    Load = retVal
End Function

Public Function CreateNew() As Boolean
Dim bRetVal As Boolean
  bRetVal = AlmacenProveedores.Add(Me)
  If bRetVal Then ExecuteScript "postNuevoProveedor.vbs", Me, True
  CreateNew = bRetVal
End Function

Public Function LoadAnterior() As Boolean
    LoadAnterior = AlmacenProveedores.LoadAnterior(Me)
End Function

Public Function LoadSiguiente() As Boolean
    LoadSiguiente = AlmacenProveedores.LoadSiguiente(Me)
End Function

Public Function Refresh() As Boolean
Dim retVal As Boolean
    retVal = AlmacenProveedores.Load(Me.Codigo, Me)
    Refresh = retVal
End Function

Public Function ActualizarDescriptivos(iNombre As String, iRif As String, iCuentaPasivo As String, iCondiciones As String, iDireccion As String, iTelefono As String, iLimiteCredito As Double, iNotas As String) As Boolean
Dim bRetVal As Boolean
  Me.Direccion = iDireccion
  bRetVal = AlmacenProveedores.ActualizarDescriptivos(Me, iNombre, iRif, iCuentaPasivo, iCondiciones, Me.Direccion1, Me.Direccion2, Me.Direccion3, Me.Direccion4, iTelefono, iLimiteCredito, iNotas)
  If bRetVal Then
    Me.Refresh
    ExecuteScript "postEditProveedor.vbs", Me, False
  End If
  ActualizarDescriptivos = bRetVal
End Function

Public Function RegistrarVariacionSaldo(ByVal vmVariacion As Currency, stDescripcion As String, iComprobante As clsBufferComprobante) As Boolean
Dim bRetVal As Boolean, stCuenta As String, dDebitos As Currency, dCreditos As Currency
  bRetVal = AlmacenProveedores.RegistrarVariacionSaldo(Me, -vmVariacion)  ' Un proveedor es naturalmente una cuenta de pasivo, hence los creditos se suman, los debitos se restan
  If bRetVal Then
    If Not iComprobante Is Nothing Then
      stCuenta = Me.CGCuenta
      If stCuenta = "" Then
          iComprobante.SetError
      Else
          If vmVariacion < 0 Then
              dCreditos = -vmVariacion
              dDebitos = 0
          Else
              dCreditos = 0
              dDebitos = vmVariacion
          End If
          iComprobante.AddDetalle stCuenta, stDescripcion, dDebitos, dCreditos
      End If
    End If
  End If
  RegistrarVariacionSaldo = bRetVal
End Function

'Public Function PrecioUltimaCompra(itemID As String) As Currency
'Dim Almacen As clsAlmacenCotsPP, pCot As clsCotsProvProd
'Dim vmRetVal As Currency
'    Set Almacen = New clsAlmacenCotsPP
'    Set pCot = Almacen.GetInstance(Me.Codigo, itemID)
'    If pCot Is Nothing Then
'        vmRetVal = 0
'    Else
'        vmRetVal = pCot.PrecioUltimaCompra
'    End If
'    Set pCot = Nothing
'    Set Almacen = Nothing
'End Function

Public Sub Show()
Dim f As FIEProveedores

    If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_PROVEEDORES) Then Exit Sub

    Set f = New FIEProveedores
    f.SetCodigo Me.Codigo
    On Error Resume Next
    f.Show
    If Err.Number Then
      mAdvertencia "No se puede mostrar la forma desde na forma modal"
    Else
      f.SetContexto 1
    End If
    On Error GoTo 0

    While f.Visible: DoEvents: Wend
    
    Unload f
    Set f = Nothing

End Sub

Public Function TieneAtributo(sAtributo, Optional sValor) As Boolean
Dim pAtributo As New clsAtributoEntidad
  If IsMissing(sValor) Then
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
  Else
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor)
  End If
End Function

Public Function ValorAtributo(sAtributo)
Dim pAtributo As New clsAtributoEntidad
  ValorAtributo = pAtributo.ValAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
End Function

Public Function Atributos(Optional sAtributo As String = "")
Dim pAtributo As New clsAtributoEntidad
  Set Atributos = pAtributo.Atributos(Me.TipoEntidad, Me.Codigo, sAtributo)
End Function

Public Sub SetValorAtributo(sAtributo, sValor)
Dim pAtributo As New clsAtributoEntidad
  pAtributo.SetValorAtributo Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor
End Sub

