VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsProcesadorCobro"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Function PasarCobro(lNumDoc As Long, stDescripcion As String, vmMontoCobrado As Currency, vmDescuento As Currency, vmISLRetenido As Currency, dtFecha As Date, pComprobante As clsBufferComprobante, Optional ByVal vmIVARetenido As Currency = 0) As Boolean
Dim pDet As clsDetalleCuentaEntidad, pDoc As clsDocumentosISPC, bRetVal As Boolean, stcEntidad As String, sttEntidad As String

  Set pDoc = New clsDocumentosISPC
  If Not pDoc.Load(lNumDoc) Then
    Set pDoc = Nothing
    Err.Raise 10001, "clsProcesadorCobro.PasarCobro", "Referencia a documento no registrado (" & Trim(Str(lNumDoc)) & ")"
    PasarCobro = False
    Exit Function
  End If
  stcEntidad = pDoc.CodigoEntidad
  sttEntidad = pDoc.TipoEntidad

'   Se carg tipo y codigo de entidad desde el documento

  Set pDet = New clsDetalleCuentaEntidad
  
  If Abs(vmMontoCobrado) > 0# Then
    pDet.Add lNumDoc, stcEntidad, sttEntidad, dtFecha, stDescripcion, -vmMontoCobrado, pComprobante
  End If
  
  If vmDescuento > 0.1 Then
    bRetVal = pDet.Add(lNumDoc, stcEntidad, sttEntidad, dtFecha, "Descuento en " & pDoc.ReferenciaDocumento, -vmDescuento, pComprobante)
    pDoc.NotificarDescuento Abs(vmDescuento), pComprobante, dtFecha
  End If
  
  If vmISLRetenido Then
    pDet.Add lNumDoc, stcEntidad, sttEntidad, dtFecha, "ISLR pagado en " & pDoc.ReferenciaDocumento, -vmISLRetenido, pComprobante
  End If
  
  If vmIVARetenido > 0 Then
    pDet.Add lNumDoc, stcEntidad, sttEntidad, dtFecha, "IVA retenido en " & pDoc.ReferenciaDocumento, -vmIVARetenido, pComprobante
    Dim pRetencionIVA As New clsRetencionIVA
    pRetencionIVA.Registrar pDoc, dtFecha, vmIVARetenido
    Set pRetencionIVA = Nothing
  End If
  
  Set pDet = Nothing
  Set pDoc = Nothing
  
  PasarCobro = True

End Function

