VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsOrdenesCompra"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Numero As Long
Public FechaRegistro As Date
Public FechaTransaccion As Date
Public Operador As String
Public CodigoProveedor As String
Public NombreProveedor As String
Public FechaRequerido As Date
Public Estado As Integer            ' 0:Pendiente;1:Satisfecha;2:Cancelada
Public ValorNominal As Currency
Public ValorRecibido As Currency
'Public Condicion As String
Public Descuento1 As Double
Public Descuento2 As Double
Public Notas As String

Private inProcess As Boolean
Private NextDetalle As Integer

Public pEvaluadorVariable As CExpEvalDocCompra

' **********************************************
' Funciones y mtodos y miembros Standard ISDOC:
' **********************************************
Public TipoEntidad As String                ' Idntificacin para ISDOC

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Function Descripcion() As String
  Descripcion = NombreProveedor
End Function

Public Sub LoadInstance(rsHandle As Recordset, Optional pInstance As clsOrdenesCompra = Nothing)
    
    If pInstance Is Nothing Then Set pInstance = Me
    
    With rsHandle
    pInstance.Numero = .Fields("Numero")
    pInstance.FechaRegistro = .Fields("FechaRegistro")
    pInstance.FechaTransaccion = .Fields("FechaTransaccion")
    pInstance.Operador = .Fields("Operador")
    pInstance.CodigoProveedor = .Fields("CodigoProveedor")
    pInstance.NombreProveedor = .Fields("NombreProveedor")
    pInstance.ValorNominal = .Fields("ValorNominal")
'    pInstance.ValorRecibido = .Fields("ValorRecibido")
    pInstance.FechaRequerido = .Fields("FechaRequerido")
    pInstance.Estado = .Fields("Estado")
'    pInstance.Condicion = .Fields("Condicion")
    pInstance.Descuento1 = GetNumeroFromVariant(.Fields("Descuento1"))
    pInstance.Descuento2 = GetNumeroFromVariant(.Fields("Descuento2"))
    pInstance.Notas = GetStringFromVariant(.Fields("Notas"))
    End With

End Sub

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evOrdenCompra.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, v, s)
Dim localV As Variant, localStr As String, bRetVal As Boolean
    
    bRetVal = pEvaluadorVariable.EvalVar(sVarId, localV, localStr, Me)
    
    If Not bRetVal Then
        bRetVal = ExtendEval(sVarId, v, s)
    End If
    
    If bRetVal Then
        v = localV
        s = localStr
    End If
    
    EvalVar = bRetVal
End Function

Public Function Load(Numero As Long) As Boolean
Dim rs As Recordset, isOK As Boolean

    On Error GoTo ErrHandler

    Set rs = dbHandle.Execute("SELECT * FROM ocOrdenes WHERE Numero = " & NumeroDB(Numero))
    If Not rs.EOF Then
        LoadInstance rs
        isOK = True
    Else
        isOK = False
    End If

ResumePoint:
    Set rs = Nothing
    Load = isOK

    Exit Function

ErrHandler:
    isOK = False
    Resume ResumePoint

End Function

Public Property Get Correlativo() As Long
    Correlativo = Me.Numero
End Property

Public Function Referencia() As String
    Referencia = TipoEntidad & "-" & Format(Numero, "000000")
End Function

Public Function Concepto() As String
Dim stRetVal As String
    Concepto = "ORDEN DE COMPRA " & Me.Numero
End Function

' *****************************************
' * Documento Compra:                     *
' * Funciones para proveer compatibilidad *
' * con CExpEvalDocCompra                 *
' *****************************************

Public Function RefProveedor() As String
    RefProveedor = Me.Referencia
End Function

Public Function CostoMercancia() As Currency
    CostoMercancia = Me.ValorNominal
End Function

Public Function Impuesto1() As Currency
Dim pItem As clsItemInventario, vmRetVal As Currency
Dim pDetalle As clsDetalleOrdenCompra, pDesc As Double

    pDesc = ValorDescuentosSucesivos(Descuento1, Descuento2)
    vmRetVal = 0
    For Each pDetalle In Me.Detalles
        If pDetalle.CodigoItem <> "" Then
            Set pItem = AlmacenItemsInventario.itemInventario(pDetalle.CodigoItem)
            If Not pItem Is Nothing Then
                vmRetVal = vmRetVal + pDetalle.Cantidad * pDetalle.PrecioRequerido * (1# - pDesc / 100) * TiposImpuesto.ValorActualImpuesto(pItem.claseImpuesto1) / 100
                Set pItem = Nothing
            End If
        End If
    Next
    Impuesto1 = vmRetVal

End Function

Public Function Impuesto2() As Currency
    Impuesto2 = 0
End Function

Public Function Almacen() As String
    Almacen = "N/A"
End Function

Public Function Condicion() As String
    Condicion = "N/A"
End Function

Public Function Saldo() As Currency
    Saldo = 0
End Function
' ****** /Documento Compra ******

Public Function NombreArchivoFormato() As String
    NombreArchivoFormato = DeterminarFormato("FormatoOrdenCompra", "FormatosOrdenCompra", BuildDataPath("FormatoOrdenCompra.txt", AppName), Me)
End Function

Public Function Detalles() As Collection
Dim colRetVal As Collection, pDetalle As clsDetalleOrdenCompra
    Set pDetalle = New clsDetalleOrdenCompra
    Set colRetVal = pDetalle.Renglones(Me.Numero)
    Set pDetalle = Nothing
    Set Detalles = colRetVal
End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String

    bRetVal = EvalVar(sVarId, vBuf, sBuf)
    GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)
    
End Function

' LoadByRef recibe una "referencia" completa a un documento ISDOC,
' y carga los datos correspondientes en <Me>
' Devuelve True si existe una factura con la referencia recibida
Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim lngNumDoc As Long, i As Integer

    lngNumDoc = Val(right(sRef, Len(sRef) - 4))
    LoadByReferenciaISDOC = Load(lngNumDoc)

End Function

' Show (ISDOC) causa que el documento se presente en una forma de
' consulta...
Public Sub Show()
'Dim frmView As frmViewOrdenCompra
'
'    Set frmView = New frmViewOrdenCompra
'    frmView.SetOrden Me.Numero
'    ShowNonModal frmView
'    Unload frmView
'    Set frmView = Nothing

End Sub

' Se presenta y/o imprime el documento
Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
    Set cFormato = New CFormatoDocumento
    cFormato.SetDocumento Me, Not AutoPrint
    Set cFormato = Nothing
End Sub
' **************************************************************
' ************ END ISDOC
' **************************************************************


Public Property Get ImagenEstado() As String
    
    Select Case Me.Estado
    Case 0
        ImagenEstado = "INICIAL"
    Case 1
        ImagenEstado = "SATISFECHA"
    Case 2
        ImagenEstado = "ANULADA"
    End Select

End Property

Public Property Get Modificable() As Boolean
    Modificable = (Me.Estado < 1)
End Property

' ******* Funciones de proceso *******

Public Sub StartProcess()
    
    NextDetalle = 1
    inProcess = True
    
End Sub

Public Function ProximoNumero() As Long
Dim lLastNumero As Long, rs As Recordset
    Set rs = dbHandle.Execute("SELECT MAX(Numero) as UltimoNumero FROM ocOrdenes")
    If rs.EOF Then
        lLastNumero = 0
    Else
        lLastNumero = GetNumeroFromVariant(rs.Fields("UltimoNumero"))
    End If
    ProximoNumero = lLastNumero + 1
End Function

Public Sub Update()
Dim sQuery As String, isNew As Boolean

    If Not inProcess Then
        Err.Raise 1, "clsOrdenesCompra::Update", "Llamada a Update sin StartProcess"
    End If

    With Me
    isNew = (.Numero = 0)
    
    If .Numero = 0 Then
        .Numero = Contadores.NumeroProximoDocumento(Me.TipoEntidad, True)
        sQuery = "INSERT INTO ocOrdenes (Numero, FechaRegistro, FechaTransaccion, Operador, CodigoProveedor, NombreProveedor, FechaRequerido, Estado, ValorNominal, Descuento1, Descuento2, Notas) SELECT "
        sQuery = sQuery & NumeroDB(.Numero) & ", "
        sQuery = sQuery & TimeDateDB(Now) & ", "
        sQuery = sQuery & FechaDB(.FechaTransaccion) & ", "
        sQuery = sQuery & StringDB(.Operador) & ", "
        sQuery = sQuery & StringDB(.CodigoProveedor) & ", "
        sQuery = sQuery & StringDB(.NombreProveedor) & ", "
        sQuery = sQuery & FechaDB(.FechaRequerido) & ", "
        sQuery = sQuery & NumeroDB(.Estado) & ", "
        sQuery = sQuery & NumeroDB(.ValorNominal) & ", "
        sQuery = sQuery & NumeroDB(.Descuento1) & ", "
        sQuery = sQuery & NumeroDB(.Descuento2) & ", "
        sQuery = sQuery & StringDB(.Notas)
    Else
        sQuery = "UPDATE ocOrdenes SET "
        sQuery = sQuery & "FechaTransaccion = " & FechaDB(.FechaTransaccion) & ", "
        sQuery = sQuery & "Operador = " & StringDB(.Operador) & ", "
        sQuery = sQuery & "CodigoProveedor = " & StringDB(.CodigoProveedor) & ", "
        sQuery = sQuery & "NombreProveedor = " & StringDB(.NombreProveedor) & ", "
        sQuery = sQuery & "FechaRequerido = " & FechaDB(.FechaRequerido) & ", "
        sQuery = sQuery & "ValorNominal = " & NumeroDB(.ValorNominal) & ", "
        sQuery = sQuery & "Descuento1 = " & NumeroDB(.Descuento1) & ", "
        sQuery = sQuery & "Descuento2 = " & NumeroDB(.Descuento2) & ", "
        sQuery = sQuery & "Notas = " & StringDB(.Notas) & " "
        sQuery = sQuery & "WHERE Numero = " & NumeroDB(.Numero)
    
    End If
    
    End With
    
    dbHandle.Execute sQuery

    If Not isNew Then dbHandle.Execute "DELETE FROM ocDetalles WHERE NumeroDocumento = " & NumeroDB(Numero)

End Sub

Public Sub AddDetalle(istrCodigo As String, istrDescripcion As String, istrPresentacion As String, idblCantidad As Double, ivmPrecioRequerido As Currency)
Dim sQuery As String, isNew As Boolean, vmPrecioEfectivo As Currency
Dim pItemInv As clsItemInventario, dblFactorEmpaque As Double
Dim pDesc As Double

    If Not inProcess Then
        Err.Raise 10001, "clsOrdenesCompra::AddDetalle", "Llamada a AddDetalle sin StartProcess"
    End If

    Set pItemInv = New clsItemInventario
    If istrCodigo = "" Then
        dblFactorEmpaque = 0
    Else
        If Not pItemInv.Load(istrCodigo) Then
            dblFactorEmpaque = 1
        Else
            dblFactorEmpaque = pItemInv.FactorPresentacion(istrPresentacion)
        End If
    End If

    pDesc = ValorDescuentosSucesivos(Descuento1, Descuento2)
    sQuery = "INSERT INTO ocDetalles (NumeroDocumento, Renglon, CodigoItem, Descripcion, Presentacion, FactorEmpaque, Cantidad, PrecioRequerido) SELECT "
    sQuery = sQuery & NumeroDB(Numero) & ", "
    sQuery = sQuery & NumeroDB(NextDetalle) & ", "
    sQuery = sQuery & StringDB(istrCodigo) & ", "
    sQuery = sQuery & StringDB(istrDescripcion) & ", "
    If istrCodigo <> "" Then
        sQuery = sQuery & StringDB(istrPresentacion) & ", "
        sQuery = sQuery & NumeroDB(dblFactorEmpaque) & ", "
        sQuery = sQuery & NumeroDB(idblCantidad) & ", "
        sQuery = sQuery & NumeroDB(ivmPrecioRequerido * (1# - (pDesc / 100)))  ' Dos decimales
    Else
        sQuery = sQuery & "'', 0, 0, 0"
    End If

    dbHandle.Execute sQuery
    NextDetalle = NextDetalle + 1
    Set pItemInv = Nothing

End Sub

Public Sub EndProcess()
  If Not inProcess Then
    Err.Raise 10001, "clsOrdenesCompra::AddDetalle", "Llamada a AddDetalle sin StartProcess"
  End If
  inProcess = False
  SubmitDoc Me
End Sub

Public Sub AbortProcess()
    If Not inProcess Then Exit Sub
    inProcess = False
End Sub

' ******* Utilidades varias *******

Public Function OrdenesProveedor(istrCodigoProveedor As String, nStatus As Integer) As Collection
Dim retCol As Collection, lpCot As clsOrdenesCompra
Dim rs As Recordset

    On Error GoTo ErrHandler
    
    Set retCol = New Collection
    Set rs = dbHandle.Execute("SELECT * FROM ocOrdenes WHERE CodigoProveedor = " & StringDB(istrCodigoProveedor) & " AND Estado <= " & NumeroDB(nStatus) & " ORDER BY Numero")
    Do While Not rs.EOF
    
        Set lpCot = New clsOrdenesCompra
        LoadInstance rs, lpCot
        retCol.Add lpCot
    
        rs.MoveNext
        
    Loop

ResumePoint:
    Set rs = Nothing
    Set OrdenesProveedor = retCol
    Exit Function

ErrHandler:
    Set retCol = Nothing
    Set retCol = New Collection
    Resume ResumePoint

End Function

Public Function OrdenesPendientesProveedor(istrCodigoProveedor As String) As Collection
    Set OrdenesPendientesProveedor = OrdenesProveedor(istrCodigoProveedor, 0)
End Function

Public Sub SetEstado(inEstado As Integer)
    Me.Estado = inEstado
    dbHandle.Execute "UPDATE ocOrdenes SET Estado = " & NumeroDB(Me.Estado) & " WHERE Numero = " & Me.Numero
End Sub

Public Sub ActualizarNotas(istrNewNotes As String)
    Me.Notas = istrNewNotes
    dbHandle.Execute "UPDATE ocOrdenes SET Notas = " & StringDB(Me.Notas) & " WHERE Numero = " & NumeroDB(Me.Numero)
End Sub

Public Sub ActualizarStatus()
Dim rs As Recordset, nEstado As Integer
    nEstado = Me.Estado
    If nEstado < 2 Then
    ' Ningun renglon tiene unidades pendientes
        Set rs = dbHandle.Execute("SELECT Count(NumeroDocumento) AS Q FROM ocDetalles WHERE NumeroDocumento = " & NumeroDB(Me.Numero) & " AND Cantidad > Recibidas")
        If rs.EOF Then
            nEstado = 1
        Else
            If GetNumeroFromVariant(rs.Fields("Q")) = 0 Then
                nEstado = 1
            End If
        End If
        Set rs = Nothing
    End If
    SetEstado nEstado
End Sub

' ******* Clase *******

Private Sub Class_Initialize()
    inProcess = False
    TipoEntidad = "ODC"
    Set pEvaluadorVariable = New CExpEvalDocCompra
End Sub

Private Sub Class_Terminate()
    Set pEvaluadorVariable = Nothing
End Sub

Public Sub UpdateNotas(istrText As String)
    Me.Notas = istrText
    dbHandle.Execute "UPDATE ocOrdenes SET Notas = " & StringDB(Me.Notas) & " WHERE Numero = " & NumeroDB(Me.Numero)
End Sub

