VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsOrdenRWS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Numero As Long       ' Numero de la orden (PK)
Public TipoEquipo As String
Public Serial As String     ' Identificacion del equipo
Public FechaRecepcion As Date
Public Sintomas As String
Public Estado As Integer    ' 0: RECIBIDA; 1:ASIGNADA; 2:LISTA
Public Tecnico As String    ' Cdigo del tcnico (en Vendedores)
Public Notas As String      ' Diagnstico y tareas realizadas
Public Factura As Long      ' Nmero de la factura correspondiente a la tarea

Public TipoEntidad As String    ' Identificacin para ISDOC
Private nNextRenglon As Integer

Public Function ImagenEstado() As String
    
  Select Case Me.Estado
  Case 0
    ImagenEstado = "RECIBIDA"
  Case 1
    ImagenEstado = "ASIGNADA"
  Case 2
    ImagenEstado = "ANULADA"
  Case 3
    ImagenEstado = "TERMINADA"
  Case 4
    ImagenEstado = "FACTURADA"
  Case Else
    ImagenEstado = "INVALIDO"
  End Select

End Function

Private Sub LoadInstance(pInstance As clsOrdenRWS, rs As Recordset)
    
    With rs
    Numero = GetNumeroFromVariant(.Fields("Numero"))
    TipoEquipo = stGetStringFromVariant(.Fields("TipoEquipo"))
    Serial = stGetStringFromVariant(.Fields("Serial"))
    FechaRecepcion = GetDateFromVariant(.Fields("FechaRecepcion"))
    Sintomas = stGetStringFromVariant(.Fields("Sintomas"))
    Estado = .Fields("Estado")
    Tecnico = stGetStringFromVariant(.Fields("Tecnico"))
    Notas = stGetStringFromVariant(.Fields("Notas"))
    Factura = .Fields("Factura")
    End With

End Sub

' **********************************************
' Funciones y mtodos y miembros Standard ISDOC:
' **********************************************
Public Function Descripcion() As String
    
    Descripcion = "ORDEN No. " & Trim(Str(Numero)) & ": " & TipoEquipo & " S/N " & Serial

End Function

Public Function Load(Numero As Long) As Boolean
Dim rs As Recordset, sQuery As String, isOk As Boolean

    sQuery = "SELECT * FROM rwsOrdenesTrabajo WHERE Numero = " & Trim(Str(Numero))
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If Not rs.EOF Then
        LoadInstance Me, rs
        isOk = True
    Else
        isOk = False
    End If
    
    Load = isOk

End Function

Public Function Referencia() As String
    
    Referencia = TipoEntidad & "-" & Format(Numero, "000000")

End Function

Public Function Concepto() As String
Dim stRetVal As String

    Concepto = "ORDEN DE TRABAJO " & Me.Referencia

End Function

Public Function NombreArchivoFormato() As String

    If Me.Estado Then
        NombreArchivoFormato = BuildDataPath("FormatoRecepcionRWS.txt", AppName)
    Else
        NombreArchivoFormato = BuildDataPath("FormatoEstadoRWS.txt", AppName)
    End If

End Function

Public Function Detalles() As Collection
Dim colRetVal As Collection, sQuery As String, rs As Recordset
Dim pDetalle As clsDetalleOrdenRWS
    
    Set colRetVal = New Collection
    
    sQuery = "SELECT * FROM rwsDetallesOrden WHERE NumeroOrden = " & Trim(Str(Me.Numero)) & " ORDER BY NumeroRenglon"
    
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    Do While Not rs.EOF
        Set pDetalle = New clsDetalleOrdenRWS
        pDetalle.LoadInstance pDetalle, rs
        colRetVal.Add pDetalle
        rs.MoveNext
    Loop
    Set rs = Nothing

    Set Detalles = colRetVal

End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evOrdenRWS.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId As String, ByRef vRetBuffer As Variant, ByRef sRetString As String) As Boolean
Dim bRetVal As Boolean
Dim pCliente As clsClientes
Dim pEquipo As clsEquipo
Dim pVendedor As clsVendedores

    bRetVal = True

    Select Case UCase(sVarId)
    Case "NUMERO"
        vRetBuffer = Me.Numero
        sRetString = Format(Me.Numero, "000000")
    Case "CODIGO_EQUIPO", "TIPOEQUIPO"
        vRetBuffer = Me.TipoEquipo
        sRetString = Me.TipoEquipo
    Case "DESCRIPCION_EQUIPO"
        vRetBuffer = TiposEquipo.Nombre(TipoEquipo)
        sRetString = vRetBuffer
    Case "SERIAL"
        vRetBuffer = Serial
        sRetString = Serial
    Case "FECHA_RECEPCION", "FECHA"
        vRetBuffer = FechaRecepcion
        sRetString = Format(FechaRecepcion, "Short Date")
    Case "SINTOMAS", "FALLA"
        vRetBuffer = Sintomas
        sRetString = Sintomas
    Case "ESTADO"
        sRetString = Me.ImagenEstado
        vRetBuffer = sRetString
    Case "NOTAS"
        sRetString = Notas
        vRetBuffer = sRetString
    Case "CODIGO_TECNICO"
        sRetString = Me.Tecnico
        vRetBuffer = sRetString
    Case "NOMBRE_TECNICO"
        Set pVendedor = Me.Vendedor
        If pVendedor Is Nothing Then
            sRetString = "N/A"
        Else
            sRetString = pVendedor.Nombre
        End If
        vRetBuffer = sRetString
    Case "CODIGO_CLIENTE", "CODCLI", "CLIENTE"
        Set pEquipo = Me.Equipo
        If pEquipo Is Nothing Then
            sRetString = "ERROR:EQUIPO"
        Else
            sRetString = pEquipo.Propietario
        End If
        vRetBuffer = sRetString
    Case "NOMBRE_CLIENTE", "NOMBRECLIENTE", "NOMBRECLI"
        Set pEquipo = Me.Equipo
        If pEquipo Is Nothing Then
            sRetString = "ERROR:EQUIPO"
        Else
            Set pCliente = pEquipo.Cliente
            If pCliente Is Nothing Then
                sRetString = "ERROR:CLIENTE"
            Else
                sRetString = pCliente.Nombre
            End If
        End If
        Set pEquipo = Nothing
        vRetBuffer = sRetString
    Case "NOTAS_EQUIPO", "NOTASEQUIPO"
        Set pEquipo = Me.Equipo
        If pEquipo Is Nothing Then
            sRetString = "ERROR:EQUIPO"
        Else
            sRetString = pEquipo.Notas
        End If
        vRetBuffer = sRetString
        Set pEquipo = Nothing
    Case "VALOR", "MONTO", "PRECIO"
        vRetBuffer = Me.ValorReparacion
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)
    Case "IMPUESTO"
        vRetBuffer = Me.ValorImpuesto(1) + Me.ValorImpuesto(2)
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)
    Case "IMPUESTO1", Empresa.NombreImpuesto1
        vRetBuffer = Me.ValorImpuesto(1)
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)
    Case "IMPUESTO2", Empresa.NombreImpuesto2
        vRetBuffer = Me.ValorImpuesto(2)
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)
    Case Else
        bRetVal = False
    End Select

    If Not bRetVal Then
        bRetVal = ExtendEval(sVarId, vRetBuffer, sRetString)
    End If
    

    If Not bRetVal Then
        If left(sVarId, 8) = "FACTURA." Then
            If Not pFactura Is Nothing Then
                bRetVal = pFactura.EvalVar(right(sVarId, Len(sVarId) - 8), vRetBuffer, sRetString)
            End If
        End If
    End If

    EvalVar = bRetVal

End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String

    bRetVal = EvalVar(sVarId, vBuf, sBuf)
    GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)

End Function

' LoadByRef recibe una "referencia" completa a un documento ISDOC,
' y carga los datos correspondientes en <Me>
' Devuelve True si existe una factura con la referencia recibida
Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim lNumero As Long

    lNumero = Val(right(sRef, Len(sRef) - 4))
    LoadByReferenciaISDOC = Load(lNumero)

End Function

' Show (ISDOC) causa que el documento se presente en una forma de
' consulta...
Public Sub Show()
Dim f As frmViewOrdenRWS

    Set f = New frmViewOrdenRWS
    f.SetFields Me
    ShowNonModal f
    Unload f
    Set f = Nothing

End Sub

' Se presenta y/o imprime el documento
Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento

    Set cFormato = New CFormatoDocumento
    cFormato.SetDocumento Me, AutoPrint
    Set cFormato = Nothing

End Sub

Public Function Create(isTipoEquipo As String, _
                        isSerial As String, _
                        idFechaRecepcion As Date, _
                        isSintomas As String) As Boolean
Dim sQuery As String, rs As Recordset
Dim isOk As Boolean

  lmdbHandle.StartTransaction

  Set rs = dbHandle.OpenRecordset("SELECT Max(Numero) AS Num FROM rwsOrdenesTrabajo", dbOpenForwardOnly)
  If rs.EOF Then
    Numero = 0
  Else
    Numero = GetNumeroFromVariant(rs.Fields("Num"))
  End If
  Set rs = Nothing

  Numero = Numero + 1
  Estado = 0
  Factura = 0
  FechaRecepcion = idFechaRecepcion
  Notas = ""
  Serial = isSerial
  Sintomas = isSintomas
  TipoEquipo = isTipoEquipo
  Tecnico = ""

  sQuery = "INSERT INTO rwsOrdenesTrabajo (Numero, TipoEquipo, Serial, FechaRecepcion, Sintomas) VALUES ("
  sQuery = sQuery & Trim(Str(Numero)) & ", " & StringDB(isTipoEquipo) & ", " & StringDB(isSerial) & ", "
  sQuery = sQuery & FechaDB(idFechaRecepcion) & ", " & StringDB(isSintomas) & ")"

  On Error GoTo ErrHandler

  isOk = True
  dbHandle.Execute sQuery, dbFailOnError
  dbHandle.Execute "UPDATE rwsEquipos SET Estado = 1 WHERE TipoEquipo = " & StringDB(Me.TipoEquipo) & " AND Serial = " & StringDB(Me.Serial), dbFailOnError
  
  lmdbHandle.CommitTransaction

  mScriptExecute.ExecuteScript "postOrdenRWS.vbs", Me, False

ResumePoint:
  Create = isOk
  Exit Function

ErrHandler:
  lmdbHandle.AbortTransaction
  isOk = False
  ReportarError False, Err.Number, Err.Ds, "clsOrdenRWS::Create"
  Resume ResumePoint

End Function

Private Sub Class_Initialize()

  TipoEntidad = "ODT"

End Sub

Public Function SelectOrden() As String
Dim f As frmBuscarOrdenRWS, lNumero As Long

  Set f = New frmBuscarOrdenRWS
  f.Show vbModal
  lNumero = f.NumeroOrden
  Unload f
  Set f = Nothing
  
  If lNumero <> 0 Then
    SelectOrden = Trim(Str(lNumero))
  Else
    SelectOrden = ""
  End If

End Function

Public Function StartUpdate(lNumero As Long) As Boolean
Dim sQuery As String, isOk As Boolean

    On Error GoTo ErrHandler

    lmdbHandle.StartTransaction
    
    isOk = Me.Load(lNumero)

    If Not isOk Then
        lmdbHandle.AbortTransaction
        mAdvertencia "ERROR: Nmero de orden invlido (" & lNumero & ") en clsOrdenRWS::StartUpdate"
        StartUpdate = False
        Exit Function
    End If
    
    sQuery = "DELETE * FROM rwsDetallesOrden WHERE NumeroOrden = " & lNumero
    dbHandle.Execute sQuery, dbFailOnError
    nNextRenglon = 1

ResumePoint:

    StartUpdate = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsOrdenRWS::StartUpdate"
    isOk = False
    lmdbHandle.AbortTransaction
    Resume ResumePoint

End Function

Public Function ActualizarDescriptivos(NumeroOrden As Long, sCodigoTecnico As String, sNotas As String, sSintoma As String, doCerrarOrden As Boolean) As Boolean
Dim sQuery As String, isOk As Boolean
Dim pEquipo As clsEquipo

    If Me.Numero <> NumeroOrden Then
        mAdvertencia "iError: Numero != Arg: clsOrdenRWS::ActualizarDescriptivos"
        ActualizarDescriptivos = False
        Exit Function
    End If

    Me.Tecnico = sCodigoTecnico
    Me.Notas = sNotas
    Me.Sintomas = sSintoma
    
    isOk = True
    On Error GoTo ErrHandler
    
    sQuery = "UPDATE rwsOrdenesTrabajo SET Sintomas = " & StringDB(sSintoma) & ", Tecnico = " & StringDB(sCodigoTecnico) & ", Notas = " & StringDB(sNotas) & " WHERE Numero = " & NumeroOrden
    dbHandle.Execute sQuery, dbFailOnError

    Set pEquipo = New clsEquipo
    If doCerrarOrden Then
        sQuery = "UPDATE rwsOrdenesTrabajo SET Estado = 2 WHERE Numero = " & NumeroOrden
        pEquipo.SetEstado Me.TipoEquipo, Me.Serial, 3
    ElseIf sCodigoTecnico <> "" Then
        sQuery = "UPDATE rwsOrdenesTrabajo SET Estado = 1 WHERE Numero = " & NumeroOrden
        pEquipo.SetEstado Me.TipoEquipo, Me.Serial, 2
    Else
        sQuery = "UPDATE rwsOrdenesTrabajo SET Estado = 0 WHERE Numero = " & NumeroOrden
        pEquipo.SetEstado Me.TipoEquipo, Me.Serial, 1
    End If
    Set pEquipo = Nothing
    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:

    ActualizarDescriptivos = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsOrdenRWS::ActualizarDescriptivos"
    isOk = False
    Resume ResumePoint

End Function

Public Function NextDetalle() As Long

    NextDetalle = nNextRenglon

End Function

Public Function AddDetalle(NumeroOrden As Long, sCodigoItem As String, sDescripcion As String, dblCantidad As Double, vPrecioUnitario As Currency) As Boolean
Dim sQuery As String, isOk As Boolean

    isOk = True
    On Error GoTo ErrHandler
    
    sQuery = "INSERT INTO rwsDetallesOrden (NumeroOrden, NumeroRenglon, CodigoProducto, Descripcion, Cantidad, PrecioUnitario) VALUES ("
    sQuery = sQuery & NumeroOrden & ", "
    sQuery = sQuery & nNextRenglon & ", "
    sQuery = sQuery & StringDB(sCodigoItem) & ", "
    sQuery = sQuery & StringDB(sDescripcion) & ", "
    sQuery = sQuery & dblCantidad & ", "
    sQuery = sQuery & Str(vPrecioUnitario) & ")"
    dbHandle.Execute sQuery, dbFailOnError

    nNextRenglon = nNextRenglon + 1

ResumePoint:
    AddDetalle = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsOrdenRWS::AddDetalle"
    isOk = False
    Resume ResumePoint

End Function

Public Sub CommitUpdate()

    lmdbHandle.CommitTransaction

End Sub

Public Sub RollBack()

    lmdbHandle.AbortTransaction

End Sub

Public Function Anular(iNumero As Long) As Boolean
Dim sQuery As String, isOk As Boolean, pEquipo As clsEquipo

    If Not Me.Load(iNumero) Then
        mAdvertencia "Orden nmero " & iNumero & " no localizada en clsOrdenRWS::Anular"
        Anular = False
        Exit Function
    End If

    isOk = True
    On Error GoTo ErrHandler
    
    sQuery = "DELETE * FROM rwsDetallesOrden WHERE NumeroOrden = " & iNumero
    dbHandle.Execute sQuery, dbFailOnError

    sQuery = "UPDATE rwsOrdenesTrabajo SET Estado = 2 WHERE Numero = " & iNumero
    dbHandle.Execute sQuery, dbFailOnError

    Set pEquipo = New clsEquipo
    pEquipo.SetEstado Me.TipoEquipo, Me.Serial, NUEVO
    Set pEquipo = Nothing

ResumePoint:
    Set pEquipo = Nothing
    Anular = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsOrdenRWS::Anular"
    isOk = False
    Resume ResumePoint

End Function

Public Function Facturar(iNumeroOrden As Long) As Boolean
Dim pFactura As clsFacturas
Dim pCliente As clsClientes
Dim pVendedor As clsVendedores
Dim pItemVenta As clsItemVenta
Dim pEquipo As clsEquipo
Dim colDetalles As Collection
Dim ValorMercancia As Currency, isOk As Boolean
Dim pDetalle As clsDetalleOrdenRWS
Dim inProcess As Boolean
Dim vmImpuesto As Currency
Dim pProcesador As CProcesadorFacturas
Dim colSeriales As CSerialesDocumento

    On Error GoTo ErrHandler
    
    inProcess = False
    If Not Me.Load(iNumeroOrden) Then
        mAdvertencia "clsOrdenRWS::Facturar: Imposible cargar Orden N " & iNumeroOrden
        Facturar = False
        Exit Function
    End If

    Set colDetalles = Me.Detalles
    If colDetalles.Count = 0 Then
        mAdvertencia "clsOrdenRWS::Facturar: Ningn producto o servicio ha sido cargado a la orden"
        Set colDetalles = Nothing
        Facturar = False
        Exit Function
    End If

    Set pEquipo = New clsEquipo
    If Not pEquipo.Load(Me.TipoEquipo, Me.Serial) Then
        mAdvertencia "clsOrdenRWS::Facturar: No localic el equipo " & Me.TipoEquipo & " S/N " & Me.Serial
        Facturar = False
        Set pEquipo = Nothing
        Exit Function
    End If

    Set pCliente = New clsClientes
    If Not pCliente.Load(pEquipo.Propietario) Then
        mAdvertencia "clsOrdenRWS::Facturar: No encuentro el registro del cliente " & pEquipo.Propietario & ", propietario del equipo en proceso."
        Facturar = False
        Set pCliente = Nothing
        Set pEquipo = Nothing
        Exit Function
    End If

    Set pVendedor = New clsVendedores
    If Not pVendedor.Load(Me.Tecnico) Then
        mAdvertencia "clsOrdenRWS::Facturar: No encuentro el registro de vendedor de " & Me.Tecnico & ", tcnico asignado a esta orden."
        Facturar = False
        Set pVendedor = Nothing
        Set pCliente = Nothing
        Set pEquipo = Nothing
        Exit Function
    End If
    
    ValorMercancia = 0: vmImpuesto = 0
    Set pItemVenta = New clsItemVenta
    For Each pDetalle In colDetalles
        ValorMercancia = ValorMercancia + pDetalle.PrecioTotal
        If pItemVenta.Load(pDetalle.CodigoProducto) Then
            vmImpuesto = vmImpuesto + pDetalle.PrecioTotal * TiposImpuesto.ValorActualImpuesto(pItemVenta.TipoImpuesto1) / 100#
        End If
    Next
    Set pItemVenta = Nothing

    isOk = True
        
    Set pFactura = New clsFacturas
    Set colSeriales = New CSerialesDocumento
    
    For Each pDetalle In colDetalles
        pDetalle.RefSerial = colSeriales.LoadSerialesRenglon(pDetalle.CodigoProducto, Me.TipoEntidad, Me.Numero, pDetalle.NumeroRenglon)
    Next
    colSeriales.Revertir Me.TipoEntidad, Me.Numero
    
    With pFactura
    .CodigoCliente = pCliente.Codigo
    .NombreCliente = pCliente.Nombre
    .CodigoVendedor = Me.Tecnico
    .Condicion = pCliente.CondicionStandard
    .Descuento1 = 0
    .Descuento2 = 0
    .DireccionEntrega = ""
    .ExtRef = "RWS" & Me.Numero
    .FechaTransaccion = Date
    .Impuesto1 = vmImpuesto
    .PrecioEfectivo = ValorMercancia
    .Impuesto2 = 0#
    .IndiceReferencia = 1
    .IndiceVenta = 1
    .Serie = Empresa.SerieDefault
    .Notas = "ORDEN No. " & Me.Numero & vbCrLf & TiposEquipo.Nombre(pEquipo.TipoEquipo) & " S/N " & pEquipo.Serial & vbCrLf & Me.Sintomas
    If Len(.Notas) > 255 Then .Notas = left(Notas, 255)
    End With
        
    Set pProcesador = New CProcesadorFacturas
    
    isOk = pProcesador.StartProcess(pFactura, colDetalles.Count)

    If isOk Then
    Dim sUnidad As String
        
        inProcess = True
                
        Set pItemVenta = New clsItemVenta
        For Each pDetalle In colDetalles
            If pItemVenta.Load(pDetalle.CodigoProducto) Then
                sUnidad = pItemVenta.Unidad
            Else
                sUnidad = ""
            End If
            
            isOk = pProcesador.AddDetalle(pDetalle.CodigoProducto, _
                pDetalle.Descripcion, _
                sUnidad, _
                pDetalle.Cantidad, _
                pItemVenta.Precio(1), _
                pDetalle.PrecioUnitario, _
                colSeriales.SerialesRenglon(pDetalle.RefSerial))
                
            If Not isOk Then Exit For
        Next
        Set pItemVenta = Nothing
    End If

    If isOk Then
        pProcesador.TerminarProceso True
        dbHandle.Execute "UPDATE rwsOrdenesTrabajo SET Estado = 4, Factura = " & pFactura.Numero & " WHERE Numero = " & Me.Numero, dbFailOnError
        pEquipo.SetEstado pEquipo.TipoEquipo, pEquipo.Serial, 4
    Else
        pProcesador.AbortarProceso
    End If
        
ResumePoint:
    
    inProcess = False

    Set colSeriales = Nothing
    Set pFactura = Nothing
    Set pVendedor = Nothing
    Set pCliente = Nothing
    Set pEquipo = Nothing
    Set colDetalles = Nothing

    Facturar = isOk
    Exit Function

ErrHandler:
    
    ReportarError True, Err.Number, Err.Description, "clsOrdenRWS::Facturar"
    If inProcess Then pFactura.AbortProcess
    isOk = False
    Resume ResumePoint

End Function

Public Function ActualizarDiagnostico(lNumero As Long, sDiagnostico As String) As Boolean
Dim isOk As Boolean

    isOk = True
    On Error GoTo ErrHandler
    dbHandle.Execute "UPDATE rwsOrdenesTrabajo SET Sintomas = " & StringDB(sDiagnostico) & " WHERE Numero = " & lNumero, dbFailOnError

ResumePoint:
    ActualizarDiagnostico = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsOrdenRWS::ActualizarDiagnostico"
    isOk = False
    Resume ResumePoint

End Function

Public Function ActualizarNotas(lNumero As Long, sNotas As String) As Boolean
Dim isOk As Boolean

    isOk = True
    On Error GoTo ErrHandler
    dbHandle.Execute "UPDATE rwsOrdenesTrabajo SET Notas = " & StringDB(sNotas) & " WHERE Numero = " & lNumero, dbFailOnError

ResumePoint:
    ActualizarNotas = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsOrdenRWS::ActualizarNotas"
    isOk = False
    Resume ResumePoint

End Function

Public Function Equipo() As clsEquipo
Dim pEquipo As clsEquipo

    Set pEquipo = New clsEquipo
    If Not pEquipo.Load(Me.TipoEquipo, Me.Serial) Then
        Set pEquipo = Nothing
    End If

    Set Equipo = pEquipo

End Function

Public Function Vendedor() As clsVendedores
Dim pVendedor As clsVendedores

    Set pVendedor = New clsVendedores
    If Not pVendedor.Load(Me.Tecnico) Then
        Set pVendedor = Nothing
    End If
    Set Vendedor = pVendedor

End Function

Public Function pFactura() As clsFacturas
Dim lpFactura As clsFacturas

    Set lpFactura = New clsFacturas
    If Not lpFactura.Load(Me.Factura) Then
        Set lpFactura = Nothing
    End If
    
    Set pFactura = lpFactura

End Function

Public Function ValorReparacion() As Currency
Dim colDetalles As Collection, pDetalle As clsDetalleOrdenRWS
Dim vAcum As Currency

    Set colDetalles = Me.Detalles
    vAcum = 0
    For Each pDetalle In colDetalles
        vAcum = vAcum + pDetalle.PrecioTotal
    Next
    Set pDetalle = Nothing
    Set colDetalles = Nothing

    ValorReparacion = vAcum

End Function

Public Function ValorImpuesto(nImpuesto As Integer) As Currency
Dim colDetalles As Collection, pDetalle As clsDetalleOrdenRWS
Dim vAcum As Currency, pItemVenta As clsItemVenta

    Set colDetalles = Me.Detalles
    vAcum = 0
    Set pItemVenta = New clsItemVenta
    For Each pDetalle In colDetalles
        If pItemVenta.Load(pDetalle.CodigoProducto) Then
            vAcum = vAcum + pDetalle.PrecioTotal * pItemVenta.PorcentajeImpuesto(nImpuesto) / 100#
        End If
    Next
    Set pDetalle = Nothing
    Set pItemVenta = Nothing
    Set colDetalles = Nothing

    ValorImpuesto = vAcum
            
End Function
