VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsNotasDCCP"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' NotasDCCP = Notas de Dbito o Crdito a Clientes o Proveedores
' Ampliado para aplicarse a Vendedores y otras entidades conformes
' con ISPC/ISDOC

' Campos de la B.D.
Public Numero As Long
Public TipoEntidadRel As String
Public CodigoEntidadRel As String
Public FechaDoc As Date
'Public Descripcion As String  (movida a ISDOC)
Public Monto As Currency
Public Saldo As Currency
Public Operador As String

' Variables locales (declaradas pblicas para comodidad)
Public pComprobante As clsBufferComprobante

' =====================================
' =====         BEGIN ISDOC       =====
' =====================================
' Variables pblicas (ISDOC)
Public TipoEntidad As String
Public Descripcion As String

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Sub LoadInstance(rs As Recordset, Optional pDest As clsNotasDCCP = Nothing)
Dim dest As clsNotasDCCP
  Set dest = pDest
  If dest Is Nothing Then Set dest = Me
  With dest
    .Numero = rs.Fields("Numero")
    .TipoEntidadRel = rs.Fields("TipoEntidad")
    .CodigoEntidadRel = rs.Fields("CodigoEntidad")
    .FechaDoc = rs.Fields("FechaDoc")
    .Descripcion = rs.Fields("Descripcion")
    .Monto = rs.Fields("Monto")
    .Saldo = rs.Fields("Saldo")
    .Operador = stGetStringFromVariant(rs.Fields("Operador"))
  End With
End Sub

Public Function Load(lNumDoc As Long) As Boolean
Dim rs As Recordset, sqlQuery As String, bRetVal As Boolean

    On Error GoTo ErrHandler
    sqlQuery = "SELECT * FROM NotasDCCP WHERE Numero =" & Str(lNumDoc)
    Set rs = dbHandle.Execute(sqlQuery, , adCmdText)

    If rs.EOF Then
        bRetVal = False
    Else
        bRetVal = True
        LoadInstance rs, Me
    End If

ResumePoint:
    If Not rs Is Nothing Then
        rs.Close
        Set rs = Nothing
    End If

    Load = bRetVal
    
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "NotasDCPP.Load"
    Err.Clear
    bRetVal = False
    Resume ResumePoint
    
End Function

Public Property Get Referencia() As String
Dim stRetVal As String

    If Monto < 0 Then stRetVal = "NC" Else stRetVal = "ND"
    stRetVal = stRetVal & TipoEntidadRel
    stRetVal = stRetVal & Format(Numero, "0000000")
    
    Referencia = stRetVal

End Property

' Aunque las notas son documentos sin detalles, en esta
' coleccin se pasan las transacciones que hayan afectado
' su saldo...
Public Function Concepto() As String
        
    Concepto = Descripcion

End Function

Public Function NombreArchivoFormato() As String
Dim sLocal As String

    sLocal = "FormatoNotasDC" & Me.TipoEntidadRel & ".txt"
    NombreArchivoFormato = DeterminarFormato("FormatoNotaDC" & Me.TipoEntidadRel, "FormatosNotaDC" & Me.TipoEntidadRel, BuildDataPath(sLocal, AppName), Me)

End Function

Public Function Detalles() As Collection
Dim pDoc As clsDocumentosISPC, retCol As Collection

    Set pDoc = New clsDocumentosISPC
    If Not pDoc.LoadFromDocumento(Me.TipoEntidad, Me.Numero) Then
        Set retCol = Nothing
    Else
        Set retCol = pDoc.Detalles
    End If
    Set pDoc = Nothing

    Set Detalles = retCol

End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evNDC" & Me.TipoEntidadRel & ".vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, v, s) As Boolean
Dim bRetVal As Boolean
Dim pInstancer As clsInstanciadorEntidad, pEntidad As Object

  bRetVal = True
  Set pInstancer = New clsInstanciadorEntidad
  
  Select Case sVarId
  
  Case "NUMERO"
    v = Me.Numero
    s = Format(Me.Numero, "0000000")
  
  Case "DESCRIPCION", "CONCEPTO"
    v = Me.Descripcion
    s = Me.Descripcion
  
  Case "FECHA"
    v = Me.FechaDoc
    s = Format(Me.FechaDoc, "Short Date")
  
  Case "MONTO"
    v = Me.Monto
    s = FormatNumero(Me.Monto, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  
  Case "SALDO"
    v = Me.Saldo
    s = FormatNumero(Me.Saldo, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
    
  Case "OPERADOR"
    v = Me.Operador
    s = Me.Operador
  
  Case "CODIGO"
    v = Me.CodigoEntidadRel
    s = Me.CodigoEntidadRel
  
  Case "TIPOENTIDAD"
    s = pInstancer.NombreEntidadISPC(Me.TipoEntidadRel, False)
    v = s
  
  Case "NOMBRE"
    Set pEntidad = pInstancer.EntidadPersonaComercial(Me.TipoEntidadRel, Me.CodigoEntidadRel)
    s = pEntidad.Nombre
    v = s
    Set pEntidad = Nothing
  
  Case Else
    bRetVal = False
  End Select
    
  If Not bRetVal Then
    bRetVal = Empresa.EvalVar(sVarId, v, s)
  End If
        
  If Not bRetVal Then
    Set pEntidad = pInstancer.EntidadPersonaComercial(Me.TipoEntidadRel, Me.CodigoEntidadRel)
    On Error Resume Next
    v = CallByName(pEntidad, sVarId, VbGet)
    If Err.Number <> 0 Then
      Err.Clear
    Else
      s = v
      bRetVal = True
    End If
  End If
        
  If Not bRetVal Then bRetVal = ExtendEval(sVarId, v, s)
    
  EvalVar = bRetVal

End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String

    bRetVal = EvalVar(sVarId, vBuf, sBuf)
    GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)
    
End Function

Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim lRef As Long

    lRef = Val(Mid(sRef, 6, 10))
    LoadByReferenciaISDOC = Load(lRef)
    
End Function

Public Sub Show()
Dim f As frmViewNDC

    Set f = New frmViewNDC
    f.SetNota Me
    
    ShowNonModal f
    
    Unload f
    Set f = Nothing

End Sub

Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
    
    Set cFormato = New CFormatoDocumento
    cFormato.SetDocumento Me, Not AutoPrint
    Set cFormato = Nothing

End Sub
' ==========================================
' =========        END ISDOC     ===========
' ==========================================

' ==============================
' ===     ISDOC / DocISPC    ===
' ==============================
Public Function RegistrarVariacion(vmMonto As Currency, pComprobante As clsBufferComprobante) As Boolean
Dim rs As Recordset, bRetVal As Boolean

  dbHandle.Execute "UPDATE NotasDCCP SET Saldo = Saldo + (" & NumeroDB(vmMonto) & ") WHERE Numero = " & NumeroDB(Me.Numero)
  RegistrarVariacion = True

End Function
' ==============================
' ===   END ISDOC / DocISPC  ===
' ==============================

Private Sub Class_Initialize()

    TipoEntidad = "NDC"

End Sub

'---------------------------------------------------------------------------------------
' Function StartProcess
' Fecha/Hora: 13/03/03 23:27
' Funcin   : Inicia el proceso de una nota de crdito.
'             Revisada en la fecha indicada para incluir manejo de errores
'---------------------------------------------------------------------------------------
'
Public Function StartProcess(stTipoEntidad As String, _
                             stCodigoEntidad As String, _
                             dtFechaOperacion As Date, _
                             stDescripcion As String, _
                             vmMonto As Currency, _
                             doAutoApply As Boolean) As Boolean
Dim pDoc As clsDocumentosISPC, lRetVal As Long
Dim bRetVal As Boolean

  On Error GoTo ErrHandler
  
  bRetVal = True
  
  Set pComprobante = New clsBufferComprobante
  pComprobante.StartComprobante dtFechaOperacion, Me.TipoEntidad & Me.Referencia, stDescripcion
  Numero = Contadores.NumeroProximoDocumento(Me.TipoEntidad, True)
  
  Dim sQuery As String
  sQuery = "INSERT INTO NotasDCCP (Numero, TipoEntidad, CodigoEntidad, FechaDoc, Descripcion, Monto, Saldo, Operador) VALUES ("
  sQuery = sQuery & NumeroDB(Numero) & ", "
  sQuery = sQuery & StringDB(stTipoEntidad) & ", "
  sQuery = sQuery & StringDB(stCodigoEntidad) & ", "
  sQuery = sQuery & FechaDB(dtFechaOperacion) & ", "
  sQuery = sQuery & StringDB(stDescripcion) & ", "
  sQuery = sQuery & NumeroDB(vmMonto) & ", 0, "
  sQuery = sQuery & StringDB(UsuarioActivo.Codigo) & ");"
  dbHandle.Execute sQuery

  With Me
  .TipoEntidadRel = stTipoEntidad
  .CodigoEntidadRel = stCodigoEntidad
  .Descripcion = stDescripcion
  .FechaDoc = dtFechaOperacion
  .Monto = vmMonto
  .Saldo = vmMonto
  .Operador = UsuarioActivo.Codigo
  End With
  
  pComprobante.SetReferencia Me.TipoEntidad & Me.Referencia

  If stTipoEntidad <> "VND" Then  ' No hay control "Documental" para los vendedores
      Set pDoc = New clsDocumentosISPC
      pDoc.CreateNewDoc stTipoEntidad, stCodigoEntidad, Numero, Me.TipoEntidad, dtFechaOperacion, vmMonto, stDescripcion, pComprobante
      If doAutoApply Then pDoc.AutoAplicar dtFechaOperacion, pComprobante
      Set pDoc = Nothing
  Else
      Dim pDet As clsDetalleCuentaEntidad
      Set pDet = New clsDetalleCuentaEntidad
      pDet.Add 0, stCodigoEntidad, stTipoEntidad, dtFechaOperacion, stDescripcion, vmMonto, pComprobante
      Set pDet = Nothing
  End If

ResumePoint:
  StartProcess = bRetVal
  Exit Function

ErrHandler:
Dim ErrN As Long, ErrD As String
  ErrN = Err.Number: ErrD = Err.Description
  Err.Raise 10001, "clsNotasDCCP::StartProcess", ErrD & " (" & ErrN & ")"
  bRetVal = False
  Resume ResumePoint

End Function

Public Function EndProcess(Optional Doc As CDocumentoFiscal = Nothing) As Boolean
Dim ent As Object, inst As New clsInstanciadorEntidad
  Set ent = inst.EntidadPersonaComercial(Me.TipoEntidadRel, Me.CodigoEntidadRel)
  If ent Is Nothing Then
    Err.Raise 10001, "clsNotasDCCP:EndProcess", "Entidad invalida"
  End If
  If Not Doc Is Nothing Then
    Doc.TipoDoc = Me.TipoEntidad
    Doc.NumeroDoc = Me.Numero
    Doc.Grabar New CFactoria
' No hay un comprobante "automatico" (como ocurre en compras/ventas/devoluciones)
' de manera que no va (creo) el llenado del comprobante (viene lleno de la UI)
'    Doc.FillComprobante Empresa, Me.pComprobante
' Esto implica que el comprobante se llene por completo tambien en otros componentes
' que generan NotasDCCP (Devoluciones de compras y de ventas)
    If Doc.Retencion <> 0 Then
      Dim pDetalle As New clsDetalleCuentaEntidad, pDoc As clsDocumentosISPC
      Set pDoc = New clsDocumentosISPC
      If pDoc.LoadFromDocumento(Me.TipoEntidad, Me.Numero) Then
        pDetalle.Add pDoc.Numero, Me.CodigoEntidadRel, Me.TipoEntidadRel, Me.FechaDoc, "Retencion de IVA en " & Doc.TipoDoc & " " & Doc.Referencia, (Doc.CRRetencion - Doc.DBRetencion), Nothing   ' Me.pComprobante
      End If
    End If
  End If

  If Not pComprobante Is Nothing Then pComprobante.Procesar
  SubmitDoc Me
  EndProcess = True
End Function

Public Function AbortProcess() As Boolean

  AbortProcess = True

End Function

Public Function NotificarDescuento(ivmMonto As Currency, pComprobante As clsBufferComprobante, dtFecha As Date) As Boolean
  pComprobante.AddDetalle Empresa.CuentaDescuentosCobranza, "Descuento en cobro de " & Me.Referencia, ivmMonto, 0
End Function

