VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsNNEESuplemento"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Numero As Long
Public NumeroNota As Long
Public FechaRegistro As Date
Public Operador As String
Public FechaTransaccion As Date
Public CodigoCliente As String
Public Descripcion As String
Public Impuesto1 As Currency
Public Impuesto2 As Currency
Public Valor As Currency      ' Siempre son reducciones del saldo de la nota.
Public TipoDocRel As String   ' Temporalmente, FCT o VOID
Public NumeroDocRel As Long   ' Eso... numero del documento relacionado

Private nNextDetalle As Integer
Private isError As Boolean

'---------------------------------------------------------------------------------------
' Procedure : LoadInstance
' DateTime  : 09/06/03 11:43
' Author    : Leonardo Azpurua
' Purpose   : Copia del recordset a la instancia de destino
'---------------------------------------------------------------------------------------
Public Sub LoadInstance(rs As Recordset, Optional pDest As clsNNEESuplemento = Nothing)
Dim lDest As clsNNEESuplemento

  On Error GoTo ErrHandler

  Set lDest = pDest
  If lDest Is Nothing Then Set lDest = Me
  With lDest
  .Numero = GetNumeroFromVariant(rs.Fields("Numero"))
  .NumeroNota = GetNumeroFromVariant(rs.Fields("NumeroNota"))
  .FechaRegistro = GetDateFromVariant(rs.Fields("FechaRegistro"))
  .Operador = GetStringFromVariant(rs.Fields("Operador"))
  .FechaTransaccion = GetDateFromVariant(rs.Fields("FechaTransaccion"))
  .CodigoCliente = GetStringFromVariant(rs.Fields("CodigoCliente"))
  .Descripcion = GetStringFromVariant(rs.Fields("Descripcion"))
  .Impuesto1 = GetNumeroFromVariant(rs.Fields("Impuesto1"))
  .Impuesto2 = GetNumeroFromVariant(rs.Fields("Impuesto2"))
  .Valor = GetNumeroFromVariant(rs.Fields("Valor"))
  .TipoDocRel = GetStringFromVariant(rs.Fields("TipoDocRel"))
  .NumeroDocRel = GetNumeroFromVariant(rs.Fields("NumeroDocRel"))
  End With

ResumePoint:

 Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long

  sErrD = Err.Description: nErrN = Err.Number
  ReportarError False, nErrN, sErrD, "clsNNEESuplemento::LoadInstance"
  Resume ResumePoint
End Sub

'---------------------------------------------------------------------------------------
' Procedure : StartProcess
' DateTime  : 09/06/03 12:31
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Public Sub StartProcess()
Dim sQuery As String, rs As Recordset

  On Error GoTo ErrHandler

  StartTransaction
  
  sQuery = "INSERT INTO NNEESuplemento (NumeroNota, FechaRegistro, Operador, FechaTransaccion, CodigoCliente, Descripcion, TipoDocRel, NumeroDocRel) VALUES ("
  sQuery = sQuery & NumeroDB(Me.NumeroNota) & ", "
  sQuery = sQuery & TimeDateDB(Now) & ", "
  sQuery = sQuery & StringDB(Me.Operador) & ", "
  sQuery = sQuery & FechaDB(Me.FechaTransaccion) & ", "
  sQuery = sQuery & StringDB(Me.CodigoCliente) & ", "
  sQuery = sQuery & StringDB(Me.Descripcion) & ", "
  sQuery = sQuery & StringDB(Me.TipoDocRel) & ", "
  sQuery = sQuery & NumeroDB(Me.NumeroDocRel) & ");"
  dbHandle.Execute sQuery
  
  Set rs = dbHandle.Execute("SELECT @@Identity AS Numero")
  If rs.EOF Then
    Me.Numero = 0
  End If
  Me.Numero = GetNumeroFromVariant(rs.Fields("Numero"))
  rs.Close
  Set rs = Nothing

  If Me.Numero = 0 Then
    Err.Raise 10001, "clsNNEESuplemento::StartProcess", "Imposible obtener el nmero del nuevo registro"
    Exit Sub
  End If

  Me.Valor = 0
  Me.Impuesto1 = 0
  Me.Impuesto2 = 0
  nNextDetalle = 1
ResumePoint:

 On Error GoTo 0
 Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long

  sErrD = Err.Description: nErrN = Err.Number
  ReportarError False, nErrN, sErrD, "clsNNEESuplemento::StartProcess"
  isError = True
  Resume ResumePoint

  
End Sub

'---------------------------------------------------------------------------------------
' Procedure : AgregarDetalle
' DateTime  : 09/06/03 12:18
' Author    : Leonardo Azpurua
' Purpose   : Agrega un detalle al suplemento.
'             Actualiza el saldo del detalle corrspondiente en la NE
'---------------------------------------------------------------------------------------
Public Function AgregarDetalle( _
            ByVal nDetalle As Integer, _
            istrCodigo As String, _
            ByVal idCantidad As Double, _
            istrUnidad As String, _
            ByVal idFactorEmpaque As Double, _
            ByVal ivmPrecioEfectivo As Currency, _
            ByVal idImpuesto1 As Double, _
            ByVal idImpuesto2 As Double) As Boolean
Dim sQuery As String, bRetVal As Boolean

  If isError Then
    AgregarDetalle = False
    Exit Function
  End If

  On Error GoTo ErrHandler

  bRetVal = True
  sQuery = "INSERT INTO NNEEDetalleSuplemento (NumeroDocumento, Renglon, NumeroRenglonOrigen, CodigoItem, Cantidad, Presentacion, FactorPresentacion, PrecioNeto, Impuesto1, Impuesto2) VALUES ("
  sQuery = sQuery & NumeroDB(Me.Numero) & ", "
  sQuery = sQuery & NumeroDB(nNextDetalle) & ", "
  sQuery = sQuery & NumeroDB(nDetalle) & ", "
  sQuery = sQuery & StringDB(istrCodigo) & ", "
  sQuery = sQuery & NumeroDB(idCantidad) & ", "
  sQuery = sQuery & StringDB(istrUnidad) & ", "
  sQuery = sQuery & NumeroDB(idFactorEmpaque) & ", "
  sQuery = sQuery & NumeroDB(ivmPrecioEfectivo) & ", "
  sQuery = sQuery & NumeroDB(idImpuesto1) & ", "
  sQuery = sQuery & NumeroDB(idImpuesto2) & ");"
  dbHandle.Execute sQuery
  
  nNextDetalle = nNextDetalle + 1
  
  sQuery = "UPDATE NNEEDetalles SET SaldoCantidad = SaldoCantidad - (" & NumeroDB(idCantidad * idFactorEmpaque) & " / FactorEmpaque) WHERE NumeroDocumento = " & NumeroDB(Me.NumeroNota) & " AND Renglon = " & NumeroDB(nDetalle) & ";"
  dbHandle.Execute sQuery
  
  Me.Valor = Me.Valor + idCantidad * ivmPrecioEfectivo
  Me.Impuesto1 = Me.Impuesto1 + (idCantidad * ivmPrecioEfectivo) / 100 * idImpuesto1
  Me.Impuesto2 = Me.Impuesto2 + (idCantidad * ivmPrecioEfectivo) / 100 * idImpuesto2

ResumePoint:

  AgregarDetalle = bRetVal
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long

  sErrD = Err.Description: nErrN = Err.Number
  bRetVal = False: isError = True
  ReportarError False, nErrN, sErrD, "clsNNEESuplemento::AgregarDetalle"
  Resume ResumePoint

End Function


'---------------------------------------------------------------------------------------
' Procedure : EndProcess
' DateTime  : 09/06/03 12:51
' Author    : Leonardo Azpurua
' Purpose   :
'---------------------------------------------------------------------------------------
'
Public Sub EndProcess()
Dim sQuery As String, rs As Recordset, dSaldo As Double

  On Error GoTo ErrHandler

  If isError Then
    AbortTransaction
    Exit Sub
  End If
  
  sQuery = "UPDATE NNEESuplemento SET Valor = " & NumeroDB(Valor) & ", "
  sQuery = sQuery & "Impuesto1 = " & NumeroDB(Impuesto1) & ", "
  sQuery = sQuery & "Impuesto2 = " & NumeroDB(Impuesto2) & " "
  sQuery = sQuery & "WHERE Numero = " & NumeroDB(Me.Numero) & ";"
  dbHandle.Execute sQuery

  sQuery = "SELECT SUM(SaldoCantidad)As UnidadesPendientes FROM NNEEDetalles WHERE NumeroDocumento = " & NumeroDB(Me.NumeroNota) & " AND CodigoItem <> '';"
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    dSaldo = 0
  Else
    dSaldo = GetNumeroFromVariant(rs.Fields("UnidadesPendientes"))
  End If
  rs.Close
  Set rs = Nothing

  If dSaldo = 0 Then
    sQuery = "UPDATE NNEE SET Estado = 1 WHERE Numero = " & NumeroDB(Me.NumeroNota)
    dbHandle.Execute sQuery
  End If

  CommitTransaction

ResumePoint:
  Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  AbortTransaction
  ReportarError False, nErrN, sErrD, "clsNNEESuplemento::EndProcess"
  Resume ResumePoint
End Sub
