VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsNNEEDetalles"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public NumeroDocumento As Long      ' Numero de la factura
Public Renglon As Integer           ' Numero del renglon (0..32767)
Public CodigoItem As String         ' Cdigo del item (puede estar en blanco)
Public Descripcion As String        ' Descripcion del item
Public Presentacion As String       ' Tipo de presentacion UNIDAD | itemVenta(CodigoItem).Presentacion
Public FactorEmpaque As Double      ' Cantidad de unidades por empaque
Public Cantidad As Double           ' Cantidad de unidades
Public PrecioLista As Currency      ' Precio de lista del producto
Public PrecioVenta As Currency      ' Precio de venta  (como debi aparecer en la edicin del detalle)
Public PrecioEfectivo As Currency   ' Precio TOTAL final (incluyendo descuentos globales y pronto pago). Unitario = Efectivo / Cantidad
Public Impuesto1 As Double          ' Porcentaje del impuesto aplicado
Public Impuesto2 As Double          ' Segundo porcentaje de impuesto aplicado.
Public CostoUnitario As Currency    ' Costo unitario (standard)
Public SaldoCantidad As Double      ' Cantidad de unidades PENDIENTES [Cantidad - (Devueltas + Facturadas)]

' Acumuladores para los Detalles de Factura (u otros usos generales)
Public AcumPLista As Currency, _
       AcumPVenta As Currency, _
       AcumPFinal As Currency, _
       NumeroProducto As Long
' Estos campos solamente son accesibles cuando el registro se toma de la coleccion "Detalles"
' de una factura. Se usan para sub-totalizar a efectos de impresion

Public isSerial As Boolean
' Los seriales se muestran como lneas adicionales de descripcin.
' Los detalles generados para mostrar los seriales no deben ser tomados
' en cuenta a efectos de la carga de renglones para la modificacin de
' las facturas. La propiedad "isSerial" se agregar para permitir la
' discriminacin.


Public Sub LoadInstance(rs As Recordset, Optional pDest As clsNNEEDetalles = Nothing)
Dim lpDest As clsNNEEDetalles

    Set lpDest = pDest
    If lpDest Is Nothing Then Set lpDest = Me
    With lpDest
    .NumeroDocumento = GetNumeroFromVariant(rs.Fields("NumeroDocumento"))
    .Renglon = GetNumeroFromVariant(rs.Fields("Renglon"))
    .CodigoItem = GetStringFromVariant(rs.Fields("CodigoItem"))
    .Descripcion = GetStringFromVariant(rs.Fields("Descripcion"))
    .Presentacion = GetStringFromVariant(rs.Fields("Presentacion"))
    .FactorEmpaque = GetNumeroFromVariant(rs.Fields("FactorEmpaque"))
    .Cantidad = GetNumeroFromVariant(rs.Fields("Cantidad"))
    .PrecioLista = GetNumeroFromVariant(rs.Fields("PrecioLista"))
    .PrecioVenta = GetNumeroFromVariant(rs.Fields("PrecioVenta"))
    .PrecioEfectivo = GetNumeroFromVariant(rs.Fields("PrecioEfectivo"))
    .Impuesto1 = GetNumeroFromVariant(rs.Fields("Impuesto1"))
    .Impuesto2 = GetNumeroFromVariant(rs.Fields("Impuesto2"))
    .CostoUnitario = GetNumeroFromVariant(rs.Fields("CostoUnitario"))
    .SaldoCantidad = GetNumeroFromVariant(rs.Fields("SaldoCantidad"))
    End With

End Sub

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evDetalleNE.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean
Dim pItemVenta As clsItemVenta

    bRetVal = True
    
    Select Case sVarId

    Case "SUBTOT_PLISTA"
        sRetString = FormatNumero(AcumPLista, Empresa.MascaraMonetarios, Len(Empresa.MascaraPrecios))
        vRetBuffer = AcumPLista

    Case "SUBTOT_PVENTA"
        sRetString = FormatNumero(AcumPVenta, Empresa.MascaraMonetarios, Len(Empresa.MascaraPrecios))
        vRetBuffer = AcumPVenta

    Case "SUBTOT_PFINAL"
        sRetString = FormatNumero(AcumPFinal, Empresa.MascaraMonetarios, Len(Empresa.MascaraPrecios))
        vRetBuffer = AcumPFinal

    Case "NITEM"
        sRetString = FormatNumero(NumeroProducto, "##0", 3)
        vRetBuffer = NumeroProducto

    Case "CODIGO", "CODIGO_PRODUCTO", "CODIGO_ITEM"
        sRetString = CodigoItem
        vRetBuffer = sRetString
    
    Case "DESCRIPCION"
        sRetString = Descripcion
        vRetBuffer = sRetString

    Case "PRESENTACION"
        sRetString = Presentacion
        vRetBuffer = sRetString

    Case "FACTOR_EMPAQUE"
        vRetBuffer = FactorEmpaque
        sRetString = Trim(FormatNumero(FactorEmpaque, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades)))

    Case "CANTIDAD"
        vRetBuffer = Cantidad
        sRetString = Trim(FormatNumero(Cantidad, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades)))

    Case "PRECIO_LISTA"
        vRetBuffer = PrecioLista
        sRetString = Trim(FormatNumero(PrecioLista, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_LISTA_UNITARIO"
        If FactorEmpaque <> 0 Then
            vRetBuffer = PrecioLista / FactorEmpaque
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_VENTA"
        vRetBuffer = PrecioVenta
        sRetString = Trim(FormatNumero(PrecioVenta, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_VENTA_UNITARIO"
        If FactorEmpaque <> 0 Then
            vRetBuffer = PrecioVenta / FactorEmpaque
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_EFECTIVO"
        If Cantidad <> 0 Then
            vRetBuffer = PrecioEfectivo / Cantidad
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_EFECTIVO_UNITARIO"
        If Cantidad <> 0 Then
            vRetBuffer = PrecioEfectivo / Cantidad / FactorEmpaque
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "TOTAL_RENGLON"
        vRetBuffer = PrecioEfectivo
        sRetString = Trim(FormatNumero(PrecioEfectivo, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "TOTAL_PLISTA"
        vRetBuffer = PrecioLista * Cantidad
        sRetString = Trim(FormatNumero(PrecioLista * Cantidad, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))
    
    Case "TOTAL_PVENTA"
        vRetBuffer = PrecioVenta * Cantidad
        sRetString = Trim(FormatNumero(PrecioVenta * Cantidad, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))
    
    Case Else
        
        bRetVal = False
        Set pItemVenta = AlmacenItemsVenta.ItemVenta(Me.CodigoItem)
        If Not pItemVenta Is Nothing Then
            bRetVal = pItemVenta.EvalVar(sVarId, vRetBuffer, sRetString)
            Set pItemVenta = Nothing
        End If
        
        If Not bRetVal Then
            bRetVal = ExtendEval(sVarId, vRetBuffer, sRetString)
        End If
    
    End Select
    
    EvalVar = bRetVal

End Function

Public Function Descuento() As Double
Dim dblTemp As Double
    If PrecioLista = 0 Then
        Descuento = 0
        Exit Function
    End If
    dblTemp = PrecioLista - PrecioVenta
    dblTemp = dblTemp / PrecioLista
    dblTemp = dblTemp * 100
    Descuento = dblTemp
End Function

Public Property Get PrecioTotal() As Double
    
    PrecioTotal = PrecioVenta * Cantidad

End Property

Public Function PrecioEfectivoUnitario() As Double
    
    If FactorEmpaque = 0 Then
        PrecioEfectivoUnitario = 0
    Else
        PrecioEfectivoUnitario = PrecioEfectivo / FactorEmpaque ' / Cantidad
    End If

End Function

Public Function CantidadEfectiva() As Double
    
    CantidadEfectiva = Cantidad * FactorEmpaque

End Function

Public Function Neto() As Double

    Neto = PrecioEfectivo / Cantidad

End Function

Public Function NetoUnitario() As Double

    NetoUnitario = PrecioEfectivo / Cantidad / FactorEmpaque

End Function

