VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsNNEE"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Numero As Long
Public FechaRegistro As Date        ' Fecha de registro de la factura
Public FechaTransaccion As Date     ' Fecha de la transaccin
Public Operador As String           ' Codigo del operador que cre la factura
Public CodigoCliente As String      ' Cdigo del cliente
Public NombreCliente As String      ' Nombre del cliente
Public CodigoVendedor As String     ' Cdigo del Vendedor
Public Estado As Integer            ' 0: Abierta; 1: Facturada; 2:Cancelada
Public PrecioLista As Currency      ' Valor de la factura a precio de Lista
Public PrecioVenta As Currency      ' Valor de la factura a precio de venta
Public PrecioEfectivo As Currency   ' Precio EFECTIVO de venta.
Public Impuesto1 As Currency        ' Impuesto retenido 1 (IVA)
Public Impuesto2 As Currency        ' Impuesto retenido 2 (??)
Public IndiceReferencia As Integer  ' Indice (selector) del precio de referencia
Public IndiceVenta As Integer       ' Selector del precio de venta
Public Descuento1 As Double         ' Porcentaje del primer descuento global
Public Descuento2 As Double         ' Porcentaje del segundo descuento global
Public Condicion As String          ' Cdigo de la condicion de venta
Public DireccionEntrega As String   ' Direccin de la Entrega
Public Notas As String              ' Notas y comentarios
Public ComprobanteAlmacen As Long   ' Nmero del comprobante de almacn
Public NumeroFacturaOrigen          ' En caso de que se implementen para "despachar" facturas ...
Public SaldoActual As Currency      ' Saldo actual de la nota (menos devueltas + facturadas)

' **********************************************
' Funciones y mtodos y miembros Standard ISDOC:
' **********************************************
Public pEvaluadorVariable As CExpEvalDocVenta
Public pComprobante As clsBufferComprobante
Public Saldo As Currency

Private NextDetalle As Long
Private inProcess As Boolean, stAlmacen As String
Private pComprobanteAlmacen As clsComprobanteAlmacen
Private pItemVenta As clsItemVenta, _
        pItemInv As clsItemInventario
Private rsIterador As Recordset

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Property Get Correlativo() As Long
  Correlativo = Me.Numero
End Property

Public Property Get TipoEntidad() As String              ' Idntificacin para ISDOC
  TipoEntidad = "NDE"
End Property

Public Sub LoadInstance(pInstance As clsNNEE, rsHandle As Recordset)
  With rsHandle
  pInstance.Numero = .Fields("Numero")
  pInstance.FechaRegistro = .Fields("FechaRegistro")
  pInstance.FechaTransaccion = .Fields("FechaTransaccion")
  pInstance.Operador = .Fields("Operador")
  pInstance.CodigoCliente = .Fields("CodigoCliente")
  pInstance.NombreCliente = .Fields("NombreCliente")
  pInstance.CodigoVendedor = .Fields("CodigoVendedor")
  pInstance.Estado = .Fields("Estado")
  pInstance.PrecioLista = .Fields("PrecioLista")
  pInstance.PrecioVenta = .Fields("PrecioVenta")
  pInstance.PrecioEfectivo = .Fields("PrecioEfectivo")
  pInstance.Impuesto1 = .Fields("Impuesto1")
  pInstance.Impuesto2 = .Fields("Impuesto2")
  pInstance.IndiceReferencia = .Fields("IndiceReferencia")
  pInstance.IndiceVenta = .Fields("IndiceVenta")
  pInstance.Descuento1 = .Fields("Descuento1")
  pInstance.Descuento2 = .Fields("Descuento2")
  pInstance.Condicion = .Fields("Condicion")
  pInstance.DireccionEntrega = .Fields("DireccionEntrega")
  pInstance.ComprobanteAlmacen = GetNumeroFromVariant(.Fields("ComprobanteAlmacen"))
  pInstance.Notas = GetStringFromVariant(.Fields("Notas"))
  pInstance.SaldoActual = GetNumeroFromVariant(.Fields("SaldoActual"))
  pInstance.Saldo = 0
  End With
End Sub

Public Function Descripcion() As String
  Descripcion = NombreCliente
End Function

Public Function Load(Numero As Long) As Boolean
Dim rs As Recordset, bRetVal As Boolean

  On Error GoTo ErrHandler
  Set rs = dbHandle.Execute("SELECT * FROM NNEE WHERE Numero = " & NumeroDB(Numero))
  If rs.EOF Then
    bRetVal = False
  Else
    bRetVal = True
    LoadInstance Me, rs
  End If
  rs.Close

ResumePoint:
  Set rs = Nothing
  Load = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "clsNNEE::Load"
  bRetVal = False
  Resume ResumePoint

End Function

Public Function Referencia() As String
  Referencia = "NDE-" & Format(Numero, "000000")
End Function

Public Function Concepto() As String
Dim stRetVal As String
  Concepto = "Nota de Entrega " & Me.Referencia
End Function

Public Function NombreArchivoFormato() As String
  NombreArchivoFormato = DeterminarFormato("FormatoNE", "FormatosNE", BuildDataPath("FormatoNE.txt", AppName), Me)
End Function

Public Function Detalles() As Collection
Dim colRetVal As Collection, pDetalle As clsNNEEDetalles
Dim rs As Recordset, pSeriales As CSerialesRenglon, vSeriales As Variant
Dim i As Long
Dim NumeroProducto As Long
Dim AcumPLista As Currency, AcumPVenta As Currency, AcumPFinal As Currency

  NumeroProducto = 0
  AcumPLista = 0: AcumPVenta = 0: AcumPFinal = 0

  Set colRetVal = New Collection
  Set rs = dbHandle.Execute("SELECT * FROM NNEEDetalles WHERE NumeroDocumento = " & NumeroDB(Me.Numero) & " ORDER BY Renglon")
  Do While Not rs.EOF
    Set pDetalle = New clsNNEEDetalles
    pDetalle.isSerial = False
    pDetalle.LoadInstance rs
    With pDetalle
      .AcumPLista = AcumPLista
      AcumPLista = AcumPLista + .PrecioLista * .Cantidad
    
      .AcumPVenta = AcumPVenta
      AcumPVenta = AcumPVenta + .PrecioVenta * .Cantidad

      .AcumPFinal = AcumPFinal
      AcumPFinal = AcumPFinal + .PrecioEfectivo
    
      If .CodigoItem <> "" Then
        NumeroProducto = NumeroProducto + 1
        .NumeroProducto = NumeroProducto
      Else
        .NumeroProducto = 0
      End If
    End With

    colRetVal.Add pDetalle
    
    Set pSeriales = New CSerialesRenglon
    pSeriales.Load Me.TipoEntidad, Me.Numero, pDetalle.Renglon
    If pSeriales.SerialesProducto.Count Then
      vSeriales = pSeriales.ToStrings(40)
      For i = 1 To UBound(vSeriales)
        Set pDetalle = New clsNNEEDetalles
        pDetalle.Descripcion = vSeriales(i)
        pDetalle.isSerial = True
        pDetalle.Renglon = 1
        pDetalle.FactorEmpaque = 1
        colRetVal.Add pDetalle
      Next
    End If
    Set pSeriales = Nothing

    rs.MoveNext
  Loop
  rs.Close
  Set rs = Nothing
  Set Detalles = colRetVal

End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant
  bRetVal = mScriptExecute.ExtendEval(Me, "evNNEE.vbs", sVarId, vRetVal)
  If bRetVal Then
    vRetBuffer = vRetVal
    sRetString = vRetVal
  End If
  ExtendEval = bRetVal
End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
  EvalVar = Me.pEvaluadorVariable.EvalVar(sVarId, vRetBuffer, sRetString, Me)
End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String
  bRetVal = EvalVar(sVarId, vBuf, sBuf)
  GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)
End Function

' LoadByRef recibe una "referencia" completa a un documento ISDOC,
' y carga los datos correspondientes en <Me>
' Devuelve True si existe una factura con la referencia recibida
Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim lNumero As Long, sQuery As String, rs As Recordset, bRetVal As Boolean
    
  On Error GoTo ErrHandler

  lNumero = Val(right(sRef, Len(sRef) - 4))
  If lNumero = 0 Then
    LoadByReferenciaISDOC = False
    Exit Function
  End If

  sQuery = "SELECT * FROM NNEE WHERE Numero =" & Str(lNumero)
  Set rs = dbHandle.Execute(sQuery)

  If Not rs.EOF Then
    LoadInstance Me, rs
    bRetVal = True
  Else
    bRetVal = False
  End If
  
ResumePoint:
  If Not rs Is Nothing Then
    rs.Close
    Set rs = Nothing
  End If
  
  LoadByReferenciaISDOC = bRetVal
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "clsNNEE::LoadByRefISDOC"
  Err.Clear
  bRetVal = False
  Resume ResumePoint

End Function

' Show (ISDOC) causa que el documento se presente en una forma de
' consulta...
Public Sub Show()
Dim f As frmConsultarFactura

    Set f = New frmConsultarFactura
    f.LoadNota Me
    ShowNonModal f
    Unload f
    Set f = Nothing

End Sub

Public Function ImagenEstado() As String
  Select Case Me.Estado
  Case 0
    ImagenEstado = "ABIERTA"
  Case 1
    ImagenEstado = "FACTURADA"
  Case 2
    ImagenEstado = "ANULADA"
  Case 3
    ImagenEstado = "DESPACHADA"
  End Select
End Function

' Se presenta y/o imprime el documento
Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
  Set cFormato = New CFormatoDocumento
  cFormato.SetDocumento Me, Not AutoPrint
  Set cFormato = Nothing
End Sub

Public Function NumeroProximaNota() As Long
  NumeroProximaNota = Contadores.NumeroProximoDocumento("NDE", False)
End Function

Private Sub Class_Initialize()
  inProcess = False
  Set pEvaluadorVariable = New CExpEvalDocVenta
End Sub

' Funciones de Proceso

Public Sub StartProcess(istrAlmacen As String)
    NextDetalle = 1
    inProcess = True
    StartTransaction
    stAlmacen = istrAlmacen
    Set pItemInv = New clsItemInventario
    Set pItemVenta = New clsItemVenta
End Sub

Public Sub EndProcess()
  Set pItemVenta = Nothing
  Set pItemInv = Nothing
  CommitTransaction
  ExecuteScript "postNotaEntrega.vbs", Me
  SubmitDoc Me
End Sub

Public Sub AbortProcess()
  Set pItemVenta = Nothing
  Set pItemInv = Nothing
  AbortTransaction
End Sub

Private Sub RevertirDetalles(bEliminar As Boolean)
Dim pDetalle As clsNNEEDetalles
Dim pItemVenta As clsItemVenta, _
    pItemInv As clsItemInventario, _
    pComponente As clsComponenteItemVenta
Dim pCompAlmacen As clsComprobanteAlmacen
Dim pSeriales As CSerialesDocumento

  If ComprobanteAlmacen <> 0 Then
  ' Es probable que una NNEE este formada solamente por servicios,
  ' de modo que comprobante almacen podra ser CERO...
    Set pCompAlmacen = New clsComprobanteAlmacen
    If Not pCompAlmacen.Load(Me.ComprobanteAlmacen) Then
      Err.Raise 1001, "clsNNEE::RevertirDetalles", "Referencia a ComprobanteAlmacen invlido"
      Exit Sub
    End If

    Set pItemVenta = New clsItemVenta
    Set pItemInv = New clsItemInventario
    For Each pDetalle In Me.Detalles
      If pDetalle.CodigoItem <> "" Then
        If pItemVenta.Load(pDetalle.CodigoItem) Then
          For Each pComponente In pItemVenta.Composicion
            If pItemInv.Load(pComponente.CodigoItemInventario) Then
              pCompAlmacen.AgregarMINV ComprobanteAlmacen, pComponente.CodigoItemInventario, pComponente.Cantidad * pDetalle.Cantidad * pDetalle.FactorEmpaque, pItemInv.CostoUnitario
              pComprobante.AddDetalle pItemInv.CuentaActivo, "Reversin de Nota de Entrega No. " & Me.Numero, pItemInv.CostoUnitario * pComponente.Cantidad * pDetalle.Cantidad * pDetalle.FactorEmpaque, 0
              pComprobante.AddDetalle Empresa.CuentaMercanciaTransito, "Reversin de Nota de Entrega No. " & Me.Numero, 0, pItemInv.CostoUnitario * pComponente.Cantidad * pDetalle.Cantidad * pDetalle.FactorEmpaque
            End If
          Next
        End If
      End If
    Next
    Set pCompAlmacen = Nothing
    Set pItemInv = Nothing
    Set pItemVenta = Nothing
  End If

  Set pSeriales = New CSerialesDocumento
  pSeriales.Revertir Me.TipoEntidad, Me.Numero
  Set pSeriales = Nothing                     ' Lista la reversin de seriales... eres la hostia, tio!

  If bEliminar Then
    dbHandle.Execute "DELETE FROM NNEEDetalles WHERE NumeroDocumento = " & NumeroDB(Me.Numero)
  End If
End Sub

Public Sub Update(isNew As Boolean)
Dim sQuery As String

  If Not inProcess Then
    Err.Raise 1001, "clsNNEE::Update", "Llamada a Update sin StartProcess"
  End If

  With Me
  If isNew Then
    If .Numero = 0 Then
      .Numero = Contadores.NumeroProximoDocumento(Me.TipoEntidad, True)
    Else
      Contadores.RegistrarEmisionDocumento Me.TipoEntidad, Me.Numero
    End If
    
    sQuery = "INSERT INTO NNEE (Numero, FechaTransaccion, Operador, CodigoCliente, NombreCliente, CodigoVendedor, PrecioLista, PrecioVenta, "
    sQuery = sQuery & "PrecioEfectivo, Impuesto1, Impuesto2, IndiceReferencia, IndiceVenta, Descuento1, Descuento2, Condicion, DireccionEntrega, Notas, SaldoActual) SELECT "
    sQuery = sQuery & NumeroDB(.Numero) & ", "
    sQuery = sQuery & FechaDB(.FechaTransaccion) & ", "
    sQuery = sQuery & StringDB(.Operador) & ", "
    sQuery = sQuery & StringDB(.CodigoCliente) & ", "
    sQuery = sQuery & StringDB(.NombreCliente) & ", "
    sQuery = sQuery & StringDB(.CodigoVendedor) & ", "
    sQuery = sQuery & NumeroDB(.PrecioLista) & ", "
    sQuery = sQuery & NumeroDB(.PrecioVenta) & ", "
    sQuery = sQuery & NumeroDB(.PrecioEfectivo) & ", "
    sQuery = sQuery & NumeroDB(.Impuesto1) & ", "
    sQuery = sQuery & NumeroDB(.Impuesto2) & ", "
    sQuery = sQuery & NumeroDB(.IndiceReferencia) & ", "
    sQuery = sQuery & NumeroDB(.IndiceVenta) & ", "
    sQuery = sQuery & NumeroDB(.Descuento1) & ", "
    sQuery = sQuery & NumeroDB(.Descuento2) & ", "
    sQuery = sQuery & StringDB(.Condicion) & ", "
    sQuery = sQuery & StringDB(.DireccionEntrega) & ", "
    sQuery = sQuery & StringDB(.Notas) & ", "
    sQuery = sQuery & NumeroDB(.PrecioEfectivo + .Impuesto1 + .Impuesto2) & ";"
  Else
    sQuery = "UPDATE NNEE SET "
    sQuery = sQuery & "FechaTransaccion = " & FechaDB(.FechaTransaccion) & ", "
    sQuery = sQuery & "Operador = " & StringDB(.Operador) & ", "
    sQuery = sQuery & "CodigoCliente = " & StringDB(.CodigoCliente) & ", "
    sQuery = sQuery & "NombreCliente = " & StringDB(.NombreCliente) & ", "
    sQuery = sQuery & "CodigoVendedor = " & StringDB(.CodigoVendedor) & ", "
    sQuery = sQuery & "PrecioLista = " & NumeroDB(.PrecioLista) & ", "
    sQuery = sQuery & "PrecioVenta = " & NumeroDB(.PrecioVenta) & ", "
    sQuery = sQuery & "PrecioEfectivo = " & NumeroDB(.PrecioEfectivo) & ", "
    sQuery = sQuery & "Impuesto1 = " & NumeroDB(.Impuesto1) & ", "
    sQuery = sQuery & "Impuesto2 = " & NumeroDB(.Impuesto2) & ", "
    sQuery = sQuery & "IndiceReferencia = " & NumeroDB(.IndiceReferencia) & ", "
    sQuery = sQuery & "IndiceVenta = " & NumeroDB(.IndiceVenta) & ", "
    sQuery = sQuery & "Descuento1 = " & NumeroDB(.Descuento1) & ", "
    sQuery = sQuery & "Descuento2 = " & NumeroDB(.Descuento2) & ", "
    sQuery = sQuery & "Condicion = " & StringDB(.Condicion) & ", "
    sQuery = sQuery & "DireccionEntrega = " & StringDB(.DireccionEntrega) & ", "
    sQuery = sQuery & "Notas = " & StringDB(.Notas) & ", "
    sQuery = sQuery & "SaldoActual = " & NumeroDB(.PrecioEfectivo + .Impuesto1 + .Impuesto2) & " "
    sQuery = sQuery & "WHERE Numero = " & NumeroDB(.Numero) & ";"
  End If
  End With
  dbHandle.Execute sQuery
  Load Me.Numero

  If Not isNew Then
    RevertirDetalles True
  End If

End Sub

Public Function AddDetalle(istrCodigoItem As String, _
            istrDescripcion As String, _
            istrUnidad As String, _
            idblCantidad As Double, _
            ivmPrecioLista As Currency, _
            ivmPrecioUnitario As Currency) As Long
Dim pDetalle As clsNNEEDetalles
Dim pComponente As clsComponenteItemVenta
Dim sqlQuery As String, lngRetVal As Long

    On Error GoTo ErrHandler

    lngRetVal = NextDetalle
    NextDetalle = NextDetalle + 1
    Set pDetalle = New clsNNEEDetalles
    With pDetalle
    .NumeroDocumento = Me.Numero
    .Renglon = lngRetVal
    .CodigoItem = istrCodigoItem
    .Descripcion = istrDescripcion
    
    If istrCodigoItem <> "" Then
        If pItemVenta.Load(istrCodigoItem) Then
            .Presentacion = istrUnidad
            .Cantidad = idblCantidad
            .SaldoCantidad = idblCantidad
            .PrecioLista = ivmPrecioLista
            .PrecioVenta = ivmPrecioUnitario
            .PrecioEfectivo = ivmPrecioUnitario * (1# - Me.Descuento1 / 100#) * (1# - Me.Descuento2 / 100#)
            .Impuesto1 = TiposImpuesto.ValorActualImpuesto(pItemVenta.TipoImpuesto1)
            .Impuesto2 = TiposImpuesto.ValorActualImpuesto(pItemVenta.TipoImpuesto2)
            .CostoUnitario = pItemVenta.CostoStandard
            .FactorEmpaque = pItemVenta.FactorPresentacion(istrUnidad)
        Else
            Err.Raise 1001, "clsNNEE", "Articulo " & istrCodigoItem & " no localizado."
        End If
    Else
        .Presentacion = ""
        .Cantidad = 0
        .PrecioLista = 0
        .PrecioVenta = 0
        .PrecioEfectivo = 0
        .Impuesto1 = 0
        .Impuesto2 = 0
        .CostoUnitario = 0
        .FactorEmpaque = 1
    End If

    sqlQuery = "INSERT INTO NNEEDetalles (NumeroDocumento, Renglon, CodigoItem, Descripcion, Presentacion, FactorEmpaque, Cantidad, SaldoCantidad, PrecioLista, PrecioVenta, PrecioEfectivo, Impuesto1, Impuesto2, CostoUnitario) SELECT "
    sqlQuery = sqlQuery & NumeroDB(.NumeroDocumento) & ", "
    sqlQuery = sqlQuery & NumeroDB(.Renglon) & ", "
    sqlQuery = sqlQuery & StringDB(.CodigoItem) & ", "
    sqlQuery = sqlQuery & StringDB(.Descripcion) & ", "
    sqlQuery = sqlQuery & StringDB(.Presentacion) & ", "
    sqlQuery = sqlQuery & NumeroDB(.FactorEmpaque) & ", "
    sqlQuery = sqlQuery & NumeroDB(.Cantidad) & ", "
    sqlQuery = sqlQuery & NumeroDB(.Cantidad) & ", "
    sqlQuery = sqlQuery & NumeroDB(.PrecioLista) & ", "
    sqlQuery = sqlQuery & NumeroDB(.PrecioVenta) & ", "
    sqlQuery = sqlQuery & NumeroDB(.PrecioEfectivo) & ", "
    sqlQuery = sqlQuery & NumeroDB(.Impuesto1) & ", "
    sqlQuery = sqlQuery & NumeroDB(.Impuesto2) & ", "
    sqlQuery = sqlQuery & NumeroDB(.CostoUnitario) & ";"

    dbHandle.Execute sqlQuery

    End With

ResumePoint:
    Set pDetalle = Nothing
    AddDetalle = lngRetVal
    Exit Function
    
ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsNNEE::AddDetalle"
    lngRetVal = 0
    Resume ResumePoint

End Function

Public Sub Anular()
Dim bDespachada As Boolean
  
  If Me.Estado Then
    Exit Sub
  End If
  Me.Estado = 2
  dbHandle.Execute "UPDATE NNEE Set Estado = " & NumeroDB(Me.Estado) & " WHERE Numero = " & NumeroDB(Me.Numero) & ";"

End Sub

Private Sub Class_Terminate()
  Set pEvaluadorVariable = Nothing
End Sub

' ---------------------------------
' ITERADOR:
' ---------------------------------
Public Function CancelarIterador()

    If Not rsIterador Is Nothing Then
        rsIterador.Close
        Set rsIterador = Nothing
    End If

End Function

Public Function ProximaNotaIterador() As clsNNEE
Dim pNNEE As clsNNEE

    If rsIterador Is Nothing Then
        Set ProximaNotaIterador = Nothing
        Exit Function
    End If
    
    If rsIterador.EOF Then
        CancelarIterador
        Set ProximaNotaIterador = Nothing
        Exit Function
    End If

    Set pNNEE = New clsNNEE
    
    LoadInstance pNNEE, rsIterador
    rsIterador.MoveNext
    
    Set ProximaNotaIterador = pNNEE

End Function

' -----------------------------
' Iterador 1: Por Cliente
' -----------------------------
Public Function IniciarIteradorCliente(istrCodCli As String, ByVal nEstado As Long) As Boolean
Attribute IniciarIteradorCliente.VB_Description = "Inicia un iterador con las notas de entrega del cliente. Si nEstado < 0 incluye todas las notas del cliente. De lo contrario, solo aquellas donde Estado = nEstado."
Dim sqlQuery As String, isOK As Boolean

    On Error GoTo ErrHandler

    If Not rsIterador Is Nothing Then
        mAdvertencia "Llamada reentrante a IniciarIteradorCliente"
        IniciarIteradorCliente = False
        Exit Function
    End If

    isOK = True
    sqlQuery = "SELECT * FROM NNEE WHERE CodigoCliente = " & StringDB(istrCodCli)
    If nEstado >= 0 Then
      sqlQuery = sqlQuery & " AND Estado = " & NumeroDB(nEstado)
    End If
    sqlQuery = sqlQuery & ";"

    Set rsIterador = dbHandle.Execute(sqlQuery)

    If rsIterador.EOF Then
        rsIterador.Close
        Set rsIterador = Nothing
        isOK = False
    End If

ResumePoint:
    IniciarIteradorCliente = isOK
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsNNEE::IniciarIteradorCliente"
    CancelarIterador
    isOK = False
    Resume ResumePoint
End Function


Public Sub RegistrarFacturacion(pFactura As clsFacturas)
Dim pItemVenta As clsItemVenta, pDetalle As clsNNEEDetalles

  Set pItemVenta = New clsItemVenta
  For Each pDetalle In Me.Detalles
    If pDetalle.CodigoItem <> "" Then
      If pItemVenta.Load(pDetalle.CodigoItem) Then
        pFactura.AddLineaComprobante Empresa.CuentaMercanciaTransito, "Facuracion de Node de Entrega " & Me.Referencia, 0, pItemVenta.CostoStandard * pDetalle.Cantidad * pDetalle.FactorEmpaque
      End If
    End If
  Next
  Set pItemVenta = Nothing
  
  Me.Estado = 1
  Me.NumeroFacturaOrigen = pFactura.Numero
  
  dbHandle.Execute "UPDATE NNEE Set Estado = 1, NumeroFacturaOrigen = " & NumeroDB(NumeroFacturaOrigen) & " WHERE Numero = " & NumeroDB(Me.Numero)

End Sub


Public Function Almacen() As String
Dim pCompAlmacen As clsComprobanteAlmacen
Dim sRetVal As String

  Set pCompAlmacen = New clsComprobanteAlmacen
  If Not pCompAlmacen.GetByDocumento(Me.TipoEntidad, Me.Numero) Then
    sRetVal = ""
  Else
    sRetVal = pCompAlmacen.Almacen
  End If
  Set pCompAlmacen = Nothing
  
  Almacen = sRetVal
End Function

Public Function Despachar(sAlmacen As String) As Boolean
Dim pDetalle As clsNNEEDetalles, pAlmacen As clsAlmacen
Dim pComponente As clsComponenteItemVenta
  
  On Local Error Resume Next
  Set pAlmacen = Almacenes.Item(sAlmacen)
  If Err.Number <> 0 Then
    Despachar = False
    Exit Function
  End If

  Set pComprobante = New clsBufferComprobante
  Set pComprobanteAlmacen = New clsComprobanteAlmacen
  Set pItemVenta = New clsItemVenta
  Set pItemInv = New clsItemInventario
  
  pComprobanteAlmacen.StartProcess pAlmacen, FechaTransaccion, TipoEntidad, Numero, 0, Me.Concepto
  For Each pDetalle In Me.Detalles
    If pDetalle.CodigoItem <> "" Then
      If pItemVenta.Load(pDetalle.CodigoItem) Then
        For Each pComponente In pItemVenta.Composicion
          If pItemInv.Load(pComponente.CodigoItemInventario) Then
            With pDetalle
            pComprobante.AddDetalle Empresa.CuentaMercanciaTransito, "Nota de entrega " & Me.Referencia, pItemInv.CostoUnitario * .Cantidad * .FactorEmpaque, 0
            pComprobante.AddDetalle pItemInv.CuentaActivo, "Nota de entrega " & Me.Referencia, 0, pItemInv.CostoUnitario * .Cantidad * .FactorEmpaque
            pComprobanteAlmacen.RegistrarMINV pComponente.CodigoItemInventario, -(pComponente.Cantidad * .Cantidad * .FactorEmpaque), pItemInv.CostoUnitario
            End With
          End If
        Next
      End If
    End If
  Next

  If Not pComprobante Is Nothing Then
    pComprobante.Procesar
    pComprobanteAlmacen.EndProcess
    Me.ComprobanteAlmacen = pComprobanteAlmacen.Numero
    dbHandle.Execute "UPDATE NNEE Set ComprobanteAlmacen = " & NumeroDB(Me.ComprobanteAlmacen) & ", Estado = 3 WHERE Numero = " & NumeroDB(Me.Numero)
  End If

  Set pItemInv = Nothing
  Set pItemVenta = Nothing
  Set pComprobanteAlmacen = Nothing
  Set pComprobante = Nothing
  Set pAlmacen = Nothing

  Despachar = True

End Function

Public Function Detalle(nNumero As Integer) As clsNNEEDetalles
Dim pDetalle As clsNNEEDetalles, rs As Recordset

  Set pDetalle = New clsNNEEDetalles
  Set rs = dbHandle.Execute("SELECT * FROM NNEEDetalles WHERE NumeroDocumento = " & NumeroDB(Me.Numero) & " AND Renglon = " & NumeroDB(nNumero))
  If rs.EOF Then
    Set pDetalle = Nothing
  Else
    pDetalle.LoadInstance rs
  End If
  rs.Close
  Set rs = Nothing
  
  Set Detalle = pDetalle
End Function
