VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMovimientoBanco"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Numero As Long
Public FechaRegistro As Date
Public FechaTransaccion As Date
Public Operador As String
Public CodigoBanco As String
Public Tipo As Integer
Public Concepto As String
Public Beneficiario As String
Public Monto As Currency
Public ReferenciaBanco As String
Public Conciliado As Boolean
Public FechaEfectivo As Date
Public TipoDocRel As String
Public NumeroDocRel As Long

Public TipoEntidad As String

' "Pseudo" ISDOC ...

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Function Detalles() As Collection
Dim pComprobante As clsComprobante, retCol As Collection

  Set pComprobante = New clsComprobante
  If pComprobante.LoadByReferenciaISDOC(Me.ImagenTipo & Me.CodigoBanco & Me.ReferenciaBanco) Then
    Set retCol = pComprobante.Detalles
  Else
    Set retCol = New Collection
  End If
  Set pComprobante = Nothing
  Set Detalles = retCol

End Function

Public Function NombreArchivoFormato() As String
  If Me.Tipo = TMB_CHEQUE Then
    NombreArchivoFormato = DeterminarFormato("FormatoCheque", "FormatosCheque", BuildDataPath("FormatoCheque.txt", AppName), Me)
  Else
    NombreArchivoFormato = DeterminarFormato("FormatoMovimientoB", "FormatosMovimientoB", BuildDataPath("FormatoMovimientoB.txt", AppName), Me)
  End If
End Function

Private Function TipoFromImagen(s As String)
Dim i As Integer

    Select Case s
    Case "CHQ"
        i = TMB_CHEQUE
    Case "DEP"
        i = TMB_DEPOSITO
    Case "NCR"
        i = TMB_NCR
    Case "NDB"
        i = TMB_NDB
    Case Else
        i = -1
    End Select
    
    TipoFromImagen = i

End Function

Public Function ImagenTipo() As String
Dim s As String

    Select Case Tipo
    Case mMain.TMB_CHEQUE
        s = "CHQ"
    Case mMain.TMB_DEPOSITO
        s = "DEP"
    Case mMain.TMB_NCR
        s = "NCR"
    Case TMB_NDB
        s = "NDB"
    End Select
        
    ImagenTipo = s

End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evMovBanco.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, v, s) As Boolean
Dim bRetVal As Boolean, sBuffer As String
Dim pConcepto As CDocsMovCaja, pDocumento As Object, sRetString As String
  
  bRetVal = True

  Select Case sVarId
  
  Case "NOMBREBANCO"
      Dim pBanco As clsBancos
      Set pBanco = New clsBancos
      If pBanco.Load(Me.CodigoBanco) Then
          s = pBanco.Nombre
      Else
          s = "NO LOCALIZADO!"
      End If
      Set pBanco = Nothing
      v = s

  Case "NUMERO"
      v = Numero
      s = Format(Numero, "00000000")
  
  Case "FECHAREGISTRO"
      v = FechaRegistro
      s = Format(FechaRegistro, "Short Date")

  Case "FECHA"
      v = FechaTransaccion
      s = Format(Me.FechaTransaccion, "Short Date")

  Case "CODIGOBANCO"
      v = CodigoBanco
      s = CodigoBanco

  Case "TIPO"
  
      v = ImagenTipo
      s = ImagenTipo
  
  Case "CONCEPTO"
  
      v = Concepto
      s = Concepto

  Case "BENEFICIARIO"
  
      v = Beneficiario
      s = Beneficiario
      
  Case "MONTO"
  
      v = Monto
      s = FormatNumero(Monto, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

  Case "ABSMONTO"
      
      v = Abs(Monto)
      s = FormatNumero(Abs(Monto), Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

  Case "REFERENCIA", "REFERENCIABANCO"
  
      v = ReferenciaBanco
      s = ReferenciaBanco

  Case "DOCUMENTOS" ' Presentacion estndar.
    sRetString = ""
    For Each pConcepto In Me.Conceptos
'     Referencia           Descripcion                                         Monto
'     XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 9.999.999.999,99
      If sRetString = "" Then
        ' "Encabezado"
        sRetString = String(78, "-") & vbCrLf
        sRetString = sRetString & "Referencia           Descripcion                                         Monto" & vbCrLf
        sRetString = sRetString & String(78, "-") & vbCrLf
      End If
      Set pDocumento = pConcepto.Documento
      If pDocumento Is Nothing Then
        sBuffer = stFullLength("N/A", 21) & stFullLength("No hay un documento relacionado", 41) & FormatNumero(pConcepto.Debitos - pConcepto.Creditos, Empresa.MascaraMonetarios, 16)
      Else
        sBuffer = stFullLength(pDocumento.Referencia, 21) & stFullLength(pDocumento.Concepto, 41) & FormatNumero(pConcepto.Debitos - pConcepto.Creditos, Empresa.MascaraMonetarios, 16)
      End If
      Set pDocumento = Nothing
      sRetString = sRetString & sBuffer & vbCrLf
    Next
    s = sRetString
    v = sRetString

  Case Else

      bRetVal = False

  End Select

  If Not bRetVal Then bRetVal = Empresa.EvalVar(sVarId, v, s)
  If Not bRetVal Then bRetVal = ExtendEval(sVarId, v, s)

  EvalVar = bRetVal

End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String

    bRetVal = EvalVar(sVarId, vBuf, sBuf)
    GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)
    
End Function

Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
    
    Set cFormato = New CFormatoDocumento
    cFormato.SetDocumento Me, Not AutoPrint
    Set cFormato = Nothing

End Sub

Public Sub Show()
Dim f As frmViewMovBanco

    Set f = New frmViewMovBanco
    f.SetMovBanco Me
    
    ShowNonModal f
    
    Unload f
    Set f = Nothing

End Sub

Private Sub LoadInstance(rs As Recordset)
    Me.Beneficiario = rs!Beneficiario
    Me.CodigoBanco = rs!CodigoBanco
    Me.Concepto = rs!Concepto
    Me.Conciliado = rs!Conciliado
    Me.FechaEfectivo = rs!FechaEfectivo
    Me.FechaRegistro = rs!FechaRegistro
    Me.FechaTransaccion = rs!FechaTransaccion
    Me.Monto = rs!Monto
    Me.Numero = rs!Numero
    Me.NumeroDocRel = rs!NumeroDocRel
    Me.Operador = rs!Operador
    Me.ReferenciaBanco = rs!ReferenciaBanco
    Me.Tipo = rs!Tipo
    Me.TipoDocRel = rs!TipoDocRel
End Sub

Public Function Load(ByVal nNumero As Long) As Boolean
Dim sQuery As String, rs As Recordset, bRetVal As Boolean

    sQuery = "SELECT * FROM MovimientosBanco WHERE Numero = " & NumeroDB(nNumero)
    Set rs = dbHandle.Execute(sQuery, , adCmdText)
    If Not rs.EOF Then
        LoadInstance rs
        bRetVal = True
    Else
        bRetVal = False
    End If
    rs.Close
    Set rs = Nothing

    Load = bRetVal

End Function

Public Function LoadFromRef(sBanco As String, sTipo As String, sReferencia As String) As Boolean
Dim sQuery As String, rs As Recordset, bRetVal As Boolean

    sQuery = "SELECT * FROM MovimientosBanco WHERE CodigoBanco = " & StringDB(sBanco) & " AND Tipo =" & Str(TipoFromImagen(sTipo)) & " AND ReferenciaBanco = " & StringDB(sReferencia)
    Set rs = dbHandle.Execute(sQuery, , adCmdText)
    If Not rs.EOF Then
        LoadInstance rs
        bRetVal = True
    Else
        bRetVal = False
    End If
    rs.Close
    Set rs = Nothing

    LoadFromRef = bRetVal

End Function

Public Function Registrar(stBanco As String, _
                          stOperador As String, _
                          nTipoMovimiento As Integer, _
                          dtFechaTransaccion As Date, _
                          stConcepto As String, _
                          stBeneficiario As String, _
                          vmMonto As Currency, _
                          stRefBanco As String, _
                          dtFechaEfectivo As Date, _
                          stTipoDocRel As String, _
                          lNumDocRel As Long) As Boolean
Dim rs As Recordset, bRetVal As Boolean
Dim lNumero As Long, sQuery As String

    On Error GoTo ErrHandler
    
    bRetVal = True

    sQuery = "INSERT INTO MovimientosBanco (FechaRegistro, FechaTransaccion, Operador, CodigoBanco, " & _
             "Tipo, Concepto, Beneficiario, Monto, ReferenciaBanco, FechaEfectivo, TipoDocRel, NumeroDocRel) VALUES ("
    sQuery = sQuery & FechaDB(Date) & ", "
    sQuery = sQuery & FechaDB(dtFechaTransaccion) & ", "
    sQuery = sQuery & StringDB(UsuarioActivo.Codigo) & ", "
    sQuery = sQuery & StringDB(stBanco) & ", "
    sQuery = sQuery & NumeroDB(nTipoMovimiento) & ", "
    sQuery = sQuery & StringDB(stConcepto) & ", "
    sQuery = sQuery & StringDB(stBeneficiario) & ", "
    sQuery = sQuery & NumeroDB(vmMonto) & ", "
    sQuery = sQuery & StringDB(stRefBanco) & ", "
    sQuery = sQuery & FechaDB(dtFechaEfectivo) & ", "
    sQuery = sQuery & StringDB(stTipoDocRel) & ", "
    sQuery = sQuery & NumeroDB(lNumDocRel) & ");"
    dbHandle.Execute sQuery
    
    Set rs = dbHandle.Execute("SELECT @@identity as Ultimo FROM MovimientosBanco")
    If Not rs.EOF Then
        Me.Numero = GetNumeroFromVariant(rs!Ultimo)
    End If
    rs.Close
' < TEST
    Set rs = Nothing
    
    If dtFechaEfectivo > Date Then
        bRetVal = AlmacenBancos.RegistrarDiferido(stBanco, dtFechaEfectivo, nTipoMovimiento, stConcepto, stRefBanco, vmMonto)
    End If
        
    If bRetVal And (nTipoMovimiento = TMB_CHEQUE) Then
        lNumero = ValOf(stRefBanco)
        If lNumero Then
            lNumero = lNumero + 1
            bRetVal = AlmacenBancos.SetProximoCheque(stBanco, lNumero)
        End If
    End If

    ExecuteScript "postMovimientoBanco.vbs", Me
    SubmitDoc Me
ResumePoint:
    If Not rs Is Nothing Then
        rs.Close
        Set rs = Nothing
    End If
    
    Registrar = bRetVal
    Exit Function

ErrHandler:
    ReportarError True, Err.Number, Err.Description, "clsMovimientoBanco.Registrar"
    bRetVal = False
    Err.Clear
    Resume ResumePoint
End Function

'---------------------------------------------------------------------------------------
' Function AddConcepto
' Fecha/Hora: 27/03/03 10:24
' Funcin   : Los movimientos (ingresos) relacionados con varios documentos tienen
'             <TipoDocumento> en vbNullString y <NumeroDocumento> en 0.
'             Para poder establecer una relacin entre un movimiento de caja y varios
'             documentos, se agregan hoy los Conceptos, que establecen una relacin de
'             n<->n entre los documentos ISPC y los ingresos de caja.
'             Esta relacin se constituye en la clase CDocsMovCaja
'---------------------------------------------------------------------------------------
'
Public Function AddConcepto(vmDebitos As Currency, vmCreditos As Currency, TipoDoc As String, numDoc As Long) As Boolean
Dim sQuery As String, bRetVal As Boolean

  On Error GoTo ErrHandler
  bRetVal = True
  sQuery = "INSERT INTO SubDocsMB (TransID, TipoDoc, NumDoc, Debitos, Creditos) VALUES ("
  sQuery = sQuery & NumeroDB(Me.Numero) & ", "
  sQuery = sQuery & StringDB(TipoDoc) & ", "
  sQuery = sQuery & NumeroDB(numDoc) & ", "
  sQuery = sQuery & NumeroDB(vmDebitos) & ", "
  sQuery = sQuery & NumeroDB(vmCreditos) & ");"
  dbHandle.Execute sQuery

ResumePoint:
  AddConcepto = bRetVal
  Exit Function

ErrHandler:
Dim ErrN As Long, ErrD As String
  ErrN = Err.Number: ErrD = Err.Description
  bRetVal = False
  ReportarError False, ErrN, ErrD, "CMovimientoBanco::AddConcepto"
  Resume ResumePoint

End Function


Public Function Conceptos() As Collection
Dim sQuery As String, rs As Recordset, retCol As Collection, pConcepto As CDocsMovCaja
  
  On Error GoTo ErrHandler
  sQuery = "SELECT * FROM subDocsMB WHERE TransID = " & NumeroDB(Me.Numero) & " ORDER BY ID"
  Set rs = dbHandle.Execute(sQuery)
  Set retCol = New Collection
  Do While Not rs.EOF
    Set pConcepto = New CDocsMovCaja
    With pConcepto
    .Creditos = GetNumeroFromVariant(rs.Fields("Creditos"))
    .Debitos = GetNumeroFromVariant(rs.Fields("Debitos"))
    .NumeroDoc = GetNumeroFromVariant(rs.Fields("NumDoc"))
    .TipoDoc = GetStringFromVariant(rs.Fields("TipoDoc"))
    .TransID = GetNumeroFromVariant(rs.Fields("TransID"))
    End With
    retCol.Add pConcepto
    rs.MoveNext
  Loop

  If retCol.Count = 0 Then
    Set pConcepto = New CDocsMovCaja
    With pConcepto
    .Creditos = IIf(Me.Monto < 0, -Me.Monto, 0)
    .Debitos = IIf(Me.Monto > 0, Me.Monto, 0)
    .NumeroDoc = 0
    .TipoDoc = ""
    .TransID = Me.Numero
    End With
    retCol.Add pConcepto
  End If
    
ResumePoint:
  Set pConcepto = Nothing
  If Not rs Is Nothing Then
    rs.Close
    Set rs = Nothing
  End If
  Set Conceptos = retCol
  Exit Function

ErrHandler:
Dim ErrN As Long, ErrD As String
  ErrN = Err.Number: ErrD = Err.Description

  ReportarError False, ErrN, ErrD, "CMovimientoBanco::Documentos"
  Set retCol = Nothing
  Resume ResumePoint

End Function


Private Sub Class_Initialize()
  TipoEntidad = "MVB"
End Sub
