VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMesa"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Ambiente As String      ' Nombre corto del ambiente al cual pertenece
Public IDMesa As Long         ' Numero de la mesa
Public X As Long               ' Coordenada X (left)
Public Y As Long               ' Coordenada Y (top)
Public enmStat As EstadosTrabajo
Public nPersonas As Integer    ' Cantidad de personas que la ocupan
Public cMesonero As String    ' Codigo del ltimo mesonero que la atendi
Public MontoDespachado As Currency ' Referencia: Valor de consumo acumulado

Public Sub SetEstadoTrabajo(eNewStat As EstadosTrabajo)
  enmStat = eNewStat
  dbHandle.Execute "UPDATE mesasMesas SET enmStat = " & Str(eNewStat) & " WHERE Ambiente = " & StringDB(Ambiente) & " AND IDMesa =" & Str(IDMesa)
  If enmStat = LIBRE Then
    Dim v As Variant, cta As New clsCuentasPOS, l As Long, i As Integer
    v = Me.SubCuentas
    For i = 1 To UBound(v)
      If cta.Load(CLng(v(i))) Then
        If cta.Estado = 1 And enmStat = LIBRE Then
          enmStat = ABIERTA
        ElseIf cta.Estado = 2 Then
          enmStat = Cerrada
          Exit For
        End If
      End If
    Next
  End If
End Sub

Public Function HoraApertura() As Date
Dim Cuenta As New clsCuentasPOS
Dim Hora As Date
  If Cuenta.Load(Me.NumeroCuenta) Then
    If Cuenta.Estado <> 0 Then
      HoraApertura = Cuenta.HoraApertura
      Exit Function
    Else
      Dim i As Integer, l As Long
      Hora = #12:00:00 AM#
      For i = 0 To UBound(SubCuentas)
        If Cuenta.Load(CLng(SubCuentas(i))) Then
          If Cuenta.Estado <> 0 Then
            If Cuenta.HoraApertura <> #12:00:00 AM# And Cuenta.HoraApertura < Hora Then
              Hora = Cuenta.HoraApertura
            End If
          End If
        End If
      Next
    End If
  End If
  
  HoraApertura = Hora
End Function

Public Function PuedeRecibirComanda() As Boolean
  If Me.enmStat = Cerrada Then
    mAdvertencia "La cuenta ya ha sido cerrada"
    If Not Confirmar("Autorizar reapertura de mesa", False) Then
      PuedeRecibirComanda = False
      Exit Function
    End If
    SetEstadoTrabajo ABIERTA
  End If
  PuedeRecibirComanda = True
End Function

Private Sub LoadInstance(pInstance As clsMesa, rsHandle As Recordset)
  With rsHandle
  pInstance.Ambiente = .Fields("Ambiente")
  pInstance.IDMesa = .Fields("IDMesa")
  pInstance.X = .Fields("x")
  pInstance.Y = .Fields("y")
  pInstance.enmStat = .Fields("enmStat")
  pInstance.nPersonas = .Fields("nPersonas")
  pInstance.cMesonero = .Fields("cMesonero")
  pInstance.MontoDespachado = .Fields("MontoDespachado")
  End With
End Sub

Public Function Load(sAmbiente As String, lID As Long) As Boolean
Dim rs As Recordset, bResult As Boolean
  Set rs = dbHandle.Execute("SELECT * FROM mesasMesas WHERE Ambiente = " & StringDB(sAmbiente) & " AND IDMesa =" & Str(lID))
  If rs.EOF Then
    bResult = False
  Else
    bResult = True
    LoadInstance Me, rs
  End If
  Set rs = Nothing
  Load = bResult
End Function

Public Function SaveNew() As Boolean
Dim sQuery As String, bRetVal As Boolean
  sQuery = "INSERT INTO mesasMesas (Ambiente, IDMesa) VALUES (" & StringDB(Me.Ambiente) & "," & Str(Me.IDMesa) & ")"
  bRetVal = True
  dbHandle.Execute sQuery
  SaveNew = bRetVal
End Function

Public Function MesasAmbiente(sAmbiente As String) As Collection
Dim rs As Recordset, retCol As Collection, pMesa As clsMesa
  Set rs = dbHandle.Execute("SELECT * FROM mesasMesas WHERE Ambiente = " & StringDB(sAmbiente) & " ORDER BY IDMesa")
  Set retCol = New Collection
  Do While Not rs.EOF
    Set pMesa = New clsMesa
    LoadInstance pMesa, rs
    retCol.Add pMesa
    Set pMesa = Nothing
    rs.MoveNext
  Loop
  Set rs = Nothing
  
  Set MesasAmbiente = retCol
End Function

Public Sub SetCoordinates(X As Long, Y As Long)
  Me.X = X
  Me.Y = Y
  dbHandle.Execute "UPDATE mesasMesas SET X =" & Str(X) & ", Y =" & Str(Y) & " WHERE Ambiente = " & StringDB(Me.Ambiente) & " AND IDMesa = " & Str(Me.IDMesa)
End Sub

Public Sub Eliminar(sAmbiente As String, lID As Long)
  dbHandle.Execute "DELETE FROM mesasMesas WHERE Ambiente = " & StringDB(sAmbiente) & " AND IDMesa =" & NumeroDB(lID)
End Sub

Public Function NumeroCuenta() As Long
Dim pAmbiente As clsAmbiente, lNumMesa As Long
  Set pAmbiente = New clsAmbiente
  If pAmbiente.Load(Me.Ambiente) Then
    lNumMesa = pAmbiente.AccountOffset - 1 + Me.IDMesa
  Else
    lNumMesa = -1
  End If
  Set pAmbiente = Nothing

  NumeroCuenta = lNumMesa
End Function

Public Function TieneSubCuentas() As Integer
Dim pAmbiente As clsAmbiente
Dim lMin As Long, lMax As Long
Dim sQuery As String, rs As Recordset
Dim r As Integer

  Set pAmbiente = New clsAmbiente
  If Not pAmbiente.Load(Me.Ambiente) Then
    TieneSubCuentas = 0
    Exit Function
  End If
  
  lMin = pAmbiente.CalcularNumero(IDMesa, 1)
  lMax = pAmbiente.CalcularNumero(IDMesa, 999)
  
  sQuery = "SELECT Count(idCuenta) AS Q FROM CuentasPOS WHERE idCuenta BETWEEN " & NumeroDB(lMin) & " AND " & NumeroDB(lMax) & ";"
  Set rs = dbHandle.Execute(sQuery)
  If rs.EOF Then
    r = 0
  Else
    r = GetNumeroFromVariant(rs.Fields("Q"))
  End If
  Set rs = Nothing
  
  TieneSubCuentas = r

End Function

Public Function SubCuentas() As Variant
Dim v() As Long
Dim pAmbiente As clsAmbiente
Dim lMin As Long, lMax As Long
Dim sQuery As String, rs As Recordset

  ReDim v(0)
  Set pAmbiente = New clsAmbiente
  If Not pAmbiente.Load(Me.Ambiente) Then
    SubCuentas = v
    Exit Function
  End If
  
  lMin = pAmbiente.CalcularNumero(IDMesa, 1)
  lMax = pAmbiente.CalcularNumero(IDMesa, 999)
  
  ReDim v(0)
  sQuery = "SELECT idCuenta FROM CuentasPOS WHERE idCuenta BETWEEN " & NumeroDB(lMin) & " AND " & NumeroDB(lMax) & ";"
  Set rs = dbHandle.Execute(sQuery)
  Do While Not rs.EOF
    ReDim Preserve v(UBound(v) + 1)
    v(UBound(v)) = GetNumeroFromVariant(rs.Fields("idCuenta"))
    rs.MoveNext
  Loop
  Set rs = Nothing
  
  SubCuentas = v
End Function
