VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListarOrdenes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 160
'Equipo   Serial           Orden  Cliente                             Falla                                    Tecnico   Ingreso    Retiro    Dias     Valor Rep.
'XXXXXXXX XXXXXXXXXXXXXXXX 999999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXX 99-99-9999 99-99-9999 9999 999.999.999,99

Private fView As lfQuickView

Private Sub PasarLinea( _
        sEquipo As String, _
        sSerial As String, _
        sNumeroOrden As String, _
        sCliente As String, _
        sFalla As String, _
        sTecnico As String, _
        sIngreso As String, _
        sRetiro As String, _
        dDif As Long, _
        vmReparacion As Currency)
Dim sOut As String

    sOut = stFullLength(sEquipo, 8) & " " & stFullLength(sSerial, 16) & " " & stFullLength(sNumeroOrden, 6) & " " & stFullLength(sCliente, 35) & " " & stFullLength(sFalla, 40) & " " & stFullLength(sTecnico, 8) & " " & stFullLength(sIngreso, 10) & " " & stFullLength(sRetiro, 10) & " "
    sOut = sOut & FormatNumero(dDif, "###0", 4) & " " & FormatNumero(vmReparacion, Empresa.MascaraMonetarios, 14)
    fView.Add sOut

End Sub

Private Sub Encabezado()

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        fView.PageBreak
    End If
    
    fView.Add ""
    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Listado de Ordenes de Reparacin", vbCenter
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(fView.Pagina)

    fView.Add String(AnchoReporte, "-")
    fView.Add "Equipo   Serial           Orden  Cliente                             Falla                                    Tecnico   Ingreso    Retiro    Dias     Valor Rep."
    fView.Add String(AnchoReporte, "-")
    
End Sub

Public Sub Generar()
Dim fSeleccion As frmCriteriosOrdenes
Dim sQuery As String, fQuery As String
Dim isOk As Boolean, rs As Recordset
Dim vLineasFalla As Variant, sNext As String
Dim difDates As Long, i As Integer
Dim pEquipo As clsEquipo, pCliente As clsClientes

    Set fSeleccion = New frmCriteriosOrdenes
    Centrar fSeleccion
    ShowNonModal fSeleccion
    isOk = fSeleccion.bResult
    
    If isOk Then fQuery = fSeleccion.Query("O")
    
    Unload fSeleccion
    Set fSeleccion = Nothing
    
    If Not isOk Then Exit Sub
    
    sQuery = "SELECT O.TipoEquipo, O.Serial, O.Numero, O.Sintomas, O.FechaRecepcion, O.Tecnico, F.FechaTransaccion, F.PrecioEfectivo "
    sQuery = sQuery & "FROM rwsOrdenesTrabajo AS O LEFT JOIN Facturas AS F ON F.Numero = O.Factura "
    sQuery = sQuery & "WHERE " & fQuery

    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    
    With rs
    If Not .EOF Then
        
        Set pEquipo = New clsEquipo
        Set pCliente = New clsClientes

        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        
        Encabezado
        
        Do While Not .EOF

            difDates = GetDateFromVariant(.Fields("FechaTransaccion")) - GetDateFromVariant(.Fields("FechaRecepcion"))
            sNext = stGetStringFromVariant(.Fields("Sintomas"))
            vLineasFalla = Convert2Lines(sNext, 40)
            If fView.Linea - 2 + UBound(vLineasFalla) >= fView.LineasPagina Then
                Encabezado
            End If

            If Not pEquipo.Load(.Fields("TipoEquipo"), .Fields("Serial")) Then
                sNext = "!!! ERR: EQUIPO !!!"
            Else
                If Not pCliente.Load(pEquipo.Propietario) Then
                    sNext = "!!! ERR: CLIENTE (" & pEquipo.Propietario & ") !!!"
                Else
                    sNext = pCliente.Nombre
                End If
            End If

            PasarLinea stGetStringFromVariant(.Fields("TipoEquipo")), _
                        stGetStringFromVariant(.Fields("Serial")), _
                        Format(GetNumeroFromVariant(.Fields("Numero")), "000000"), _
                        sNext, _
                        (vLineasFalla(1)), _
                        stGetStringFromVariant(.Fields("Tecnico")), _
                        Format(GetDateFromVariant(.Fields("FechaRecepcion")), "Short Date"), _
                        IIf(difDates >= 0, Format(GetDateFromVariant(.Fields("FechaTransaccion")), "Short Date"), ""), _
                        IIf(difDates >= 0, difDates, 0), _
                        GetNumeroFromVariant(.Fields("PrecioEfectivo"))

            For i = 2 To UBound(vLineasFalla)
                PasarLinea "", "", "", "", (vLineasFalla(i)), "", "", "", 0, 0
            Next

            .MoveNext
        Loop
        
        Set pCliente = Nothing
        Set pEquipo = Nothing
        
        fView.SetNotify Me
        ShowNonModal fView

        Unload fView
        Set fView = Nothing

    End If
    End With

    Set rs = Nothing

End Sub

'Equipo   Serial           Orden  Cliente                             Falla                                    Tecnico   Ingreso    Retiro    Dias     Valor Rep.
'XXXXXXXX XXXXXXXXXXXXXXXX 999999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXX 99-99-9999 99-99-9999 9999 999.999.999,99
Public Sub ReportClicked(sLinea As String, ByVal nPos As Long)
Dim sImagenNumero As String, lNumero As Long
Dim pOrden As clsOrdenRWS

    sImagenNumero = Trim(Mid(sLinea, 28, 6))
    lNumero = Val(sImagenNumero)
    If (lNumero = 0) Then Exit Sub
    Set pOrden = New clsOrdenRWS
    If Not pOrden.Load(lNumero) Then
        Set pOrden = Nothing
        Exit Sub
    End If
    
    Select Case nPos
    Case 1 To 32
        pOrden.Show
    
    Case 33 To 68
        Dim pCliente As clsClientes, pEquipo As clsEquipo
        Set pEquipo = pOrden.Equipo
        If Not pEquipo Is Nothing Then
            Set pCliente = pEquipo.Cliente
            If Not pCliente Is Nothing Then pCliente.Show
        End If
        Set pCliente = Nothing
        Set pEquipo = Nothing
    
    End Select
        
End Sub

