VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaVntProdPer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

'Consultas originales (probadas en Access)
'1.-Por perodo
'SELECT paramFechaInicial + (Int( (FechaOperacion - paramFechaInicial) / paramAgrupacion) * paramAgrupacion) AS Base, paramFechaInicial + (Int( (FechaOperacion - paramFechaInicial) / paramAgrupacion + 1) * paramAgrupacion - 1) AS Fin, Sum(PrecioVenta * Cantidad) AS TotalVenta, Sum(Cantidad) AS CantidadVendida, Sum(CostoStandard * Cantidad) AS CostoVenta
'From DetallesItemVenta
'WHERE CodigoItem = paramCodigoItem AND FechaOperacion BETWEEN paramFechaInicial AND paramFechaFinal
'GROUP BY paramFechaInicial + (Int( (FechaOperacion - paramFechaInicial) / paramAgrupacion) * paramAgrupacion), paramFechaInicial + (Int( (FechaOperacion - paramFechaInicial) / paramAgrupacion + 1) * paramAgrupacion - 1);
'2.- Por mes
'SELECT Month(FechaOperacion) AS Mes, Year(FechaOperacion) AS Anho, Sum(PrecioVenta * Cantidad) AS TotalVenta, Sum(Cantidad) AS CantidadVendida, Sum(CostoStandard * Cantidad) AS CostoVenta
'From DetallesItemVenta
'WHERE CodigoItem = paramCodigoItem AND FechaOperacion BETWEEN paramFechaInicial AND paramFechaFinal
'GROUP BY Month(FechaOperacion), Year(FechaOperacion);

Private isMesOrRango As Boolean, nRango As Integer
Private finic As Date, ffinal As Date
Private sCodProd As String, sDescProd As String
Private fView As lfQuickView, AnchoReporte As Long
Private totUnits As Double, tVenta As Currency, tCosto As Currency

Public Sub SetItem(sCodigo As String, sDescripcion As String)
    
    sCodProd = sCodigo
    sDescProd = sDescripcion

End Sub

Private Sub WriteLinea(sGroup As String, dUnidades As Double, _
                       vTotVenta As Currency, vTotCosto As Currency)
Dim sOut As String, vmPrecioU As Currency, vmCostoU As Currency

    If dUnidades <> 0 Then
        vmPrecioU = vTotVenta / dUnidades
        vmCostoU = vTotCosto / dUnidades
    Else
        vmPrecioU = 0
        vmCostoU = 0
    End If
    
    sOut = stFullLength(sGroup, IIf(isMesOrRango, 13, 21)) & " "
    sOut = sOut & FormatNumero(dUnidades, Empresa.MascaraCantidades, 13) & " "
    sOut = sOut & FormatNumero(vTotVenta, Empresa.MascaraMonetarios, 17) & " "
    sOut = sOut & FormatNumero(vmPrecioU, Empresa.MascaraPrecios, 13) & " "
    sOut = sOut & FormatNumero(vTotCosto, Empresa.MascaraMonetarios, 17) & " "
    sOut = sOut & FormatNumero(vmCostoU, Empresa.MascaraMonetarios, 13) & " "
    sOut = sOut & FormatNumero(vTotVenta - vTotCosto, Empresa.MascaraMonetarios, 16) & " "
    sOut = sOut & FormatNumero(vmPrecioU - vmCostoU, Empresa.MascaraPrecios, 13) & " "
    sOut = sOut & FormatNumero(lmProporciones.CalcPDescuento(vTotVenta, vTotCosto), "##0.00", 6)
    fView.Add sOut

End Sub

'Desde      Hasta           Unidades       Total Venta  Precio Medio       Costo Total   Costo Medio   Utilidad Total   Util. Unit.   (%)
'99-99-9999 99-99-9999 99.999.999,99 99.999.999.999,99 99.999.999,99 99.999.999.999,99 99.999.999,99 9.999.999.999,99 99.999.999,99 99,99

'Mes                Unidades       Total Venta  Precio Medio       Costo Total   Costo Medio   Utilidad Total   Util. Unit.   (%)
'XXXXXXXXXX'99 99.999.999,99 99.999.999.999,99 99.999.999,99 99.999.999.999,99 99.999.999,99 9.999.999.999,99 99.999.999,99 99,99

Private Sub Encabezado()

    If fView.Linea > 1 Or fView.Pagina > 1 Then
        WriteLinea "VAN", totUnits, tVenta, tCosto
        fView.PageBreak
    End If
    
    fView.Add ""
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Resumen de ventas para el producto " & sDescProd, AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(fView.Pagina)

    fView.Add String(AnchoReporte, "-")
    If isMesOrRango Then
        fView.Add "Mes                Unidades       Total Venta  Precio Medio       Costo Total   Costo Medio   Utilidad Total   Util. Unit.    (%)"
    Else
        fView.Add "Desde      Hasta           Unidades       Total Venta  Precio Medio       Costo Total   Costo Medio   Utilidad Total   Util. Unit.    (%)"
    End If
    fView.Add String(AnchoReporte, "-")
    
    If fView.Pagina > 1 Then
        WriteLinea "VIENEN", totUnits, tVenta, tCosto
    End If

End Sub

Private Sub PasarMes(sMes As String, sAnho As Integer, dUnidades As Double, vTotVenta As Double, vTotCosto As Double)

    If Abs(dUnidades) < 0.01 Then Exit Sub
    
    If fView.Linea >= fView.LineasPagina - 1 Then
        Encabezado
    End If
    
    WriteLinea sMes & "/" & Format(sAnho Mod 100, "00"), dUnidades, (vTotVenta), (vTotCosto)
    
    totUnits = totUnits + dUnidades: tVenta = tVenta + vTotVenta: tCosto = tCosto + vTotCosto
    
End Sub

Private Sub PasarRango(fBase As Date, fTermino As Date, dUnidades As Double, vTotVenta As Double, vTotCosto As Double)

    If Abs(dUnidades) < 0.01 Then Exit Sub
    
    If fView.Linea >= fView.LineasPagina - 1 Then
        Encabezado
    End If

    WriteLinea stFullLength(Format(fBase, "Short Date"), 10) & " " & stFullLength(Format(fTermino, "Short Date"), 10), dUnidades, (vTotVenta), (vTotCosto)
    
    totUnits = totUnits + dUnidades: tVenta = tVenta + vTotVenta: tCosto = tCosto + vTotCosto
    
End Sub

Public Sub Generar()
Dim f As lfSelectRangoFechas, bResult As Boolean
Dim rs As Recordset, sQuery As String
Dim lFecha1 As Date, lFecha2 As Date, lNombreMes As String
    
    If sCodProd = "" Then
        mAdvertencia "ERROR: No ha definido sCodProd: clsListaVntProdPer"
        Exit Sub
    End If

    Set f = New lfSelectRangoFechas
    
    f.Show 1
    
    bResult = f.Result
    
    If bResult Then
        isMesOrRango = f.optPorMes
        nRango = f.txIntervalo
        finic = f.dtFechaInicial
        ffinal = f.dtFechaFinal
    End If
    
    Unload f
    Set f = Nothing

    If Not bResult Then Exit Sub

    If Not isMesOrRango Then
        sQuery = "SELECT " & FechaDB(finic) & " + (Int( (FechaOperacion - " & FechaDB(finic) & ") / " & Str(nRango) & ") * " & Str(nRango) & ") AS Base, " & FechaDB(finic) & " + (Int( (FechaOperacion - " & FechaDB(finic) & ") / " & Str(nRango) & " + 1) * " & Str(nRango) & " - 1) AS Fin, Sum(PrecioVenta * Cantidad) AS TotalVenta, Sum(Cantidad) AS CantidadVendida, Sum(CostoStandard * Cantidad) AS CostoVenta"
        sQuery = sQuery & " From DetallesItemVenta"
        sQuery = sQuery & " WHERE CodigoItem = " & StringDB(sCodProd) & " AND FechaOperacion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & ""
        sQuery = sQuery & " GROUP BY " & FechaDB(finic) & " + (Int( (FechaOperacion - " & FechaDB(finic) & ") / " & Str(nRango) & ") * " & Str(nRango) & "), " & FechaDB(finic) & " + (Int( (FechaOperacion - " & FechaDB(finic) & ") / " & Str(nRango) & " + 1) * " & Str(nRango) & " - 1)"
    Else
        sQuery = "SELECT Month(FechaOperacion) AS Mes, Year(FechaOperacion) AS Anho, Sum(PrecioVenta * Cantidad) AS TotalVenta, Sum(Cantidad) AS CantidadVendida, Sum(CostoStandard * Cantidad) AS CostoVenta From DetallesItemVenta WHERE CodigoItem = " & StringDB(sCodProd)
        sQuery = sQuery & " AND FechaOperacion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal)
        sQuery = sQuery & " GROUP BY Month(FechaOperacion), Year(FechaOperacion)"
    End If

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then
        
        Screen.MousePointer = vbHourglass
        AnchoReporte = IIf(isMesOrRango, 129, 137)
        Set fView = New lfQuickView
        fView.SetReportWidth (AnchoReporte)
        fView.Caption = "Resumen de ventas para " & sDescProd

        Encabezado
        
        Do While Not rs.EOF
            If isMesOrRango Then
                PasarMes Format(NombreMes(rs!Mes), ">"), rs!Anho, rs!CantidadVendida, rs!TotalVenta, GetNumeroFromVariant(rs!CostoVenta)
            Else
                PasarRango rs!Base, rs!Fin, rs!CantidadVendida, rs!TotalVenta, GetNumeroFromVariant(rs!CostoVenta)
            End If
            
            rs.MoveNext
        Loop

        WriteLinea "TOTAL", totUnits, tVenta, tCosto

        Screen.MousePointer = vbDefault
        ShowNonModal fView

        Unload fView
        Set fView = Nothing
        
    End If
    
    rs.Close
    Set rs = Nothing

End Sub

Private Sub Class_Initialize()

    sCodProd = ""

End Sub
