VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaVntProdDet"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 141
Dim WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1
Private finic As Date, ffinal As Date
Private sCodProd As String, sDescProd As String
Private totCantidad As Double, totVenta As Currency

Public Sub SetItem(sCodigo As String, sDescripcion As String)
    
    sCodProd = sCodigo
    sDescProd = sDescripcion

End Sub

'---------------------------------------------------------------------------------------------------------------------------------------------
'Fecha      Factura           Nombre del Cliente                        Codigo del Cliente         Cantidad     Precio Unit.             Total
'---------------------------------------------------------------------------------------------------------------------------------------------
'99-99-9999 XXXXXXXX-99999999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX 999.999.999,99 9.999.999.999,99 99.999.999.999,99

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim sExtract As String, pCliente As clsClientes, pDoc As Object, sTemp As String, pFact As clsFacturas
Dim pInstancer As clsInstanciadorEntidad

  bProcessed = True
  If nLinePos < 32 Or nLinePos > 94 Then  ' Mostrar documento
    sExtract = Trim(Mid(Trim(strReportLine), 12, 17))
    nLinePos = InStr(1, sExtract, "-")
    
    If nLinePos < 2 Then Exit Sub
  
    sTemp = left(sExtract, nLinePos - 1)
    
    Set pFact = New clsFacturas
    If pFact.LoadByReferenciaISDOC(sExtract) Then
      pFact.Show
    Else
      Dim pFactPOS As clsFacturasPOS
      Set pFactPOS = New clsFacturasPOS
      If pFactPOS.LoadByReferenciaISDOC(sExtract) Then
        pFactPOS.Show
      Else
        Dim pDev As clsDevolucionVenta
        Set pDev = New clsDevolucionVenta
        If pDev.LoadByReferenciaISDOC(left(sExtract, 3) & right(sExtract, Len(sExtract) - 4)) Then
          pDev.Show
        End If
      End If
    End If
  Else                                    ' Mostrar cliente
    sExtract = Mid(Trim(strReportLine), 71, 21)
    sExtract = Trim(sExtract)
    Set pCliente = AlmacenClientes.Cliente(sExtract)
    If Not pCliente Is Nothing Then
      pCliente.Show
    End If
  End If
End Sub

Private Sub WriteLinea( _
        sFecha As String, _
        sFactura As String, _
        sNombreCliente As String, _
        sCodigoCliente As String, _
        dCantidad As Double, _
        vPrecioUnit As Currency)
Dim vTotal As Currency, sOut As String

    vTotal = vPrecioUnit * dCantidad
    sOut = stFullLength(sFecha, 10) & " " & stFullLength(sFactura, 17) & " " & stFullLength(sNombreCliente, 40) & " " & stFullLength(sCodigoCliente, 20) & " "
    sOut = sOut & FormatNumero(dCantidad, Empresa.MascaraCantidades, 14) & " " & FormatNumero(vPrecioUnit, Empresa.MascaraPrecios, 16) & " " & FormatNumero(vTotal, Empresa.MascaraMonetarios, 17)
    fView.Add sOut

End Sub

Private Sub Encabezado()
Dim PrecioUnit As Currency

    If fView.Linea > 1 Or fView.Pagina > 1 Then
        PrecioUnit = totCantidad / totVenta
        WriteLinea "VAN", "", "", "", totCantidad, PrecioUnit
        fView.PageBreak
    End If
    
    fView.Add ""
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Ventas Detalladas del producto " & sDescProd, AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(fView.Pagina)

    fView.Add String(AnchoReporte, "-")
    fView.Add "Fecha      Factura           Nombre del Cliente                        Codigo del Cliente         Cantidad     Precio Unit.             Total"
    fView.Add String(AnchoReporte, "-")
    
    If fView.Pagina > 1 Then
        WriteLinea "VIENEN", "", "", "", totCantidad, PrecioUnit
    End If

End Sub

Private Sub PasarLinea( _
    dFecha As Date, _
    sSerie As String, _
    lCorrelativo As Currency, _
    sNombreCli As String, _
    sCodCli As String, _
    dCantidad As Double, _
    vPrecioUnitario As Currency)
Dim s As String, sNombre As String

    If fView.Linea >= fView.LineasPagina - 2 Then
        Encabezado
    End If
    sNombre = sNombreCli
    If sSerie = "POS" Then
      s = lCorrelativo \ 1000000 & "-" & Format(lCorrelativo Mod 1000000, "000000")
      Dim pCliente As clsClientes
      If sCodCli <> "" Then
        Set pCliente = AlmacenClientes.Cliente(sCodCli)
        If Not pCliente Is Nothing Then
          sNombre = pCliente.Nombre
        Else
          Dim pCliPOS As clsClientePOS
          Set pCliPOS = New clsClientePOS
          If pCliPOS.Load(sCodCli) Then
            sNombre = pCliPOS.Nombre
          End If
        End If
      End If
    Else
      If lCorrelativo = 0 Then
        s = "DEVOLUCION"
      Else
        s = sSerie & "-" & Format(lCorrelativo, "00000000")
      End If
    End If

    WriteLinea Format(dFecha, "Short Date"), s, sNombre, sCodCli, dCantidad, vPrecioUnitario
    
    totCantidad = totCantidad + dCantidad
    totVenta = totVenta + (vPrecioUnitario * dCantidad)

End Sub

'SELECT F.Serie AS DocType, F.Correlativo AS DocNo, F.FechaTransaccion AS Fecha, F.CodigoCliente, F.NombreCliente, D.Cantidad * D.FactorEmpaque AS Cantidad, D.PrecioEfectivo / (D.Cantidad * D.FactorEmpaque) AS PrecioUnitario, D.CostoUnitario AS Costo, D.CodigoItem
'FROM DetallesFactura AS D, Facturas AS F
'Where D.NumeroDocumento = f.Numero And D.CodigoItem = paramCodigoItem
'Union
'SELECT 'DVV' AS DocType, F.Numero AS DocNo, F.FechaTransaccion AS Fecha, F.CodigoCliente, F.NombreCliente, -D.CantidadDevuelta * D.FactorEmpaque AS Cantidad, -D.Valor / (D.CantidadDevuelta * D.FactorEmpaque) AS PrecioUnitario, -D.Costo / (D.CantidadDevuelta * D.FactorEmpaque) AS Costo, D.CodigoItemVenta
'FROM DetallesDevolucionVenta AS D, Facturas AS F
'Where D.NumeroDevolucion = f.Numero And D.CodigoItemVenta = paramCodigoItem
'ORDER BY Fecha, DocType, DocNo;

'99-99-9999 XXXXXXXX-99999999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX 999.999.999,99 9.999.999.999,99 99.999.999.999,99

Public Sub Generar()
Dim f As lfSelectRangoFechas, rs As Recordset
Dim bResult As Boolean, sQuery As String

    Set f = New lfSelectRangoFechas
    f.Show 1
    bResult = f.Result

    If bResult Then
        finic = f.dtFechaInicial
        ffinal = f.dtFechaFinal
    End If

    Unload f
    Set f = Nothing

    If Not bResult Then Exit Sub

    sQuery = ""
    sQuery = sQuery & "SELECT F.Serie AS DocType, F.Correlativo AS DocNo, F.FechaTransaccion AS Fecha, F.CodigoCliente, F.NombreCliente, D.Cantidad * D.FactorEmpaque AS Cantidad, D.PrecioEfectivo / (D.Cantidad * D.FactorEmpaque) AS PrecioUnitario, D.CostoUnitario AS Costo "
    sQuery = sQuery & "FROM DetallesFactura D, Facturas F "
    sQuery = sQuery & " WHERE D.NumeroDocumento = f.Numero And D.CodigoItem = " & StringDB(sCodProd) & " "
    sQuery = sQuery & " AND F.FechaTransaccion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & " "
    sQuery = sQuery & "UNION ALL "
    sQuery = sQuery & " SELECT 'DVV' AS DocType, V.Numero AS DocNo, V.FechaTransaccion AS Fecha, V.CodigoCliente, V.NombreCliente, -D.CantidadDevuelta * D.FactorEmpaque AS Cantidad, D.Valor / (D.CantidadDevuelta * D.FactorEmpaque) AS PrecioUnitario, D.Costo / (D.CantidadDevuelta * D.FactorEmpaque) AS Costo "
    sQuery = sQuery & " FROM DetallesDevolucionVenta AS D, DevolucionesVenta AS V "
    sQuery = sQuery & " WHERE D.NumeroDevolucion = V.Numero And D.CodigoItemVenta = " & StringDB(sCodProd) & " "
    sQuery = sQuery & "  AND V.FechaTransaccion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & " "
    sQuery = sQuery & "UNION ALL "
    sQuery = sQuery & "SELECT 'POS' as DocType, (F.idMaquina * 1000000 + F.numeroTicket) as DocNo, F.Hora as Fecha, F.Cliente, 'Ventas directas de mostrador' as NombreCliente, D.Cantidad, D.PrecioUnitario, 0 as Costo "
    sQuery = sQuery & "  FROM RenglonesFacturaPOS D, FacturasPOS F "
    sQuery = sQuery & "  WHERE D.Producto = " & StringDB(sCodProd) & " "
    sQuery = sQuery & "  AND D.idMaquina = F.idMaquina AND D.NumeroTicket = F.numeroTicket "
    sQuery = sQuery & "  AND F.Hora BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal + 1) & " "
    sQuery = sQuery & "ORDER BY Fecha, DocType, DocNo;"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then

        Screen.MousePointer = vbHourglass
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.Caption = "Relacion detallada de ventas para " & sDescProd
        Encabezado

        Do While Not rs.EOF

            PasarLinea rs!Fecha, rs!docType, rs!DocNo, rs!NombreCliente, rs!CodigoCliente, rs!Cantidad, rs!PrecioUnitario
            rs.MoveNext

        Loop
        
        WriteLinea "TOTAL", "", "", "", totCantidad, totVenta / totCantidad
        
        Screen.MousePointer = vbDefault
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing

    End If
    
    rs.Close
    Set rs = Nothing
        
End Sub

