VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaVntProdCli"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 111

Private totVenta As Currency, totUnits As Double
Private fView As lfQuickView
Private sCodProd As String, sDescProd As String
Private finic As Date, ffinal As Date

Public Sub SetItem(sCodigo As String, sDescripcion As String)
    
    sCodProd = sCodigo
    sDescProd = sDescripcion

End Sub

'---------------------------------------------------------------------------------------------------------------
'Nombre del Cliente                        Cdigo                     Unidades        Valor Venta   Precio Medio
'---------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999.999,99 999.999.999,99

Private Sub WriteLinea( _
            sNombreCli As String, _
            sCodCli As String, _
            dUnidades As Double, _
            vmMontoTotal As Currency)
Dim sOut As String, vmPrecioMedio As Currency

    If Abs(dUnidades) > 0.1 Then
        vmPrecioMedio = vmMontoTotal / dUnidades
    Else
        vmPrecioMedio = 0
    End If

    sOut = stFullLength(sNombreCli, 41) & stFullLength(sCodCli, 21) & FormatNumero(dUnidades, Empresa.MascaraCantidades, 14) & " "
    sOut = sOut & FormatNumero(vmMontoTotal, Empresa.MascaraMonetarios, 18) & " " & FormatNumero(vmPrecioMedio, Empresa.MascaraMonetarios, 14)

    fView.Add sOut

End Sub

Private Sub Encabezado()

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        WriteLinea "VAN", "", totUnits, totVenta
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Listado de Ventas por Cliente. Articulo: " & sDescProd, AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(fView.Pagina)

    fView.Add String(AnchoReporte, "-")
    fView.Add "Nombre del Cliente                        Cdigo                     Unidades        Valor Venta   Precio Medio"
    fView.Add String(AnchoReporte, "-")
    
    If fView.Pagina > 1 Then
        WriteLinea "VIENEN", "", totUnits, totVenta
    End If

End Sub

Private Sub PasarLinea( _
            sNombreCli As String, _
            sCodCli As String, _
            dUnidades As Double, _
            vmMontoTotal As Currency)

    If fView.Linea >= fView.LineasPagina - 2 Then
        Encabezado
    End If

    WriteLinea sNombreCli, sCodCli, dUnidades, vmMontoTotal

    totUnits = totUnits + dUnidades
    totVenta = totVenta + vmMontoTotal

End Sub

'SELECT D.CodigoCliente, C.Nombre, Sum(D.Cantidad) AS Cantidad, Sum(D.Cantidad * D.PrecioVenta) AS Monto, Sum(D.Cantidad * D.CostoStandard) AS Costo
'FROM DetallesItemVenta AS D, Clientes AS C
'WHERE D.CodigoItem = paramCodigo
' AND D.FechaOperacion BETWEEN paramFInic AND paramFFinal
' AND C.Codigo = D.CodigoCliente
'GROUP BY D.CodigoCliente, C.Nombre
'ORDER BY C.Nombre;

Public Sub Generar()
Dim f As lfSelectRangoFechas, rs As Recordset
Dim bResult As Boolean, sQuery As String

    Set f = New lfSelectRangoFechas
    f.Show 1
    bResult = f.Result

    If bResult Then
        finic = f.dtFechaInicial
        ffinal = f.dtFechaFinal
    End If

    Unload f
    Set f = Nothing

    If Not bResult Then Exit Sub

    sQuery = "SELECT D.CodigoCliente, C.Nombre, Sum(D.Cantidad) AS Cantidad, Sum(D.Cantidad * D.PrecioVenta) AS Monto, Sum(D.Cantidad * D.CostoStandard) AS Costo"
    sQuery = sQuery & " FROM DetallesItemVenta AS D, Clientes AS C"
    sQuery = sQuery & " WHERE D.CodigoItem = " & StringDB(sCodProd)
    sQuery = sQuery & " AND D.FechaOperacion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal)
    sQuery = sQuery & " AND C.Codigo = D.CodigoCliente"
    sQuery = sQuery & " GROUP BY D.CodigoCliente, C.Nombre"
    sQuery = sQuery & " ORDER BY C.Nombre;"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault
    
    If Not rs.EOF Then

        Screen.MousePointer = vbHourglass
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.Caption = sDescProd & ": Relacion de ventas por Cliente"
        Encabezado

        Do While Not rs.EOF

            PasarLinea rs!Nombre, rs!CodigoCliente, rs!Cantidad, rs!Monto
            rs.MoveNext

        Loop
        
        WriteLinea "TOTAL", "", totUnits, totVenta
        
        Screen.MousePointer = vbDefault
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing

    End If
    
    rs.Close
    Set rs = Nothing
        
End Sub

