VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaUtilFact"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 171
Private srceFacturas As clsFiltroFacturas

Private doSortByVendedor As Boolean, doSortByCliente As Boolean
Private ControlTag As String
Private TotInicial As Currency, TotDevol As Currency, TotDescuento As Currency, TotCosto As Currency, TotCostoDev As Currency
Private SubTotInicial As Currency, SubTotDevol As Currency, SubTotDescuento As Currency, SubTotCosto As Currency, SubTotCostoDev As Currency

'                                   Nombre de la Empresa
'                           Listado General de Facturas
'                        Entre el 99-99-9999 y el 99-99-9999
'Fecha de Emisin: 99.99.9999 a las hh:mm p.m.   OPERADOR: XXXXXXXX     Pgina: 1
'---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
'NUMERO      FECHA      CODIGO DEL CLIENTE   Precio Inicial  Devoluciones     Descuentos   INGRESO NETO  Costo Inicial Costo Devuelto     COSTO NETO       Utilidad  % Util.
'---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
'DIR-0000000 99-99-9999 XXXXXXXXXXXXXXXXXXXX 999.999.999,99 99.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99    99,99

Private Sub ImprimirLinea(f As lfQuickView, _
                            sNumero As String, _
                            sFecha As String, _
                            sCodCli As String, _
                            vmPrecio As Currency, _
                            vmDevuelto As Currency, _
                            vmDescuento As Currency, _
                            vmCostoInicial As Currency, _
                            vmCostoDevuelto As Currency)
'Precio Inicial  Devoluciones     Descuentos   INGRESO NETO  Costo Inicial Costo Devuelto     COSTO NETO       Utilidad  & Util.
Dim sOut As String, vmTemp As Currency

    sOut = stFullLength(sNumero, 11) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & stFullLength(sCodCli, 20) & " "
    sOut = sOut & FormatNumero(vmPrecio, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmDevuelto, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmDescuento, "###,###,##0.00", 14) & " "
    vmTemp = vmPrecio - (vmDescuento + vmDevuelto)
    sOut = sOut & FormatNumero(vmTemp, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmCostoInicial, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmCostoDevuelto, "###,###,##0.00", 14) & " "
    vmTemp = vmCostoInicial - vmCostoDevuelto
    sOut = sOut & FormatNumero(vmTemp, "###,###,##0.00", 14) & " "
    vmTemp = vmPrecio - (vmDescuento + vmDevuelto + vmTemp)
    sOut = sOut & FormatNumero(vmTemp, "###,###,##0.00", 14) & " "
    If (vmPrecio - (vmDescuento + vmDevuelto)) < 0.1 Then
      vmTemp = 0
    Else
      vmTemp = CalcularUtilidad(vmPrecio - (vmDescuento + vmDevuelto), vmCostoInicial - vmCostoDevuelto)
    End If
    sOut = sOut & FormatNumero(vmTemp, "##0.000", 7)

    f.Add sOut

End Sub

Private Sub Ruptura(f As lfQuickView, sNewTag As String)

    If ControlTag = "" Then
        ControlTag = sNewTag
        Exit Sub
    End If

    ImprimirLinea f, "SUB-TOTAL", "", ControlTag, SubTotInicial, SubTotDevol, SubTotDescuento, SubTotCosto, SubTotCostoDev

    
    If f.Linea + 3 >= f.LineasPagina Then
        Encabezado f
    Else
        f.Add ""
    End If

    SubTotInicial = 0: SubTotDevol = 0: SubTotDescuento = 0: SubTotCosto = 0: SubTotCostoDev = 0
    ControlTag = sNewTag

End Sub

Private Sub Encabezado(f As lfQuickView)

    If TotInicial > 0 Or SubTotInicial > 0 Then

        If SubTotInicial > 0 Then
            ImprimirLinea f, "VAN", "", "", SubTotInicial, SubTotDevol, SubTotDescuento, SubTotCosto, SubTotCostoDev
        End If
        f.PageBreak

    End If

    f.Add ""
    f.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    f.Add stMidAlign("Listado de Facturas", AnchoReporte)
    f.Add stMidAlign("Utilidad Neta", AnchoReporte)
    f.Add stMidAlign("Entre el " + Format(srceFacturas.FechaInicial, "Short Date") + " y el " + Format(srceFacturas.FechaFinal, "Short Date"), AnchoReporte)
    f.Add ""
    f.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(f.Pagina)

    f.Add "---------------------------------------------------------------------------------------------------------------------------------------------------------------------------"
    f.Add "NUMERO      FECHA      CODIGO DEL CLIENTE   Precio Inicial  Devoluciones     Descuentos   INGRESO NETO  Costo Inicial Costo Devuelto     COSTO NETO       Utilidad  % Util."
    f.Add "---------------------------------------------------------------------------------------------------------------------------------------------------------------------------"

    If SubTotInicial > 0 Then
        ImprimirLinea f, "VIENEN", "", "", SubTotInicial, SubTotDevol, SubTotDescuento, SubTotCosto, SubTotCostoDev
    End If

End Sub

Private Sub PasarLinea(f As lfQuickView, pFactura As clsFacturas)

    If doSortByCliente Then
        If pFactura.CodigoCliente <> ControlTag Then
            Ruptura f, pFactura.CodigoCliente
        End If
    ElseIf doSortByVendedor Then
        If pFactura.CodigoVendedor <> ControlTag Then
            Ruptura f, pFactura.CodigoVendedor
        End If
    End If
    
    If f.Linea + 2 > f.LineasPagina Then
        Encabezado f
    End If

    ImprimirLinea f, pFactura.Referencia, Format(pFactura.FechaTransaccion, "Short Date"), pFactura.CodigoCliente, pFactura.PrecioEfectivo, pFactura.PrecioDevuelto, pFactura.DescuentosProntoPago, pFactura.Costo, pFactura.CostoDevuelto

    ' Acumula subtotal por segmento y total general.... es ms fcil, dado que la ruptura es condicional.
    With pFactura
    TotInicial = TotInicial + .PrecioEfectivo
    TotDevol = TotDevol + .PrecioDevuelto
    TotDescuento = TotDescuento + .DescuentosProntoPago
    TotCosto = TotCosto + .Costo
    TotCostoDev = TotCostoDev + .CostoDevuelto
    
    SubTotInicial = SubTotInicial + .PrecioEfectivo
    SubTotDevol = SubTotDevol + .PrecioDevuelto
    SubTotDescuento = SubTotDescuento + .DescuentosProntoPago
    SubTotCosto = SubTotCosto + .Costo
    SubTotCostoDev = SubTotCostoDev + .CostoDevuelto
    End With


End Sub

Public Sub Generar()
Dim sSortParam As String
Dim pFactura As clsFacturas, f As lfQuickView

    Set srceFacturas = New clsFiltroFacturas
    
    doSortByVendedor = srceFacturas.sortByVendedor
    doSortByCliente = srceFacturas.sortByCliente

    Set pFactura = srceFacturas.ProximaFactura
    
    If Not pFactura Is Nothing Then
        
        Screen.MousePointer = vbHourglass
        Set f = New lfQuickView
        f.SetNotify Me
        f.SetReportWidth AnchoReporte
        f.Caption = "Listado de Utilidad en Facturas, entre el " & Format(srceFacturas.FechaInicial, "Short Date") & " y el " & Format(srceFacturas.FechaFinal, "Short Date")
        
        ControlTag = ""
        SubTotInicial = 0: SubTotDevol = 0: SubTotDescuento = 0: SubTotCosto = 0: SubTotCostoDev = 0
        TotInicial = 0: TotDevol = 0: TotDescuento = 0: TotCosto = 0: TotCostoDev = 0

        Encabezado f

        Do
            PasarLinea f, pFactura
            Set pFactura = srceFacturas.ProximaFactura
        Loop While Not pFactura Is Nothing

        If doSortByVendedor Or doSortByCliente Then
            Ruptura f, ""
        End If
        
        ImprimirLinea f, "TOTAL", "GENERAL", "", TotInicial, TotDevol, TotDescuento, TotCosto, TotCostoDev
        Screen.MousePointer = vbDefault
        
        f.Show

        While f.Visible: DoEvents: Wend
        Unload f
        Set f = Nothing

    End If

End Sub

Public Sub ReportClicked(sText As String, nPos As Long)
Dim f As frmConsultarFactura, sRefFact As String

    Select Case nPos
    
    Case 1 To 12
        sRefFact = left(sText, 12)
        sRefFact = Trim(sRefFact)
        ConsultarFactura sRefFact
    
    Case 25 To 45
        sRefFact = Mid(sText, 25, 20)
        sRefFact = Trim(sRefFact)
        ShowFIECliente sRefFact

    End Select

End Sub


