VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaTransferencias"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit


'-------------------------------------------------------------------------------------------------
'Numero Fecha      Operador     Descripcion                              Alm. Origen  Alm. Destino
'-------------------------------------------------------------------------------------------------
'000000 99-99-9999 XXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXX XXXXXXXXXXXX

Private Const AnchoReporte = 93

Private fView As lfQuickView, finic As Date, ffinal As Date

Private Sub PrintLine(sNumero As String, _
                      sFecha As String, _
                      sOperador As String, _
                      sDesc As String, _
                      sAlmacenOrigen As String, _
                      sAlmDest As String)
Dim sOut As String

    sOut = stFullLength(sNumero, 6) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & stFullLength(sOperador, 12) & " "
    sOut = sOut & stFullLength(sDesc, 40) & " "
    sOut = sOut & stFullLength(sAlmacenOrigen, 12) & " "
    sOut = sOut & stFullLength(sAlmDest, 12)
    
    fView.Add sOut

End Sub
Private Sub Encabezado()

    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Listado de Transferencias entre Almacenes", AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    
    fView.Add "-------------------------------------------------------------------------------------------------"
    fView.Add "Numero Fecha      Operador     Descripcion                              Alm. Origen  Alm. Destino"
    fView.Add "-------------------------------------------------------------------------------------------------"

End Sub

Private Sub PasarLinea(lNumero As Long, dFecha As Date, sOperador As String, sDescripcion As String, sAlmacenO As String, sAlmacenD As String)

    If fView.Linea > fView.LineasPagina - 2 Then Encabezado
    
    PrintLine Format(lNumero, "000000"), Format(dFecha, "Short Date"), sOperador, sDescripcion, sAlmacenO, sAlmacenD
    
End Sub

Public Sub Generar()
Dim f As lfSelectRangoFechas, sQuery As String, rs As Recordset

    Set f = New lfSelectRangoFechas
    ShowNonModal f
    If Not f.Result Then
        Unload f
        Set f = Nothing
        Exit Sub
    End If
    
    finic = f.dtFechaInicial.Fecha
    ffinal = f.dtFechaFinal.Fecha
    
    Unload f
    Set f = Nothing
    
    sQuery = "SELECT Numero, FechaTransferencia, Operador, Descripcion, AlmacenOrigen, AlmacenDestino FROM Transferencias "
    sQuery = sQuery & "WHERE FechaTransferencia BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & " "
    sQuery = sQuery & "ORDER BY Numero"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then
    
        Screen.MousePointer = vbHourglass
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.Caption = "Listado de Transferencias de Inventario"
        fView.SetNotify Me

        Encabezado
        
        Do While Not rs.EOF
        
            PasarLinea rs!Numero, rs!FechaTransferencia, rs!Operador, rs!Descripcion, rs!AlmacenOrigen, rs!AlmacenDestino
            rs.MoveNext
        
        Loop
        
        Screen.MousePointer = vbDefault
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
        
    End If
    
    rs.Close
    Set rs = Nothing

End Sub

Public Sub ReportClicked(s As String, p As Long)
Dim sTemp As String, pTransf As clsTransferencia

    sTemp = Trim(s)

    Select Case p
    
    Case 1 To 7
        sTemp = left(sTemp, 6)
        Set pTransf = New clsTransferencia
        If pTransf.Load(Val(sTemp)) Then
            pTransf.Show
        End If
        Set pTransf = Nothing
    
    End Select

End Sub
