VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaTicketsTurno"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 75

Private pTurno As clsParkingTurno
Private SubTotal1 As Currency, SubTotal2 As Currency

'---------------------------------------------------------------------------
'Ticket   Placas   Fecha In Hora  Fecha Sal Hora  Tarifa Horas  Penalizacion
'---------------------------------------------------------------------------
'99999999 XXXXXXXX 99-99-99 99:99 99-99-99 99:99 99.999.999,99 99.999.999,99

Private Sub Encabezado(f As lfQuickView)

    If f.Linea > 1 Or f.Pagina > 1 Then
        f.Add stFullLength("VAN", 48) & FormatNumero(SubTotal1, "##,###,##0.00", 13) & " " & FormatNumero(SubTotal2, "##,###,##0.00", 13)
    End If
    
    f.Add ""
    f.Add Empresa.NombreEmpresa, vbCenter
    f.Add "Relacin de Tickets Cobrados en el Turno", vbCenter
    f.Add ""
    f.Add "Sesin: " & Str(pTurno.SessionID)
    f.Add "Operador: " & pTurno.usrID
    f.Add "Terminal:" & Str(pTurno.MachineID)
    f.Add "Fecha de inicio: " & Format(pTurno.StartTime, "dd-mm-yyyy hh:mm")
    f.Add "Emision del listado: " & Format(Now, "General Date")
    f.Add "Pgina:" & Str(f.Pagina)
    f.Add "---------------------------------------------------------------------------"
    f.Add "Ticket   Placas   Fecha In Hora  Fecha Sal Hora  Tarifa Horas  Penalizacion"
    f.Add "---------------------------------------------------------------------------"

    If f.Pagina > 1 Then
        f.Add stFullLength("VIENEN", 48) & FormatNumero(SubTotal1, "##,###,##0.00", 13) & " " & FormatNumero(SubTotal2, "##,###,##0.00", 13)
    End If

End Sub

Public Sub Generar(ilngNumeroTurno As Long)
Dim f As lfQuickView, rs As Recordset, sQuery As String

    Set pTurno = New clsParkingTurno
    If Not pTurno.Load(ilngNumeroTurno) Then
        mAdvertencia "clsListaTicketsTurno::Error: Numero de turno invlido"
        Set pTurno = Nothing
        Exit Sub
    End If
    
    Screen.MousePointer = vbHourglass
    sQuery = "SELECT * FROM parkingTickets WHERE IDSesion =" & Str(pTurno.SessionID) & " ORDER BY Salida"
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then

        Screen.MousePointer = vbHourglass
        
        Set f = New lfQuickView
        f.SetReportWidth AnchoReporte
        f.Caption = "Relacin de Tickets del Turno"

        SubTotal1 = 0@: SubTotal2 = 0@

        Encabezado f

        Do While Not rs.EOF

            sQuery = Format(rs.Fields("Numero"), "00000000") & " "
            sQuery = sQuery & stFullLength(rs.Fields("Placa"), 8) & " "
            sQuery = sQuery & Format(rs.Fields("Entrada"), "dd-mm-yy hh:mm") & " "
            sQuery = sQuery & Format(rs.Fields("Salida"), "dd-mm-yy hh:mm") & " "
            sQuery = sQuery & FormatNumero(rs.Fields("Bolivares"), "##,###,##0.00", 13) & " "
            sQuery = sQuery & FormatNumero(rs.Fields("Penalizacion"), "##,###,##0.00", 13)
            
            If f.Linea > f.LineasPagina - 2 Then Encabezado f

            SubTotal1 = SubTotal1 + rs.Fields("Bolivares")
            SubTotal2 = SubTotal2 + rs.Fields("Penalizacion")

            f.Add sQuery

            rs.MoveNext

        Loop

        f.Add stFullLength("TOTAL", 48) & FormatNumero(SubTotal1, "##,###,##0.00", 13) & " " & FormatNumero(SubTotal2, "##,###,##0.00", 13)

        Screen.MousePointer = vbDefault
        ShowNonModal f

        Unload f
        Set f = Nothing

    End If

    Set rs = Nothing

End Sub

