VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaSesiones"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 121

Private fView As lfQuickView, finic As Date, ffinal As Date

'Fecha      Operador     Sesion  Q/Fac.   Monto Ventas         I.V.A. Cobros   Monto Cobros         Egresos   Saldo Cierre
'99-99-9999 XXXXXXXXXXXX 000000 999.999 999.999.999,99 999.999.999,99 99.999 999.999.999,99 -999.999.999,99 999.999.999,99

Private lQFact As Long, vmVentas As Currency, _
        vmImpuesto As Currency, lqCobros As Long, _
        vmCobros As Currency, vmEgresos As Currency

Private Sub WriteLinea( _
    sFecha As String, sOperador As String, _
    sSesion As String, qFact As Long, _
    vVentas As Currency, vImpuesto As Currency, _
    qCobros As Long, vCobros As Currency, _
    vEgresos As Currency)
Dim sOut As String, Saldo As Currency

    sOut = stFullLength(sFecha, 10) & " "
    sOut = sOut & stFullLength(sOperador, 12) & " "
    sOut = sOut & stFullLength(sSesion, 6) & " "
    sOut = sOut & FormatNumero(qFact, "###,##0", 7) & " "
    sOut = sOut & FormatNumero(vVentas, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vImpuesto, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(qCobros, "##,##0", 6) & " "
    sOut = sOut & FormatNumero(vCobros, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(-vEgresos, Empresa.MascaraMonetarios, 15) & " "
    Saldo = vVentas + vImpuesto + vCobros - vEgresos
    sOut = sOut & FormatNumero(Saldo, Empresa.MascaraMonetarios, 14) & " "

    fView.Add sOut

End Sub

Private Sub Encabezado()

    If fView.Linea > 1 Or fView.Pagina > 1 Then
        WriteLinea "VAN", "", "", lQFact, vmVentas, vmImpuesto, lqCobros, vmCobros, vmEgresos
        fView.PageBreak
    End If
    
    fView.Add ""
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Resumen de Turnos de Caja", AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)

    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo & ".     Pgina: " & fView.Pagina

    fView.Add String(AnchoReporte, "-")
    fView.Add "Fecha      Operador     Sesion  Q/Fac.   Monto Ventas         I.V.A. Cobros   Monto Cobros         Egresos   Saldo Cierre"
    fView.Add String(AnchoReporte, "-")
    
    If fView.Pagina > 1 Then
        WriteLinea "VAN", "", "", lQFact, vmVentas, vmImpuesto, lqCobros, vmCobros, vmEgresos
    End If

End Sub

' Private lQFact As Long, vmVentas As Currency, _
'        vmImpuesto As Currency, lqCobros As Long, _
'        vmCobros As Currency, vmEgresos As Currency

Private Sub AddLinea( _
    dFecha As Date, sOperador As String, _
    lSesion As Long, qFact As Long, _
    vVentas As Currency, vImpuesto As Currency, _
    qCobros As Long, vCobros As Currency, _
    vEgresos As Currency)

    If fView.Linea > fView.LineasPagina - 2 Then
        Encabezado
    End If

    WriteLinea Format(dFecha, "Short Date"), sOperador, Format(lSesion, "000000"), _
        qFact, vVentas, vImpuesto, qCobros, vCobros, vEgresos

    lQFact = lQFact + qFact
    vmVentas = vmVentas + vVentas
    vmImpuesto = vmImpuesto + vImpuesto
    lqCobros = lqCobros + qCobros
    vmCobros = vmCobros + vCobros
    vmEgresos = vmEgresos + vEgresos

End Sub

Public Sub Generar()
Dim f As lfSelectRangoFechas, b As Boolean
Dim rs As Recordset

    Set f = New lfSelectRangoFechas
    f.Caption = "Resumen de Turnos Caja"
    
    f.Show 1
    
    b = f.Result
    
    If b Then
        finic = f.dtFechaInicial
        ffinal = f.dtFechaFinal
    End If
    
    Unload f
    Set f = Nothing

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute("SELECT * FROM SesionesCerradas WHERE Fecha BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & " ORDER BY Fecha, SessionID")
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then

        Screen.MousePointer = vbHourglass
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.Caption = "Resumen de Turnos de Caja"

        Encabezado

        Do While Not rs.EOF

            AddLinea rs!Fecha, _
                    rs!usrID, _
                    rs!SessionID, _
                    rs!FacturasRealizadas - rs!Anulaciones, _
                    rs!MontoFacturado - rs!MontoAnulaciones, _
                    rs!ImpuestoCobrado - rs!ImpuestoAnulado, _
                    rs!CobrosRealizados, _
                    rs!MontoCobrado, _
                    rs!MontoRetirado
            rs.MoveNext
        
        Loop
        
        WriteLinea "TOTAL", "", "", lQFact, vmVentas, vmImpuesto, lqCobros, vmCobros, vmEgresos
        
        Screen.MousePointer = vbDefault
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
    
    End If
    
    rs.Close
    Set rs = Nothing

End Sub
