VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaSerialesProducto"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'EMPRESA (centrar)
'Listado de Seriales
'Artculo: xxxxxxxxxx (CCCCCC)
'
'Emision:zxxzxzxzxzxzxxz  Operador: opopopoppoopo                                                                                                   Pgina: 9999
'--------------------------------------------------------------------------------------------------------------------------------------------------------------
'                     U L T I M A   E N T R A D A                                          U L T I M A   S A L I D A
'Serial               Fecha      Referencia       Descripcion                              Fecha      Referencia       Descripcion
'--------------------------------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX 99-99-9999 XXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99-99-9999 XXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

Private Const AnchoReporte = 158
Private fView As lfQuickView
Private pItem As clsItemInventario
Private pSerial As clsSeriales

Private Sub Encabezado()

    If fView.Linea > 1 Then
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Listado de Seriales", vbCenter
    fView.Add "Articulo: " & pItem.Descripcion & " (" & pItem.Codigo & ")", vbCenter
    fView.Add ""
    
    fView.Add stFullLength("Emisin: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo, AnchoReporte - 12) & "Pgina: " & Format(fView.Pagina, "0000")
    fView.Add String(AnchoReporte, "-")
    fView.Add "                     U L T I M A   E N T R A D A                                           U L T I M A   S A L I D A"
    fView.Add "Serial               Fecha      Referencia       Descripcion                               Fecha      Referencia       Descripcion"
    fView.Add String(AnchoReporte, "-")

End Sub

Private Function TipoListado() As Integer
Dim s As String, nRetVal As Integer

    Do
        s = InputBox("Escriba:" & vbCrLf & "  1: para incluir slo seriales entregados" & vbCrLf & "  2: para incluir slo seriales en stock" & vbCrLf & "  3: Para incluir todos los seriales", "Seleccione el tipo de listado", "3")
        If s = "" Then
            TipoListado = 0
            Exit Function
        End If
        
        nRetVal = Val(s)
        
        If nRetVal < 1 Or nRetVal > 3 Then
            mAdvertencia "Introduzca un valor entre 1 y 3, o deje en blanco para cancelar"
        End If
    Loop While nRetVal < 1 Or nRetVal > 3
    
    TipoListado = nRetVal

End Function

Private Sub PasarLinea(ipSerial As clsSeriales)
Dim pDetalle As clsDetalleSerial, sOut As String
Dim pInstancer As clsInstanciadorEntidad, pObject As Object
Dim strSerial As String

    Set pInstancer = New clsInstanciadorEntidad
    strSerial = ipSerial.Serial
    If ipSerial.Locked Then strSerial = strSerial & "*"
    sOut = stFullLength(strSerial, 21)
    Set pDetalle = ipSerial.UltimaEntrada
    If pDetalle Is Nothing Then
        sOut = sOut & stFullLength(" ERROR: No hay entradas registradas!!!", 67)
    Else
        Set pObject = pInstancer.EntidadDOCUMENTO(pDetalle.TipoDocumento, pDetalle.NumeroDocumento)
        sOut = sOut & stFullLength(Format(pDetalle.Fecha, "Short Date"), 10) & " "
        sOut = sOut & stFullLength(IIf(pObject Is Nothing, "INVALIDO!", pObject.Referencia), 16) & " "
        sOut = sOut & stFullLength(IIf(pObject Is Nothing, "INVALIDO!", pObject.Descripcion), 40)
    End If
    sOut = sOut & " "
    Set pDetalle = ipSerial.UltimaSalida
    If Not pDetalle Is Nothing Then
        Set pObject = pInstancer.EntidadDOCUMENTO(pDetalle.TipoDocumento, pDetalle.NumeroDocumento)
        sOut = sOut & stFullLength(Format(pDetalle.Fecha, "Short Date"), 10) & " "
        sOut = sOut & stFullLength(IIf(pObject Is Nothing, "INVALIDO!", pObject.Referencia), 16) & " "
        sOut = sOut & stFullLength(IIf(pObject Is Nothing, "INVALIDO!", pObject.Descripcion), 40)
    End If
    
    If fView.Linea > fView.LineasPagina - 3 Then Encabezado

    fView.Add sOut

End Sub

Public Sub Generar(istrCodigoItem As String)
Dim lpSerial As clsSeriales, nOrgPROR As Integer
Dim nListado As Integer

    Set pItem = AlmacenItemsInventario.itemInventario(istrCodigoItem)
    If pItem Is Nothing Then
        mAdvertencia "ERROR: Artculo no localizado en clsListaSerialesProducto::Generar"
        Exit Sub
    End If

    If pItem.UsaSeriales = 0 Then
        mAdvertencia "ERROR: Articulo no usa seriales. clsListaSerialesProducto::Generar"
        Set pItem = Nothing
        Exit Sub
    End If

    nListado = TipoListado
    If nListado = 0 Then Exit Sub

    Set pSerial = New clsSeriales

    If pSerial.IniciarIteradorSerialesProducto(istrCodigoItem, nListado - 1) Then
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.SetNotify Me

        Encabezado
        
        nOrgPROR = -1
        On Error Resume Next
        nOrgPROR = Printer.Orientation
        On Error Resume Next
        Printer.Orientation = vbPRORLandscape

        Do
            Set lpSerial = pSerial.NextItemSerialesProducto
            If Not lpSerial Is Nothing Then
                PasarLinea lpSerial
            End If
        Loop While Not lpSerial Is Nothing

        ShowNonModal fView

        Unload fView
        Set fView = Nothing

        If nOrgPROR >= 0 Then
            On Error Resume Next
            Printer.Orientation = nOrgPROR
        End If

    End If

    Set pSerial = Nothing
    Set pItem = Nothing

End Sub

Public Sub ReportClicked(strLinea As String, ByVal ilnPosicion As Long)
Dim pListaDetalles As clsListaDetallesSerial

    Set pListaDetalles = New clsListaDetallesSerial
    pListaDetalles.Generar pItem, Trim(Left(strLinea, 21))
    Set pListaDetalles = Nothing

End Sub
