VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaSaldosCXP"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 91
Private fView As lfQuickView
Private TotalSaldo As Currency
Private rs As Recordset

Private Sub Encabezado()
Dim sOut As String

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        PasarLinea "VAN", "", 0#, TotalSaldo, True
        fView.PageBreak
    End If

    fView.Add ""

    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Listado de Saldos de Clientes", AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo & ".     Pgina: " & fView.Pagina
    
    fView.Add String(AnchoReporte, "-")
    fView.Add "Cdigo Proveedor     Nombre                                     Lim. Credito          Saldo"
    fView.Add String(AnchoReporte, "-")

    If fView.Pagina > 1 Then
        PasarLinea "VIENEN", "", 0#, TotalSaldo, True
    End If

End Sub

Private Sub PrintLinea(sCodigo As String, sNombre As String, vmLimite As Currency, vmSaldo As Currency)
Dim sOut As String, i As Integer

    sOut = sOut & stFullLength(sCodigo, 21)
    sOut = sOut & stFullLength(sNombre, 41)
    sOut = sOut & FormatNumero(vmLimite, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmSaldo, Empresa.MascaraMonetarios, 14)
    fView.Add sOut

End Sub

'-------------------------------------------------------------------------------------------
'Cdigo de Cliente    Nombre                                     Lim. Credito          Saldo
'-------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999,99

Private Sub PasarLinea(sCodigo As String, sNombre As String, vmLimite As Currency, vmSaldo As Currency, Optional FromEncabezado As Boolean = False)

    If Not FromEncabezado Then If fView.Linea > fView.LineasPagina - 2 Then Encabezado
    PrintLinea sCodigo, sNombre, vmLimite, vmSaldo
    If Not FromEncabezado Then TotalSaldo = TotalSaldo + vmSaldo

End Sub

Public Sub Generar()
Dim sQuery As String, sCondCli As String
Dim bResult As Boolean
Dim i As Integer, f As frmFiltroProveedores

    sCondCli = ""
    Set f = New frmFiltroProveedores
    f.SetInterval False
    f.Show
    Do While f.Visible: DoEvents: Loop
    bResult = f.Result
    If bResult Then sCondCli = Trim(f.FiltroSQL("P"))
    Unload f
    Set f = Nothing

    If Not bResult Then Exit Sub

    sQuery = "SELECT Codigo, Nombre, LimiteCredito, SaldoActual FROM Proveedores P WHERE P.SaldoActual <> 0"
    If sCondCli <> "" Then sQuery = sQuery & " AND " & sCondCli

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault
    
    If Not rs.EOF Then
        
        Screen.MousePointer = vbDefault
        Set fView = New lfQuickView
        fView.Caption = "Lista general de saldos con los proveedores"
        
        Encabezado

        Do
            PasarLinea rs!Codigo, rs!Nombre, rs!LimiteCredito, rs!SaldoActual
            rs.MoveNext
        Loop While Not rs.EOF

        PrintLinea "TOTAL GENERAL", "", 0, TotalSaldo

        fView.Caption = "Saldos de los Proveedores"
        fView.SetNotify Me
        Screen.MousePointer = vbDefault
        fView.Show
        While fView.Visible: DoEvents: Wend
        Unload fView
        Set fView = Nothing
    
    End If
    
    rs.Close
    Set rs = Nothing
    
End Sub

Public Sub ReportClicked(sLinea As String, lClickPos As Long)
Dim pProveedor As clsProveedores, sPalabra As String, slLinea As String

    slLinea = Trim(sLinea)
    sPalabra = Trim(left(sLinea, 20))
    
    Set pProveedor = New clsProveedores

    If pProveedor.Load(sPalabra) Then
    
        If lClickPos < 76 Then
            pProveedor.Show
        Else
            Dim RDPENT As clsRepDocumentosEntidad
        
            Set RDPENT = New clsRepDocumentosEntidad
            RDPENT.Go pProveedor.TipoEntidad, pProveedor.Codigo, pProveedor.Nombre, "Proveedor"
            Set RDPENT = Nothing

        End If
    End If
    
    Set pProveedor = Nothing

End Sub


