VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaRetenciones"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 63

Private totPagado As Currency, totRetencion As Currency
Private subPagado As Currency, subRetencion As Currency
Private WithEvents fView As lfQuickView, finic As Date, ffinal As Date
Attribute fView.VB_VarHelpID = -1
Private ControlTag As String, TagName As String, TagRIF As String

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim sExtract As String, isDate As Boolean, dtFecha As Date, sTipoDoc As String

  bProcessed = True
  sExtract = Trim(left(Trim(strReportLine), 10))
  isDate = True
  On Error Resume Next
  dtFecha = CDate(sExtract)
  If Err.Number Then isDate = False
  
  If isDate Then
    Dim pObject As Object, pInstancer As clsInstanciadorEntidad, strTipoEntidad As String
  
    sExtract = Trim(Mid(strReportLine, 12, 20))
    Set pInstancer = New clsInstanciadorEntidad
    sTipoDoc = left(sExtract, 3)
    sExtract = right(sExtract, Len(sExtract) - 3)

    Set pObject = pInstancer.EntidadDOCUMENTOByRef(sTipoDoc, sExtract)
    If Not pObject Is Nothing Then
      pObject.Show
      Set pObject = Nothing
    End If
    Set pInstancer = Nothing
  
  Else
    Dim pProveedor As clsProveedores
    
    sExtract = sExtractRightCode(strReportLine)
    Set pProveedor = AlmacenProveedores.Proveedor(sExtract)
    If Not pProveedor Is Nothing Then
      pProveedor.Show
      Set pProveedor = Nothing
    End If
  
  End If

End Sub

'Fecha      Documento            Monto del Pago      Retencin
'99-99-9999 XXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999,99

Private Sub WriteLinea(sFecha As String, sDocumento As String, vPago As Currency, vRetencion As Currency)
Dim sOut As String

    sOut = stFullLength(sFecha, 10) & " "
    sOut = sOut & stFullLength(sDocumento, 20) & " "
    sOut = sOut & FormatNumero(vPago, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vRetencion, Empresa.MascaraMonetarios, 14) & " "

    fView.Add sOut

End Sub

Private Sub Encabezado(isRuptura As Boolean)

    If fView.Pagina > 1 Or fView.Linea > 1 Then

        If Not isRuptura Then
            WriteLinea "VAN", "", subPagado, subRetencion
        End If

        fView.PageBreak

    End If

    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Relacin de I.S.L.R. Retenido", AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(fView.Pagina)

    fView.Add String(AnchoReporte, "-")
    fView.Add "Fecha      Documento            Monto del Pago      Retencin"
    fView.Add String(AnchoReporte, "-")

    If fView.Pagina > 1 Then

        If Not isRuptura Then

            fView.Add "PROVEEDOR: " & TagName & ", RIF: " & TagRIF & "  (" & ControlTag & ")"
            WriteLinea "VIENEN", "", subPagado, subRetencion

        End If

    End If

End Sub

Private Sub Ruptura(sTag As String)
Dim pProveedor As clsProveedores

    If fView.Linea > fView.LineasPagina - 5 Then
        
        Encabezado True

    End If

    If ControlTag <> "" Then

        WriteLinea "SUB TOTAL", "PROVEEDOR", subPagado, subRetencion
        totPagado = totPagado + subPagado
        totRetencion = totRetencion + subRetencion

    End If

    ControlTag = sTag
    subPagado = 0
    subRetencion = 0
    
    If sTag = "" Then Exit Sub

    Set pProveedor = New clsProveedores

    If pProveedor.Load(ControlTag) Then
        TagName = pProveedor.Nombre
        TagRIF = pProveedor.RIF
    Else
        TagName = "DESAPARECIDO"
        TagRIF = "N/A"
    End If

    fView.Add ""
    fView.Add "PROVEEDOR: " & TagName & ", RIF: " & TagRIF & "  (" & ControlTag & ")"

End Sub

Private Sub PasarLinea(sCodProv As String, dFecha As Date, sDocumento As String, vPago As Currency, vRetencion As Currency)

    If fView.Linea > fView.LineasPagina - 2 Then
        Encabezado False
    End If
    
    If sCodProv <> ControlTag Then
    
        Ruptura sCodProv

    End If
    
    subPagado = subPagado + vPago
    subRetencion = subRetencion + vRetencion
    
    WriteLinea Format(dFecha, "Short Date"), sDocumento, vPago, vRetencion

End Sub

Public Sub Generar()
Dim f As lfSelectRangoFechas, b As Boolean

    Set f = New lfSelectRangoFechas
    f.Show 1
    b = f.Result

    If b Then
        finic = f.dtFechaInicial
        ffinal = f.dtFechaFinal
    End If
    
    Unload f
    Set f = Nothing
    
    If Not b Then Exit Sub

Dim rs As Recordset
        
    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute("SELECT * FROM RetencionesISLR WHERE Fecha BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & " ORDER BY CodigoProveedor, Fecha")
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then

        Screen.MousePointer = vbHourglass

        ControlTag = ""
        subPagado = 0: subRetencion = 0
        totPagado = 0: totRetencion = 0
        
        Set fView = New lfQuickView

        fView.SetReportWidth AnchoReporte
        fView.Caption = "Relacion de Impuestos Retenidos"

        Encabezado True

        Do While Not rs.EOF
        
            PasarLinea rs!CodigoProveedor, rs!Fecha, rs!RefDocumento, rs!MontoPagado, rs!MontoRetenido
            rs.MoveNext

        Loop
        
        Ruptura ""
        WriteLinea "TOTAL", "TOTAL GENERAL", totPagado, totRetencion

        Screen.MousePointer = vbDefault

        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing

    End If

    rs.Close
    Set rs = Nothing

End Sub

