VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaRetIVA"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'---------------------------------------------------------------------------------------------
'Fecha      Factura      RIF           Cliente                                       Retencion
'---------------------------------------------------------------------------------------------
'99-99-9999 xxx-00000000 XXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99

'SELECT R.CodigoCliente, F.Serie & "-" & Format(F.Correlativo, '00000000') AS Referencia, F.NombreCliente, C.Rif, R.MontoRetencion, R.FechaCobro
'FROM RetencionesIVA AS R, Facturas AS F, Clientes AS C
'WHERE R.FechaCobro BETWEEN paramFinic And paramFFinal
'AND F.Numero = R.NumFactura
'AND C.Codigo = R.CodigoCliente
'ORDER BY R.FechaCobro;

Private fView As lfQuickView
Private Const AnchoReporte = 93
Private finic As Date, fFinal As Date
Private vmTotalRetenciones As Currency

Private Sub PasarLineaTotal(sTitulo As String)
Dim sOut As String

  sOut = stFullLength(sTitulo, 79) & FormatNumero(vmTotalRetenciones, Empresa.MascaraMonetarios, 14)
  fView.Add sOut
  
End Sub

Private Sub Encabezado()

  With fView
  
  If .Linea > 1 Then
    PasarLineaTotal "VAN"
    .PageBreak
  End If
  
  .Add ""
  .Add Empresa.NombreEmpresa, vbCenter
  .Add "IVA Retenido por Contribuyentes Especiales", vbCenter
  .Add "Entre el " & Format(finic, "Short Date") & " y el " & Format(fFinal, "Short Date"), vbCenter
  .Add ""
  .Add "Emision: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo & ".     Pgina: " & fView.Pagina
  .Add String(AnchoReporte, "-")
  .Add "Fecha      Factura      RIF           Cliente                                       Retencion"
  .Add String(AnchoReporte, "-")
  
  If .Pagina > 1 Then
    PasarLineaTotal "VIENEN"
  End If
  End With

End Sub

'---------------------------------------------------------------------------------------------
'Fecha      Factura      RIF           Cliente                                       Retencion
'---------------------------------------------------------------------------------------------
'99-99-9999 xxx-00000000 XXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99

Private Sub PasarLinea(dtFecha As Date, sRef As String, sRif As String, sCliente As String, vmRetencion As Currency)
Dim sOut As String

  If fView.Linea > fView.LineasPagina - 4 Then
    Encabezado
  End If
  
  sOut = stFullLength(Format(dtFecha, "Short Date"), 10) & " "
  sOut = sOut & stFullLength(sRef, 12) & " "
  sOut = sOut & stFullLength(sRif, 13) & " "
  sOut = sOut & stFullLength(sCliente, 40) & " "
  sOut = sOut & FormatNumero(vmRetencion, Empresa.MascaraMonetarios, 14)
  
  fView.Add sOut
  vmTotalRetenciones = vmTotalRetenciones + vmRetencion

End Sub

Public Sub Go()
Dim sQuery As String, rs As Recordset

  If Not GetRangoFechas(finic, fFinal, "Seleccione el perodo de consulta") Then
    Exit Sub
  End If
  
  sQuery = "SELECT R.CodigoCliente, F.Serie, F.Correlativo, F.NombreCliente, C.Rif, R.MontoRetencion, R.FechaCobro "
  sQuery = sQuery & "FROM RetencionesIVA AS R, Facturas AS F, Clientes AS C "
  sQuery = sQuery & "WHERE R.FechaCobro BETWEEN " & FechaDB(finic) & " AND " & FechaDB(fFinal) & " "
  sQuery = sQuery & "AND F.Numero = R.NumFactura "
  sQuery = sQuery & "AND C.Codigo = R.CodigoCliente "
  sQuery = sQuery & "ORDER BY R.FechaCobro, R.NumFactura;"
  
  Set rs = dbHandle.Execute(sQuery)
  
  If Not rs.EOF Then
    vmTotalRetenciones = 0
    Set fView = New lfQuickView
    fView.SetReportWidth AnchoReporte
    Encabezado
    
    Do While Not rs.EOF
      PasarLinea GetDateFromVariant(rs!FechaCobro), GetStringFromVariant(rs!Serie) & "-" & Format(GetNumeroFromVariant(rs!Correlativo), "0000000"), GetStringFromVariant(rs!RIF), GetStringFromVariant(rs!NombreCliente), GetNumeroFromVariant(rs!MontoRetencion)
      rs.MoveNext
    Loop
    
    PasarLineaTotal "TOTAL PAGADO A CONTRIBUYENTES ESPECIALES"
    
    ShowNonModal fView
    Unload fView
    Set fView = Nothing
  End If
  
  rs.Close
  Set rs = Nothing

End Sub
