VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaResumenZ"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 133
' <Nombre Empresa>
' Totales de Cierres Diarios
' Periodo entre el 99-99-9999 y el 99-99-999
'
'Emisin: 99-99-9999 99:99   Operador: XXXXXXXX                                            Pgina: 9999
'------------------------------------------------------------------------------------------------------------------------------------
'Term.  Desde  Hasta Q.Fact.   Desde  Hasta         Exento        Base VG    Impuesto VG       Base PRE   Impuesto PRE          Total
'------------------------------------------------------------------------------------------------------------------------------------
'99999 999999 999999 9999999 9999999 999999 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99
'123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012

Private tQFacturas, tQCierres, tExento, tGravable1, tImpuesto1, tGravable2, tImpuesto2
Private fView As lfQuickView, dtInicial As Date, dtFinal As Date


Private Sub Encabezado()

    If fView.Linea > 1 Then
        DisplayTotal "VAN"
        fView.PageBreak
    End If
    
    fView.Add ""
    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "RIF: " & Empresa.RIF, vbCenter
    Dim i As Integer
    i = 0
    Do
      Dim sEnv As String
      sEnv = GetSetting("ClearLight", "General", "LineasLV" & Trim(i))
      If sEnv <> "" Then
        fView.Add sEnv, vbCenter
      Else
        Exit Do
      End If
      i = i + 1
    Loop
    
    fView.Add "Totales de Cierres Diarios por Terminal", vbCenter
    fView.Add "Entre el " & Format(dtInicial, "Short Date") & " y el " & Format(dtFinal, "Short Date"), vbCenter
    fView.Add ""
    fView.Add stFullLength("Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".", AnchoReporte - 12) & "Pgina:" & Format(fView.Pagina, "0000")
    
    fView.Add String(AnchoReporte, "-")
    fView.Add "Term.  Desde  Hasta Q.Fact.   Desde   Hasta         Exento " & stRightAlign(GetSetting("ClearLight", "General", "BaseVG", "Base VG"), 14) & " " & stRightAlign(GetSetting("ClearLight", "General", "ImpuestoVG", "Impuesto VG"), 14) & " " & stRightAlign(GetSetting("ClearLight", "General", "BaseTP", "Base TP"), 14) & " " & stRightAlign(GetSetting("ClearLight", "General", "ImpuestoTP", "Impuesto TP"), 14) & "          Total"
    fView.Add String(AnchoReporte, "-")

    If fView.Pagina > 1 Then
        DisplayTotal "VIENEN"
    End If

End Sub

'Term.  Desde  Hasta Q.Fact.   Desde   Hasta         Exento        Base VG    Impuesto VG       Base PRE   Impuesto PRE          Total
'------------------------------------------------------------------------------------------------------------------------------------
'99999 999999 999999 9999999 9999999 9999999 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99
'123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012

Private Sub DisplayTotal(strTitulo As String)
Dim sOut As String

    sOut = stFullLength(strTitulo, 19) & " "
    sOut = sOut & FormatNumero(tQFacturas, "######0", 7) & String(17, " ")
    sOut = sOut & FormatNumero(tExento, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tGravable1, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tImpuesto1, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tGravable2, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tImpuesto2, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tImpuesto1 + tImpuesto2 + tExento + tGravable1 + tGravable2, Empresa.MascaraMonetarios, 14)
    
    fView.Add sOut

End Sub

Private Sub AddLinea(ByVal lTermID As Long, ByVal lPrimerCierre As Long, _
        ByVal lUltimoCierre As Long, ByVal lqFacturas As Long, ByVal lPrimeraFactura As Long, _
        ByVal lUltimaFactura As Long, ByVal vmGravable1 As Currency, ByVal vmExento As Currency, _
        ByVal vmImpuesto1 As Currency, vmGravable2 As Currency, vmImpuesto2 As Currency)
Dim sOut As String
    
    If fView.Linea > fView.LineasPagina - 3 Then
        Encabezado
    End If

    tQFacturas = tQFacturas + lqFacturas
    tExento = tExento + vmExento
    tGravable1 = tGravable1 + vmGravable1
    tImpuesto1 = tImpuesto1 + vmImpuesto1
    tGravable2 = tGravable2 + vmGravable2
    tImpuesto2 = tImpuesto2 + vmImpuesto2

    sOut = Format(lTermID, "00000") & " "
    sOut = sOut & Format(lPrimerCierre, "000000") & " " & Format(lUltimoCierre, "000000") & " "
    sOut = sOut & FormatNumero(lqFacturas, "######0", 7) & " " & Format(lPrimeraFactura, "0000000") & " "
    sOut = sOut & Format(lUltimaFactura, "0000000") & " "
    sOut = sOut & FormatNumero(vmExento, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmGravable1, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmImpuesto1, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmGravable2, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmImpuesto2, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmImpuesto1 + vmExento + vmGravable1 + vmImpuesto2 + vmGravable2, Empresa.MascaraMonetarios, 14)
    
    fView.Add sOut

End Sub

Public Sub Generar(ByVal dtFechaInicial As Date, ByVal dtFechaFinal As Date)
Dim stQuery As String, rs As Recordset

    dtInicial = dtFechaInicial: dtFinal = dtFechaFinal
    
    stQuery = "SELECT idTerminal, Count(Numero) AS qCierres, Min(Numero) AS PrimerCierre, Max(Numero) AS UltimoCierre, "
    stQuery = stQuery & "Sum(qFacturas) AS TotalFacturas, Min(PrimeraFactura) AS FactInicial, Max(UltimaFactura) AS FactFinal, "
    stQuery = stQuery & "Sum(Turnos) AS fTurnos, Sum(Gravable1) AS fGravable1, Sum(Exento) AS fExento, Sum(Impuesto1) AS fImpuesto1, "
    stQuery = stQuery & "Sum(Servicio) AS fServicio, Sum(Gravable2) AS fGravable2, Sum(Impuesto2) AS fImpuesto2 "
    stQuery = stQuery & "FROM CierresZ WHERE Apertura BETWEEN " & FechaDB(dtFechaInicial) & " AND " & FechaDB(dtFechaFinal) & " "
    stQuery = stQuery & "GROUP BY idTerminal ORDER BY idTerminal;"

    Set rs = dbHandle.Execute(stQuery)
    
    If Not rs.EOF Then

        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.Caption = "Totales de Cierres Diarios"

        Encabezado
        
        With rs
        Do While Not .EOF

'idTerminal, qCierres, PrimerCierre, UltimoCierre, TotalFacturas, FactInicial, FactFinal
'fTurnos, fGravable, fExento, fImpuesto, fServicio

            AddLinea GetNumeroFromVariant(.Fields("idTerminal")), GetNumeroFromVariant(rs.Fields("PrimerCierre")), _
                GetNumeroFromVariant(.Fields("UltimoCierre")), GetNumeroFromVariant(.Fields("TotalFacturas")), _
                GetNumeroFromVariant(.Fields("FactInicial")), GetNumeroFromVariant(.Fields("FactFinal")), _
                GetNumeroFromVariant(.Fields("fGravable1")), GetNumeroFromVariant(.Fields("fExento")), _
                GetNumeroFromVariant(.Fields("fImpuesto1")), GetNumeroFromVariant(.Fields("fGravable2")), _
                GetNumeroFromVariant(.Fields("fImpuesto2"))

            rs.MoveNext
            
        Loop
        End With
        
        DisplayTotal "TOTAL"
        
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing

    End If

    Set rs = Nothing

End Sub
