VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaResEquipos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 47
Private fView As lfQuickView

'-----------------------------------------------
'Cod.Tipo Descripcion del Tipo          Unidades
'-----------------------------------------------
'XXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999

Private Sub Encabezado()

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Listado Detallado de Equipos en el Taller", vbCenter
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add "Cod.Tipo Descripcion del Tipo          Unidades"
    fView.Add String(AnchoReporte, "-")

End Sub


Public Sub Generar()
Dim sQuery As String, rs As Recordset
Dim sTipo As String, sDesc As String, lQ As Long


    sQuery = "SELECT E.TipoEquipo, T.Descripcion, Count(E.TipoEquipo) AS Cantidad FROM rwsEquipos AS E, rwsTiposEquipo AS T Where E.TipoEquipo = t.Codigo AND E.EStado BETWEEN 1 AND 3 GROUP BY E.TipoEquipo, T.Descripcion ORDER BY E.TipoEquipo"
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    
    If Not rs.EOF Then

        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        Encabezado
        
        Do While Not rs.EOF
        
            sTipo = stGetStringFromVariant(rs.Fields("TipoEquipo"))
            sDesc = stGetStringFromVariant(rs.Fields("Descripcion"))
            lQ = GetNumeroFromVariant(rs.Fields("Cantidad"))
            
            If fView.Linea + 1 >= fView.LineasPagina Then Encabezado

            fView.Add stFullLength(sTipo, 9) & stFullLength(sDesc, 31) & FormatNumero(lQ, "###,##0", 7)
            
            rs.MoveNext
        
        Loop
        
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
        
    End If
    
    Set rs = Nothing

End Sub
