VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaProveedores"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Const AnchoReporte = 92

'--------------------------------------------------------------------------------------------
'Codigo               Nombre / Direccion                       Telfono
'--------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

Private WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1

Private Sub Encabezado()
Dim sOut As String, sFiller As String

  If fView.Linea > 1 Then
    fView.PageBreak
  End If
  fView.Add ""
  fView.Add Empresa.NombreEmpresa, vbCenter
  fView.Add "Directorio de Proveedores", vbCenter
  fView.Add ""

  sOut = "Emision: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo & "."
  If AnchoReporte - (Len(sOut) + 11) > 0 Then
    sFiller = Space(AnchoReporte - (Len(sOut) + 11))
  Else
    sFiller = ""
  End If

  sOut = sOut & sFiller & "Pgina: " & Format(fView.Pagina, "000")
  fView.Add sOut

  fView.Add String(AnchoReporte, "-")
  fView.Add "Codigo               Nombre / Direccion                       Telfono"
  fView.Add String(AnchoReporte, "-")

End Sub

Private Sub PasarLinea(sCodigo As String, sNombre As String, sDireccion As String, sTelefono As String)
Dim v As Variant, i As Integer
Dim sOut As String, nLineas As Integer

  If sDireccion = "" Then
    nLineas = 0
  Else
    v = vslib.Convert2Lines(sDireccion, 40)
    nLineas = UBound(v)
  End If
  
  If fView.Linea + nLineas + 2 > fView.LineasPagina Then
    Encabezado
  End If

  sOut = stFullLength(sCodigo, 20) & " "
  sOut = sOut & stFullLength(sNombre, 40) & " "
  sOut = sOut & stFullLength(sTelefono, 30)
  
  fView.Add sOut

  For i = 1 To nLineas
    fView.Add Space(21) & v(i)
  Next
  
End Sub

Public Sub Generar()
Dim sQuery As String, sCondCli As String
Dim bResult As Boolean, rs As Recordset
Dim i As Integer, f As frmFiltroProveedores

    sCondCli = ""
    Set f = New frmFiltroProveedores
    f.Show
    Do While f.Visible: DoEvents: Loop
    bResult = f.Result
    If bResult Then sCondCli = Trim(f.FiltroSQL("C"))
    Unload f
    Set f = Nothing

    If Not bResult Then Exit Sub

    sQuery = "SELECT Codigo, Nombre, Telefono, Direccion1, Direccion2, Direccion3, Direccion4 FROM Proveedores C "
    If sCondCli <> "" Then
      sQuery = sQuery & " WHERE " & sCondCli
    End If
    sQuery = sQuery & " ORDER BY Nombre"

    Screen.MousePointer = vbHourglass

    Set rs = dbHandle.Execute(sQuery)
    
    If Not rs.EOF Then
        Set fView = New lfQuickView
        fView.Caption = "Directorio de Proveedores"
        fView.SetReportWidth AnchoReporte

        Encabezado

        Do
            PasarLinea GetStringFromVariant(rs.Fields("Codigo")), GetStringFromVariant(rs.Fields("Nombre")), GetStringFromVariant(rs.Fields("Direccion1")) & GetStringFromVariant(rs.Fields("Direccion2")) & GetStringFromVariant(rs.Fields("Direccion3")) & GetStringFromVariant(rs.Fields("Direccion4")), GetStringFromVariant(rs.Fields("Telefono"))
            rs.MoveNext
        Loop While Not rs.EOF
        
        Screen.MousePointer = vbDefault

        fView.Show
        While fView.Visible: DoEvents: Wend
        Unload fView
        Set fView = Nothing
        
    End If
    
    rs.Close
    Set rs = Nothing
    Screen.MousePointer = vbDefault
    
End Sub

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim pCliente As clsProveedores

  Set pCliente = New clsProveedores
  If pCliente.Load(Trim(left(strReportLine, 21))) Then
    pCliente.Show
  End If
  Set pCliente = Nothing

End Sub

