VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaProductosSesion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'------------------------------------------------------------------------------------------------------------------------------------------------
'Codigo               Descripcin                                          Precio Unit.     Cantidad          Total            IVA  Total General
'------------------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 9.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99
'TOTALES                                                                                             999.999.999,99 999.999.999,99 999.999.999,99
'                                                                                                         SubTotal1      SubTotal2      SubTotal3
Private pSesion As clsSesionPOS
Private SubTotal1 As Currency, SubTotal2 As Currency, SubTotal3 As Currency
Private sTag As String, Total1 As Currency, Total2 As Currency, sDescLinea

Private Sub PrintLineaListaProducto(fView As lfQuickView, sCodigoProducto As String, sDescripcion As String, vmPrecioUnitario As Currency, vmCantidad As Currency, vmTotal As Currency, vmIVA As Currency)
Dim vmTotalIngreso As Currency, sOut As String

    vmTotalIngreso = vmTotal + vmIVA
    sOut = stFullLength(sCodigoProducto, 20) & " "
    sOut = sOut & stFullLength(sDescripcion, 50) & " "
    sOut = sOut & FormatNumero(vmPrecioUnitario, Empresa.MascaraPrecios, 14) & " "
    sOut = sOut & FormatNumero(vmCantidad, Empresa.MascaraCantidades, 12) & " "
    sOut = sOut & FormatNumero(vmTotal, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmIVA, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmTotalIngreso, Empresa.MascaraMonetarios, 14)
    
    fView.Add sOut

End Sub

Private Sub EncabezadoListaProductos(f As lfQuickView)
    
    If SubTotal1 <> 0 Or SubTotal2 <> 0 Then
        PrintLineaListaProducto f, "VAN", "", 0, 0, SubTotal1, SubTotal2
    End If
    
    If f.Linea > 1 Then
      f.PageBreak
    End If
    
    f.Add ""
    f.Add stMidAlign(Empresa.NombreEmpresa, f.ReportWidth)
    f.Add stMidAlign("Relacin de Productos Vendidos en el Turno", f.ReportWidth)
    f.Add ""
    f.Add "Sesin: " & Str(pSesion.SessionID)
    f.Add "Operador: " & pSesion.usrID
    f.Add "Terminal:" & Str(pSesion.MachineID)
    f.Add "Fecha de inicio: " & Format(pSesion.Fecha, "General Date")
    f.Add "Emision del listado: " & Format(Now, "General Date")
    f.Add "Pgina:" & Str(f.Pagina)
    f.Add "------------------------------------------------------------------------------------------------------------------------------------------------"
    f.Add "Codigo               Descripcin                                          Precio Unit.     Cantidad          Total            IVA  Total General"
    f.Add "------------------------------------------------------------------------------------------------------------------------------------------------"

    If SubTotal1 <> 0 Or SubTotal2 <> 0 Then
        PrintLineaListaProducto f, "VIENEN", "", 0, 0, SubTotal1, SubTotal2
    End If

End Sub

Private Sub CheckRuptura(f As lfQuickView, sLinea As String)
Dim s As String, p As clsTablaCodigos
  If sLinea <> sTag Then
    If sTag <> "ANDAPALAVERGAMOLLEJUO" Then
      Set p = Lineas.Item(sTag)
      If p Is Nothing Then
        s = "LINEA NO DEFINIDA (" & sTag & ")"
      Else
        s = p.Descripcion
      End If
      PrintLineaListaProducto f, "TOTAL LINEA", s, 0, 0, SubTotal1, SubTotal2
      Total1 = Total1 + SubTotal1: Total2 = Total2 + SubTotal2
    End If
    
    SubTotal1 = 0: SubTotal2 = 0
    If f.Linea > f.LineasPagina - 5 Then
      EncabezadoListaProductos f
    End If
    
    If sLinea <> "ANDAPALAVERGAMOLLEJUO" Then
      Set p = Lineas.Item(sLinea)
      If p Is Nothing Then
        s = "LINEA NO DEFINIDA (" & sTag & ")"
      Else
        s = "LINEA: " & p.Descripcion & " (" & sLinea & ")"
      End If
      f.Add s
    End If
    
    sTag = sLinea
  End If

End Sub

Private Sub PasarLineaListaProducto(fView As lfQuickView, sCodigoProducto As String, sDescripcion As String, vmPrecioUnitario As Currency, vmCantidad As Currency, vmTotVenta As Currency, vmIVA As Currency, sLinea As String)
    
    If fView.Linea > fView.LineasPagina - 2 Then
        EncabezadoListaProductos fView
    End If
    
    CheckRuptura fView, sLinea
    PrintLineaListaProducto fView, sCodigoProducto, sDescripcion, vmPrecioUnitario, vmCantidad, vmTotVenta, vmIVA
    SubTotal1 = SubTotal1 + vmTotVenta: SubTotal2 = SubTotal2 + vmIVA

End Sub

Public Sub ListarProductos(ilngNumeroSesion As Long)
'SELECT R.Producto, I.Descripcion, R.PrecioUnitario, R.PorcentajeImpuesto, Sum(R.Cantidad) AS Cantidad, Sum(R.Cantidad * R.PrecioUnitario) AS Total, Sum( Int( (R.Cantidad * R.PrecioUnitario * R.PorcentajeImpuesto / 100) + 0.99)) AS ValorImpuesto
'FROM RenglonesFacturaPOS AS R, itemsVenta AS I, FacturasPOS AS F
'Where f.idSesion = paramIdSesion And r.IDMaquina = f.IDMaquina And r.NumeroTicket = f.NumeroTicket And i.Codigo = r.Producto
'GROUP BY R.Producto, R.PrecioUnitario, R.PorcentajeImpuesto, I.Descripcion
'ORDER BY R.Producto;
Dim rs As Recordset, qry As String, f As lfQuickView

    Set pSesion = New clsSesionPOS
    If Not pSesion.Load(ilngNumeroSesion) Then
        Set pSesion = Nothing
        Exit Sub
    End If
    sTag = "ANDAPALAVERGAMOLLEJUO"
    qry = "SELECT R.Producto, I.Descripcion, I.Linea, R.Precio As PrecioUnitario, R.PorcentajeImpuesto, Sum(R.Cantidad) AS Cantidad, Sum(R.Cantidad * R.Precio) AS Total, Sum(R.Cantidad * R.Precio * R.PorcentajeImpuesto / 100) AS ValorImpuesto "
    qry = qry & "FROM tmpResumenPOS AS R, itemsVenta AS I "
    qry = qry & "WHERE R.Sesion = " & Trim(Str(pSesion.SessionID)) & " "
    qry = qry & "AND i.Codigo = r.Producto "
    qry = qry & "GROUP BY R.Producto, I.Linea, R.Precio, R.PorcentajeImpuesto, I.Descripcion ORDER BY I.Linea, I.Descripcion;"

    Screen.MousePointer = vbHourglass
    On Error Resume Next
    Set rs = dbHandle.Execute(qry)
    If Err.Number <> 0 Then
      Set rs = Nothing
    Else
      If rs.EOF Then
        rs.Close
        Set rs = Nothing
      End If
    End If
    Screen.MousePointer = vbDefault
    On Error GoTo 0

    If rs Is Nothing Then
      qry = "SELECT R.Producto, I.Descripcion, I.Linea, R.PrecioUnitario, R.PorcentajeImpuesto, Sum(R.Cantidad) AS Cantidad, Sum(R.Cantidad * R.PrecioUnitario) AS Total, Sum(R.Cantidad * R.PrecioUnitario * R.PorcentajeImpuesto / 100) AS ValorImpuesto "
      qry = qry & "FROM RenglonesFacturaPOS AS R, itemsVenta AS I, FacturasPOS AS F "
      qry = qry & "Where f.idSesion = " & Trim(Str(pSesion.SessionID)) & " And r.IDMaquina = f.IDMaquina And r.NumeroTicket = f.NumeroTicket And i.Codigo = r.Producto "
      qry = qry & "GROUP BY R.Producto, I.Linea, R.PrecioUnitario, R.PorcentajeImpuesto, I.Descripcion ORDER BY I.Linea, I.Descripcion;"
  
      Screen.MousePointer = vbHourglass
      Set rs = dbHandle.Execute(qry)
      Screen.MousePointer = vbDefault
    End If

    If Not rs.EOF Then
        Screen.MousePointer = vbHourglass
        Set f = New lfQuickView
        
        SubTotal1 = 0: SubTotal2 = 0: SubTotal3 = 0
        sTag = ""
        
        f.SetReportWidth 144
        f.Caption = "Lista de productos vendidos en el turno"

        EncabezadoListaProductos f
        Do While Not rs.EOF
          PasarLineaListaProducto f, rs!Producto, rs!Descripcion, rs!PrecioUnitario, rs!Cantidad, rs!Total, rs!ValorImpuesto, rs!Linea
          rs.MoveNext
        Loop
        CheckRuptura f, "ANDAPALAVERGAMOLLEJUO"
        PrintLineaListaProducto f, "TOTAL", "", 0, 0, Total1, Total2

        If f.Linea > f.LineasPagina - 10 Then
          f.PageBreak
        End If

        Dim TotalCobrado As Currency
        TotalCobrado = Total1 + Total2
        With pSesion
          TotalCobrado = TotalCobrado - (.EfectivoEnCaja + .ChequesEnCaja + .TTCAmex + .TTCMaster + .TTCOtras + .TTCVisa + .TDebito + .OtrosMedios + .VentasACredito)
          f.Add String(39, "="), vbCenter
          f.Add stFullLength("MEDIO", 26) & stRightAlign("MONTO", 13), vbCenter
          f.Add String(39, "="), vbCenter
          If .EfectivoEnCaja + TotalCobrado <> 0 Then
            f.Add stFullLength("EFECTIVO", 26) & FormatNumero(.EfectivoEnCaja + TotalCobrado, "#,##0.00", 13), vbCenter
          End If
          If .ChequesEnCaja <> 0 Then
            f.Add stFullLength("CHEQUES", 26) & FormatNumero(.ChequesEnCaja, "#,##0.00", 13), vbCenter
          End If
          If .TTCVisa <> 0 Then
            f.Add stFullLength("VISA", 26) & FormatNumero(.TTCVisa, "#,##0.00", 13), vbCenter
          End If
          If .TTCMaster <> 0 Then
            f.Add stFullLength("MASTER", 26) & FormatNumero(.TTCMaster, "#,##0.00", 13), vbCenter
          End If
          If .TTCAmex <> 0 Then
            f.Add stFullLength("AMEX", 26) & FormatNumero(.TTCAmex, "#,##0.00", 13), vbCenter
          End If
          If .TTCOtras <> 0 Then
            f.Add stFullLength("Otras TC", 26) & FormatNumero(.TTCOtras, "#,##0.00", 13), vbCenter
          End If
          If .TDebito <> 0 Then
            f.Add stFullLength("TARJETAS DEBITO", 26) & FormatNumero(.TDebito, "#,##0.00", 13), vbCenter
          End If
          If .OtrosMedios <> 0 Then
            f.Add stFullLength("OTROS MEDIOS", 26) & FormatNumero(.OtrosMedios, "#,##0.00", 13), vbCenter
          End If
          If .VentasACredito <> 0 Then
            f.Add stFullLength("CREDITO", 26) & FormatNumero(.VentasACredito, "#,##0.00", 13), vbCenter
          End If
        End With
        
        Screen.MousePointer = vbDefault
        ShowNonModal f

        Unload f
        Set f = Nothing
    
    End If
    
    Set rs = Nothing
    Set pSesion = Nothing

End Sub


