VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaProdVend"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 132

Private fView As lfQuickView
Private totVenta As Currency
Private sCodVend As String, sNombreVend As String
Private finic As Date, ffinal As Date

'Descripcion, CodigoItem, CantVend, PrecioEfectivo, PrecioLista
'SELECT I.Descripcion, D.CodigoItem, SUM(D.Cantidad) AS CantVend, SUM(D.Cantidad * D.PrecioVenta) AS PrecioEfectivo, SUM(D.Cantidad * D.PrecioReferencia) AS PrecioLista
'FROM DetallesItemVenta AS D, ItemsVenta AS I
'WHERE D.CodigoVendedor = paramCodVend
'      AND  D.FechaOperacion BETWEEN paramfInic AND paramfFinal
'      AND D.CodigoItem = I.Codigo
'GROUP BY D.CodigoItem, I.Descripcion
'ORDER BY I.Descripcion;
'------------------------------------------------------------------------------------------------------------------------------------
'Descripcion del Producto                 Codigo                     Cantidad   Precio Lista   Precio Venta %Desc.      Total Vendido
'------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999,99 999.999.999,99 999.99 999.999.999.999,99

Private Sub WriteLinea( _
            sDescProd As String, _
            sCodProd As String, _
            dCantidad As Double, _
            vPrecioLista As Currency, _
            vPrecioVenta As Currency, _
            vMontoVenta As Currency)
Dim sOut As String, dDescuento As Double

    If vPrecioLista = 0 Then
        dDescuento = 0
    ElseIf vPrecioVenta = 0 Then
        dDescuento = 100
    Else
        dDescuento = lmProporciones.CalcPDescuento(vPrecioLista, vPrecioVenta)
    End If

    sOut = stFullLength(sDescProd, 40) & " " & _
           stFullLength(sCodProd, 20) & " " & _
           FormatNumero(dCantidad, Empresa.MascaraCantidades, 14) & " " & _
           FormatNumero(vPrecioLista, Empresa.MascaraPrecios, 14) & " " & _
           FormatNumero(vPrecioVenta, Empresa.MascaraPrecios, 14) & " " & _
           FormatNumero(dDescuento, "##0.00", 6) & " " & _
           FormatNumero(vMontoVenta, Empresa.MascaraMonetarios, 18)
    
    fView.Add sOut

End Sub

Private Sub Encabezado()

    If fView.Linea > 1 Or fView.Pagina > 1 Then
        WriteLinea "VAN", "", 0, 0, 0, totVenta
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Venta por Productos del Vendedor " & sNombreVend, AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(fView.Pagina)

    fView.Add String(AnchoReporte, "-")
    fView.Add "Descripcion del Producto                 Codigo                     Cantidad   Precio Lista   Precio Venta %Desc.      Total Vendido"
    fView.Add String(AnchoReporte, "-")

    If fView.Pagina > 1 Then
        WriteLinea "VIENEN", "", 0, 0, 0, totVenta
    End If

End Sub

Private Sub PasarLinea(sDescripcion As String, sCodigoItem As String, dCantVend As Double, vPrecioEfectivo As Currency, vPrecioLista As Currency)
Dim lPrecioVenta As Currency, lPrecioLista As Currency

    If fView.Linea >= fView.LineasPagina - 2 Then
        Encabezado
    End If

    If dCantVend = 0 Then
        lPrecioVenta = 0
        lPrecioLista = 0
    Else
        lPrecioVenta = vPrecioEfectivo / dCantVend
        lPrecioLista = vPrecioLista / dCantVend
    End If
    
    WriteLinea sDescripcion, sCodigoItem, dCantVend, lPrecioLista, lPrecioVenta, vPrecioEfectivo
    
    totVenta = totVenta + vPrecioEfectivo
    
End Sub

Public Sub Generar(istCodVend As String, istNombreVend As String)
Dim fFechas As lfSelectRangoFechas, bResult As Boolean
Dim sQuery As String, rs As Recordset

    sCodVend = istCodVend: sNombreVend = istNombreVend

    Set fFechas = New lfSelectRangoFechas
    fFechas.Show 1
    
    bResult = fFechas.Result
    If bResult Then
        finic = fFechas.dtFechaInicial
        ffinal = fFechas.dtFechaFinal
    End If
    
    Unload fFechas
    Set fFechas = Nothing
    
    If Not bResult Then Exit Sub
    
'Descripcion, CodigoItem, CantVend, PrecioEfectivo, PrecioLista

    sQuery = "SELECT I.Descripcion, D.CodigoItem, SUM(D.Cantidad) AS CantVend, SUM(D.Cantidad * D.PrecioVenta) AS PrecioEfectivo, SUM(D.Cantidad * D.PrecioReferencia) AS PrecioLista"
    sQuery = sQuery & " FROM DetallesItemVenta AS D, ItemsVenta AS I"
    sQuery = sQuery & " WHERE D.CodigoVendedor = " & StringDB(sCodVend)
    sQuery = sQuery & " AND  D.FechaOperacion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal)
    sQuery = sQuery & " AND D.CodigoItem = I.Codigo"
    sQuery = sQuery & " GROUP BY D.CodigoItem, I.Descripcion"
    sQuery = sQuery & " ORDER BY I.Descripcion;"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    Screen.MousePointer = vbDefault

    If Not rs.EOF Then
    
        Set fView = New lfQuickView
        
        Screen.MousePointer = vbDefault

        fView.SetReportWidth AnchoReporte
        fView.Caption = "Productos vendidos por " & sNombreVend

        Encabezado
        
        Do While Not rs.EOF
        
            PasarLinea rs!Descripcion, rs!CodigoItem, rs!CantVend, rs!PrecioEfectivo, rs!PrecioLista
            rs.MoveNext

        Loop
        
        WriteLinea "TOTAL", "", 0, 0, 0, totVenta
        fView.SetNotify Me

        Screen.MousePointer = vbDefault

        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
        
    End If
    
    rs.Close
    Set rs = Nothing

End Sub

