VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaProdCli"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 110

Private ControlTag As String, DescTag As String
Private pFiltro As clsFiltroProdCli
Private fView As lfQuickView
Private titleSent As Boolean
Private SubTotal As Currency, Total As Currency
Private SubCantidad As Double, totCantidad As Double

'Nombre de la Empresa
'Ventas por Cliente y Producto | Producto y Cliente
'Entre el XXXXXXXXXX y el XXXXXXXXXX

'Fecha de Emision: XXXXXXXXXX. Operador: XXXXXXXXXX.     Pgina: 999
'-------------------------------------------------------------------------------------------------------------
'CODIGO PRODUCTO      DESCRIPCION                                     PRECIO       UNIDADES              TOTAL
'CODIGO CLIENTE       NOMBRE                                          PRECIO       UNIDADES              TOTAL
'-------------------------------------------------------------------------------------------------------------
'CLIENTE: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX (XXXXXXXX)
'PRODUCTO: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX (XXXXXXX)
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999,99 999.999.999.999,99
'TOTAL CLIENTE        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                               999.999.999.999,99
'TOTAL PRODUCTO       XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                               999.999.999.999,99
'TOTAL GENERAL                                                                              999.999.999.999,99

Private Sub Encabezado(isRuptura As Boolean)
Dim sOut As String

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        fView.PageBreak
    End If

    fView.Add ""

    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign(IIf(pFiltro.sortByCliente, "Ventas por Cliente y Producto", "Ventas por Producto y Cliente"), AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(pFiltro.FechaInicial, "Short Date") & " y el " & Format(pFiltro.FechaFinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo & ".     Pgina: " & fView.Pagina
    
    fView.Add String(AnchoReporte, "-")
    If pFiltro.sortByCliente Then
        fView.Add "CODIGO PRODUCTO      DESCRIPCION                                      PRECIO       UNIDADES              TOTAL"
    Else
        fView.Add "CODIGO CLIENTE       NOMBRE                                           PRECIO       UNIDADES              TOTAL"
    End If
    fView.Add String(AnchoReporte, "-")

    If Not isRuptura Then
        sOut = IIf(pFiltro.sortByCliente, "CLIENTE: ", "PRODUCTO: ")
        sOut = sOut & DescTag & " (" & ControlTag & ")"
        fView.Add sOut
    End If

End Sub


Private Sub PrintLinea(sCodigo As String, sDescripcion As String, ByVal vmPrecio As Currency, ByVal dCantidad As Double, ByVal vmTotal As Currency)
Dim sOut As String

    sOut = stFullLength(sCodigo, 20) & " "
    sOut = sOut & stFullLength(sDescripcion, 40) & " "
    sOut = sOut & FormatNumero(vmPrecio, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(dCantidad, Empresa.MascaraCantidades, 14) & " "
    sOut = sOut & FormatNumero(vmTotal, "###,###,###,##0.00", 18)
    
    fView.Add sOut

End Sub

Private Sub Ruptura()
Dim sOut As String

    If ControlTag <> "" Then
        PrintLinea IIf(pFiltro.sortByCliente, "TOTAL CLIENTE", "TOTAL PRODUCTO"), DescTag, 0, SubCantidad, SubTotal
    End If

    ControlTag = IIf(pFiltro.sortByCliente, pFiltro.CodigoCliente, pFiltro.CodigoItem)
    DescTag = IIf(pFiltro.sortByCliente, pFiltro.NombreCliente, pFiltro.Descripcion)
    SubTotal = 0: SubCantidad = 0

    If fView.Linea > fView.LineasPagina - 4 Then
        Encabezado True
    Else
        fView.Add ""
    End If
    
    If ControlTag <> "" Then
        fView.Add IIf(pFiltro.sortByCliente, "CLIENTE: ", "PRODUCTO: ") & DescTag & " (" & ControlTag & ")"
    End If

End Sub

Private Sub AddLinea(sCodCli As String, sNombreCli As String, sCodProd As String, sNombreProd As String, ByVal vmPrecio As Currency, ByVal dUnidades As Double)
Dim sCodigo As String, sDescripcion As String
    
    If pFiltro.sortByCliente Then
        If sCodCli <> ControlTag Then Ruptura
        sCodigo = sCodProd
        sDescripcion = sNombreProd
    Else
        If sCodProd <> ControlTag Then Ruptura
        sCodigo = sCodCli
        sDescripcion = sNombreCli
    End If

    If (fView.Linea + 4 >= fView.LineasPagina) Then
        Encabezado False    ' i.e. no es encabezado "de ruptura"
    End If

    PrintLinea sCodigo, sDescripcion, vmPrecio, dUnidades, vmPrecio * dUnidades

    SubTotal = SubTotal + vmPrecio * dUnidades
    Total = Total + vmPrecio * dUnidades
    SubCantidad = SubCantidad + dUnidades
    totCantidad = totCantidad + dUnidades
    
End Sub

Public Sub Generar()

    Set pFiltro = New clsFiltroProdCli

    If pFiltro.ProximoItem Then
        Screen.MousePointer = vbHourglass
        Set fView = New lfQuickView
        fView.Caption = "Ventas por Cliente/Producto"
        fView.SetReportWidth AnchoReporte
        fView.SetNotify Me

        ControlTag = "": DescTag = ""
        SubTotal = 0: Total = 0
        SubCantidad = 0: totCantidad = 0
        
        Encabezado True

        Do

            AddLinea pFiltro.CodigoCliente, pFiltro.NombreCliente, pFiltro.CodigoItem, pFiltro.Descripcion, pFiltro.PrecioVenta, pFiltro.Cantidad

        Loop While pFiltro.ProximoItem

        Ruptura
        PrintLinea "TOTAL", "Total General", 0, totCantidad, Total
        
        Screen.MousePointer = vbDefault
    
        fView.Show
        While fView.Visible: DoEvents: Wend
        Unload fView
        Set fView = Nothing
    
    End If

    Set pFiltro = Nothing

End Sub

Public Sub ReportClicked(txLinea As String, clickPos As Long)
Dim sTexto As String, sPalabra As String, bFound As Boolean
Dim pProducto As clsItemVenta, pCliente As clsClientes
Dim isCliente As Boolean

    sTexto = Trim(txLinea)
    If pFiltro.sortByCliente Then
        sPalabra = "CLIENTE:"
    Else
        sPalabra = "PRODUCTO:"
    End If

    If InStr(1, sTexto, sPalabra) > 0 Then
        sPalabra = sExtractRightCode(sTexto)
        isCliente = pFiltro.sortByCliente
    Else
        sPalabra = Trim(Left(sTexto, 20))
        isCliente = Not pFiltro.sortByCliente
    End If

    If isCliente Then
        Set pCliente = New clsClientes
        If pCliente.Load(sPalabra) Then
            pCliente.Show
        End If
        Set pCliente = Nothing
    Else
        Set pProducto = New clsItemVenta
        If pProducto.Load(sPalabra) Then
            pProducto.Show
        End If
        Set pProducto = Nothing
    End If

End Sub
