VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaOrdenesProveedor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private fView As lfQuickView
Private sCodProv As String, sNombreProv As String

Private Const AnchoReporte = 75

'Empresa.
'Listado de Cotizaciones
'Cliente: XXXXXXXXXXXXXXXXXX
'Emision: 99-99-9999.  Operador: XXXXXXXX.       Pgina: 999
'---------------------------------------------------------------------------
'Numero  Fecha      Monto Ordenado Estado     Notas
'---------------------------------------------------------------------------
'0000000 99-99-9999 999.999.999,99 SATISFECHA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
'                                  APROBADA
'                                  EN PROCESO
'                                  INICIAL

Private Sub Encabezado()

    If fView.Pagina > 1 Or fView.Linea > 1 Then
    
        fView.PageBreak
    
    End If

    fView.Add ""
    fView.Add ""

    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Listado de Ordenes de Compra", vbCenter
    fView.Add "Proveedor: " & sNombreProv, vbCenter
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".       Pgina: " & fView.Pagina
    fView.Add String(AnchoReporte, "-")
    fView.Add "Numero  Fecha      Monto Ordenado Estado     Notas"
    fView.Add String(AnchoReporte, "-")
    
End Sub

Private Sub PasarOrden(pOrden As clsOrdenesCompra)
Dim sOutString As String, vComents As Variant
Dim i As Integer, nComments As Integer

    With pOrden
    
    vComents = Convert2Lines(.Notas, 40)

    sOutString = Format(.Numero, "0000000") & " "
    sOutString = sOutString & stFullLength(Format(.FechaTransaccion, "Short Date"), 10) & " "
    sOutString = sOutString & FormatNumero(.CostoMercancia, Empresa.MascaraMonetarios, 14) & " "
    sOutString = sOutString & stFullLength(.ImagenEstado, 10) & " "
    On Error Resume Next
    sOutString = sOutString & vComents(1)
    If Err.Number <> 0 Then
        Err.Clear
        nComments = 0
    Else
        nComments = UBound(vComents)
    End If
    End With

    If fView.Linea > fView.LineasPagina - nComments - 2 Then
        Encabezado
    End If

    fView.Add sOutString
    
    For i = 2 To nComments
    
        sOutString = String(46, " ") & vComents(i)
        fView.Add sOutString
    
    Next

End Sub

Public Sub Go(istrCodProv As String, istrNombreProv As String)
Dim pOrden As clsOrdenesCompra, colCots As Collection

    Set pOrden = New clsOrdenesCompra
    Set colCots = pOrden.OrdenesProveedor(istrCodProv, 3)
    
    If colCots.Count Then
    
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        sCodProv = istrCodProv
        sNombreProv = istrNombreProv

        fView.SetNotify Me
        
        Encabezado
        For Each pOrden In colCots
        
            PasarOrden pOrden
    
        Next

        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing

    End If
    
    Set colCots = Nothing
    Set pOrden = Nothing

End Sub

Public Sub ReportClicked(istrTexto As String, nPos As Long)
Dim lng As Long, fView As frmViewOrdenesCompra

    lng = Val(Trim(Left(istrTexto, 8)))
    If lng <= 0 Then Exit Sub

    Set fView = New frmViewOrdenesCompra
    If fView.SetOrden(lng) Then
        ShowNonModal fView
    End If
    
    Unload fView
    Set fView = Nothing

End Sub

