VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaOrdenadasItem"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'----------------------------------------------------------------------------------------------------
'Orden   Proveedor                                        Precio Unidad         Pendientes    Entrega
'----------------------------------------------------------------------------------------------------
'0000000 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 XXXXXXXXXXXX 9.999.999.99 99-99-9999

'SELECT O.Numero, P.Nombre, R.PrecioRequerido, R.Presentacion, R.Cantidad, R.Cantidad - R.Recibidas AS QPendientes, O.FechaRequerido
'FROM ocOrdenes AS O, Proveedores AS P, ocDetalles AS R
'WHERE R.CodigoItem = PARAMITEMCODE AND R.Cantidad > R.Recibidas AND R.NumeroDocumento = O.Numero AND O.Estado = 0 AND O.CodigoProveedor = P.Codigo;

Private Const AnchoReporte = 100

Private fView As lfQuickView
Private qPendientes As Double
Private pItem As clsItemInventario

Public Sub PasarTotal(sTitulo As String)
    fView.Add stFullLength(sTitulo, 77) & FormatNumero(qPendientes, Empresa.MascaraCantidades, 12)
End Sub

Private Sub Encabezado()

    If fView.Linea > 1 Then
        PasarTotal "VAN"
        fView.PageBreak
    End If
    fView.Add ""
    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Ordenes de Compra Pendientes", vbCenter
    fView.Add "Artculo: " & pItem.Descripcion & " (" & pItem.Codigo & ")", vbCenter

    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".       Pgina: " & fView.Pagina
    fView.Add String(AnchoReporte, "-")
    fView.Add "Orden   Proveedor                                        Precio Unidad         Pendientes    Entrega"
    fView.Add String(AnchoReporte, "-")
    If fView.Pagina > 1 Then
        PasarTotal "VIENEN"
    End If

End Sub

Public Sub Go(ipItem As clsItemInventario)
Dim sQuery As String, rs As Recordset
Dim sOut As String

    Set pItem = ipItem
    sQuery = "SELECT O.Numero, P.Nombre, R.PrecioRequerido, R.Presentacion, R.Cantidad, R.Cantidad - R.Recibidas AS QPendientes, O.FechaRequerido "
    sQuery = sQuery & "FROM ocOrdenes AS O, Proveedores AS P, ocDetalles AS R "
    sQuery = sQuery & "WHERE R.CodigoItem = " & StringDB(ipItem.Codigo) & " AND R.Cantidad > R.Recibidas AND R.NumeroDocumento = O.Numero "
    sQuery = sQuery & "AND O.Estado = 0 AND O.CodigoProveedor = P.Codigo;"
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.SetNotify Me
        Encabezado
        qPendientes = 0
        Do
            sOut = Format(GetNumeroFromVariant(rs!Numero), "0000000") & " "
            sOut = sOut & stFullLength(GetStringFromVariant(rs!Nombre), 40) & " "
            sOut = sOut & FormatNumero(GetNumeroFromVariant(rs!PrecioRequerido), Empresa.MascaraPrecios, 14) & " "
            sOut = sOut & stFullLength(GetStringFromVariant(rs!Presentacion), 12) & " "
            sOut = sOut & FormatNumero(GetNumeroFromVariant(rs!qPendientes), Empresa.MascaraCantidades, 12) & " "
            sOut = sOut & stRightAlign(Format(GetDateFromVariant(rs!FechaRequerido), "Short Date"), 10)
            
            If fView.Linea > fView.LineasPagina - 3 Then
                Encabezado
            End If
            
            fView.Add sOut
            qPendientes = qPendientes + GetNumeroFromVariant(rs!qPendientes)
            
            rs.MoveNext
        
        Loop While Not rs.EOF
        PasarTotal "TOTAL"
        ShowNonModal fView
        Unload fView
        Set fView = Nothing
    End If
    Set rs = Nothing

End Sub

Public Sub ReportClicked(istrTexto As String, nPos As Long)
Dim lng As Long, fView As frmViewOrdenesCompra

    lng = Val(Trim(left(istrTexto, 8)))
    If lng <= 0 Then Exit Sub

    Set fView = New frmViewOrdenesCompra
    If fView.SetOrden(lng) Then
        ShowNonModal fView
    End If
    
    Unload fView
    Set fView = Nothing

End Sub

