VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaOC"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoCronologico = 131, AnchoPorProveedor = 70

Dim fView As lfQuickView
Dim finic As Date, ffinal As Date
Dim AnchoReporte As Long, bPorProveedor As Boolean
Dim ControlTag As String, sNombreTag As String

Private Sub Encabezado(isRuptura As Boolean)
    
    If fView.Linea > 1 Or fView.Pagina > 1 Then
        
        fView.PageBreak
        
    End If

    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add stMidAlign("Listado General de Ordenes de Compra", AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
    
    fView.Add String(AnchoReporte, "-")
    If bPorProveedor Then
        fView.Add "Numero  Emisin             Monto      Impuesto Requerido  Estado"
    Else
        fView.Add "Numero  Codigo Proveedor     Nombre del Proveedor                    Emisin             Monto      Impuesto Requerido  Estado"
    End If
    fView.Add String(AnchoReporte, "-")

    If fView.Pagina > 1 Then
        If bPorProveedor Then
            If Not isRuptura Then
                fView.Add "PROVEEDOR: " & sNombreTag & "... (" & ControlTag & ")"
            End If
        End If
    End If

End Sub

'-----------------------------------------------------------------------------------------------------------------------------------
'Numero  Codigo Proveedor     Nombre del Proveedor                    Emisin             Monto      Impuesto Requerido  Estado
'-----------------------------------------------------------------------------------------------------------------------------------
'0000000 XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99-99-9999 999.999.999,99 99.999.999,99 99-99-9999 XXXXXXXXXXX

Private Sub PrintLineaC(NumOC As Long, _
                        sNombreProv As String, _
                        sCodProv As String, _
                        sFecha As String, _
                        vmCompra As Currency, _
                        vmIVA As Currency, _
                        sFechaRequerido As String, _
                        sEstado As String)
Dim sOut As String

    sOut = Format(NumOC, "0000000") & " "
    sOut = sOut & stFullLength(sCodProv, 20) & " "
    sOut = sOut & stFullLength(sNombreProv, 40) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & FormatNumero(vmCompra, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmIVA, Empresa.MascaraMonetarios, 13) & " "
    sOut = sOut & stFullLength(sFechaRequerido, 10) & " "
    sOut = sOut & stFullLength(sEstado, 11)

    fView.Add sOut

End Sub

'----------------------------------------------------------------------
'Numero  Emisin             Monto      Impuesto Requerido  Estado
'----------------------------------------------------------------------
'0000000 99-99-9999 999.999.999,99 99.999.999,99 99-99-9999 XXXXXXXXXXX

Private Sub PrintLineaP(NumOC As Long, sFecha As String, vmCompra As Currency, vmIVA As Currency, sFechaRequerido As String, sEstado As String)
Dim sOut As String

    sOut = Format(NumOC, "0000000") & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & FormatNumero(vmCompra, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmIVA, Empresa.MascaraMonetarios, 13) & " "
    sOut = sOut & stFullLength(sFechaRequerido, 11) & " "
    sOut = sOut & stFullLength(sEstado, 11)
    
    fView.Add sOut

End Sub

Private Sub Ruptura(sNewTag As String, sNewName As String)

    If sNewTag = "" Then
        fView.Add ""
        Exit Sub
    End If

    If fView.Linea > fView.LineasPagina - 4 Then
        Encabezado True
    Else
        fView.Add ""
    End If
    
    ControlTag = sNewTag
    sNombreTag = sNewName
    
    fView.Add "PROVEEDOR: " & sNombreTag & " (" & ControlTag & ")"

End Sub


Private Sub PasarLinea(lngNumOC As Long, _
                       stNombreProveedor As String, _
                       stCodigoProveedor As String, _
                       dtFechaTransaccion As Date, _
                       vmValorCompra As Currency, _
                       vmImpuesto As Currency, _
                       sEstado As String, _
                       dtFechaRequerido As Date)
                    
    If bPorProveedor Then
        If stCodigoProveedor <> ControlTag Then
            Ruptura stCodigoProveedor, stNombreProveedor
        End If
    End If

    If fView.Linea > fView.LineasPagina - 2 Then
        Encabezado False
    End If
    
    If bPorProveedor Then
        PrintLineaP lngNumOC, Format(dtFechaTransaccion, "Short Date"), vmValorCompra, vmImpuesto, Format(dtFechaRequerido, "Short Date"), sEstado
    Else
        PrintLineaC lngNumOC, stNombreProveedor, stCodigoProveedor, Format(dtFechaTransaccion, "Short Date"), vmValorCompra, vmImpuesto, Format(dtFechaRequerido, "Short Date"), sEstado
    End If

End Sub


'SELECT C.*
'FROM Compras AS C, Proveedores AS P
'WHERE C.FechaTransaccion BETWEEN #2000-01-01# AND #2000-08-10#
'AND       C.CodigoProveedor = P.Codigo
'ORDER BY C.FechaTransaccion, C.Numero;

Public Sub Generar()
Dim rs As Recordset, f As frmFiltroProveedores
Dim sQuery As String, sNext As String
Dim pOrden As clsOrdenesCompra

    Set f = New frmFiltroProveedores
    f.SetInterval True
    f.Caption = "Listado de Facturas de Compra"
    ShowNonModal f
    
    If Not f.Result Then
        Unload f
        Set f = Nothing
        Exit Sub
    End If

    bPorProveedor = f.sortByProveedor
    finic = f.ucSelectRango1.FechaInicial
    ffinal = f.ucSelectRango1.FechaFinal

    sQuery = "SELECT C.Numero FROM ocOrdenes C, Proveedores P WHERE C.FechaTransaccion " & f.ClausulaRango
    sQuery = sQuery & " AND C.CodigoProveedor = P.Codigo"
    sNext = f.FiltroSQL("P")
    If sNext <> "" Then sQuery = sQuery & " AND " & sNext
    If bPorProveedor Then
        sQuery = sQuery & " ORDER BY C.CodigoProveedor, C.FechaTransaccion, C.Numero"
    Else
        sQuery = sQuery & " ORDER BY C.FechaTransaccion, C.Numero"
    End If
        
    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    
    Unload f
    Set f = Nothing

    If Not rs.EOF Then
    
        If bPorProveedor Then
            AnchoReporte = AnchoPorProveedor
        Else
            AnchoReporte = AnchoCronologico
        End If
        Set pOrden = New clsOrdenesCompra
        
        Set fView = New lfQuickView
        fView.SetReportWidth (AnchoReporte)
        fView.Caption = "Listado General de Ordenes de Compra"
        fView.SetNotify Me

        ControlTag = "": sNombreTag = ""

        Encabezado False
        
        Do While Not rs.EOF
        
            If pOrden.Load(GetNumeroFromVariant(rs!Numero)) Then
                PasarLinea pOrden.Numero, pOrden.NombreProveedor, pOrden.CodigoProveedor, pOrden.FechaTransaccion, pOrden.ValorNominal, pOrden.Impuesto1, pOrden.ImagenEstado, pOrden.FechaRequerido
            End If
            rs.MoveNext

        Loop
        
        Set pOrden = Nothing
        Screen.MousePointer = vbDefault
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
        
    End If
    
    rs.Close
    Set rs = Nothing
    Screen.MousePointer = vbDefault
        
End Sub

Private Sub ShowProveedor(istrCodigo As String)
Dim pProveedor As clsProveedores

    Set pProveedor = New clsProveedores
    If pProveedor.Load(istrCodigo) Then
        pProveedor.Show
    End If
    Set pProveedor = Nothing

End Sub

Private Sub ShowOrden(ByVal lngNumero As Long)
Dim fView As frmViewOrdenesCompra

    Set fView = New frmViewOrdenesCompra
    If fView.SetOrden(lngNumero) Then
        ShowNonModal fView
    End If

    Unload fView
    Set fView = Nothing

End Sub
Public Sub ReportClicked(istrTexto As String, nPos As Long)
Dim lng As Long, strCodigo As String

    If bPorProveedor Then
        If Mid(istrTexto, 2, 10) = "PROVEEDOR:" Then
            strCodigo = vslib.sExtractRightCode(istrTexto)
            ShowProveedor strCodigo
        Else
            lng = Val(Trim(left(istrTexto, 8)))
            ShowOrden lng
        End If
    Else
        If nPos < 9 Then
            lng = Val(Trim(left(istrTexto, 8)))
            ShowOrden lng
        Else
            ShowProveedor Trim(Mid(istrTexto, 10, 20))
        End If
    End If

End Sub

